/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetDetailPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetDetailQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailSubjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailSubjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetSubjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.BudgetStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsBudgetConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsBudgetDetailConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetDetailDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetSubjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetDetailDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsBudgetDetailRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsBudgetRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetDetailServiceImpl
extends BaseServiceImpl
implements PmsBudgetDetailService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetDetailServiceImpl.class);
    private final PmsBudgetDetailRepo pmsBudgetDetailRepo;
    private final PmsBudgetDetailDAO pmsBudgetDetailDAO;
    private final PmsBudgetDetailSubjectService subjectService;
    private final PmsBudgetDAO pmsBudgetDAO;
    private final PmsBudgetRepo pmsBudgetRepo;
    private final PmsProjectDAO projectDAO;
    private final PmsBudgetSubjectDAO budgetSubjectDAO;
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;

    public PagingVO<PmsBudgetDetailVO> queryPaging(PmsBudgetDetailQuery query) {
        return this.pmsBudgetDetailDAO.queryPaging(query);
    }

    public List<PmsBudgetDetailVO> queryListDynamic(PmsBudgetDetailQuery query) {
        return this.pmsBudgetDetailDAO.queryListDynamic(query);
    }

    public PmsBudgetDetailVO queryByKey(Long key) {
        PmsBudgetDetailDO entity = this.pmsBudgetDetailRepo.findById(key).orElseGet(PmsBudgetDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetDetailVO vo = PmsBudgetDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(PmsBudgetPayload budgetPayload) {
        this.checkData(budgetPayload);
        List detailPayloads = budgetPayload.getBudgetDetailList();
        PmsBudgetDetailPayload detailPayload = (PmsBudgetDetailPayload)detailPayloads.get(0);
        BigDecimal totalMoney = detailPayload.getUnitPrice().multiply(detailPayload.getDays());
        detailPayload.setTotalMoney(totalMoney);
        Long budgetId = budgetPayload.getId();
        if (ObjectUtils.isEmpty((Object)budgetId)) {
            budgetPayload.setTotalMoney(totalMoney);
            budgetPayload.setUsedMoney(BigDecimal.ZERO);
            budgetPayload.setProportion(BigDecimal.ZERO);
            budgetPayload.setBudgetStatus(BudgetStatusEnum.CREATE.getCode());
            PmsBudgetDO budgetDO = PmsBudgetConvert.INSTANCE.toDo(budgetPayload);
            PmsBudgetVO budgetVO = PmsBudgetConvert.INSTANCE.toVo((PmsBudgetDO)this.pmsBudgetRepo.save(budgetDO));
            budgetId = budgetVO.getId();
            detailPayload.setBudgetId(budgetId);
            this.insert(detailPayload);
        } else {
            PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByKey(budgetId);
            if (ObjectUtils.isEmpty((Object)budgetVO)) {
                throw TwException.error("", "\u9884\u7b97\u57fa\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (BudgetStatusEnum.APPROVED.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u9884\u7b97\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u518d\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)detailPayload.getId())) {
                PmsBudgetDetailVO detailVO = this.pmsBudgetDetailDAO.queryByBudgetIdAndRole(budgetId, detailPayload.getProjectRoleId());
                if (!ObjectUtils.isEmpty((Object)detailVO)) {
                    throw TwException.error("", "\u76f8\u540c\u8282\u70b9\u4e0b\uff0c\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u9884\u7b97\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                detailPayload.setBudgetId(budgetId);
                this.insert(detailPayload);
            } else {
                PmsBudgetDetailVO detailVO = this.pmsBudgetDetailDAO.queryByKey(detailPayload.getId());
                if (!detailPayload.getProjectRoleId().equals(detailVO.getProjectRoleId()) && !ObjectUtils.isEmpty((Object)(detailVO = this.pmsBudgetDetailDAO.queryByBudgetIdAndRole(budgetId, detailPayload.getProjectRoleId())))) {
                    throw TwException.error("", "\u76f8\u540c\u8282\u70b9\u4e0b\uff0c\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u9884\u7b97\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                this.update(detailPayload);
            }
            this.updateBudgetMoney(budgetId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetDetailVO insert(PmsBudgetDetailPayload payload) {
        payload.setUsedMoney(BigDecimal.ZERO);
        payload.setProportion(BigDecimal.ZERO);
        PmsBudgetDetailDO entityDo = PmsBudgetDetailConvert.INSTANCE.toDo(payload);
        return PmsBudgetDetailConvert.INSTANCE.toVo((PmsBudgetDetailDO)this.pmsBudgetDetailRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetDetailVO update(PmsBudgetDetailPayload payload) {
        PmsBudgetDetailDO entity = this.pmsBudgetDetailRepo.findById(payload.getId()).orElseGet(PmsBudgetDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetDetailDO entityDo = PmsBudgetDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetDetailConvert.INSTANCE.toVo((PmsBudgetDetailDO)this.pmsBudgetDetailRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateUsedMoney(Long wbsId, List<PmsWbsTaskVO> list) {
        PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByWBS(wbsId);
        if (ObjectUtils.isEmpty((Object)budgetVO)) {
            throw TwException.error("", "\u9884\u7b97\u57fa\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!BudgetStatusEnum.APPROVED.getCode().equals(budgetVO.getBudgetStatus())) {
            throw TwException.error("", "\u53ea\u6709\u9884\u7b97\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\u624d\u53ef\u4ee5\u8fdb\u884c\u4efb\u52a1\u6d3e\u53d1\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long budgetId = budgetVO.getId();
        for (PmsWbsTaskVO vo : list) {
            PmsBudgetDetailVO detailVO = this.pmsBudgetDetailDAO.queryByBudgetIdAndRole(budgetId, vo.getProjectRoleId());
            if (ObjectUtils.isEmpty((Object)detailVO)) {
                throw TwException.error("", "\u9884\u7b97\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            BigDecimal addUse = detailVO.getUnitPrice().multiply(vo.getDays());
            BigDecimal usedMoney = detailVO.getUsedMoney().add(addUse);
            if (usedMoney.doubleValue() > detailVO.getTotalMoney().doubleValue()) {
                throw TwException.error("", "\u8d85\u51fa\u9884\u7b97\u5566\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            BigDecimal proportion = usedMoney.divide(detailVO.getTotalMoney(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            this.pmsBudgetDetailDAO.updateMoney(detailVO.getId(), detailVO.getTotalMoney(), usedMoney, proportion);
        }
        this.updateBudgetMoney(budgetId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBudgetMoney(Long budgetId) {
        List<PmsBudgetDetailVO> detailVOS = this.pmsBudgetDetailDAO.queryByBudgetId(budgetId);
        BigDecimal totalMoney = detailVOS.stream().map(PmsBudgetDetailVO::getTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal usedMoney = detailVOS.stream().map(PmsBudgetDetailVO::getUsedMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proportion = BigDecimal.ZERO;
        if (totalMoney.doubleValue() > 0.0) {
            proportion = usedMoney.divide(totalMoney, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        this.pmsBudgetDAO.updateMoney(budgetId, totalMoney, usedMoney, proportion);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(Long budgetId, List<Long> keys) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u9884\u7b97\u660e\u7ec6\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByKey(budgetId);
        if (ObjectUtils.isEmpty((Object)budgetVO)) {
            throw TwException.error("", "\u9884\u7b97\u57fa\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (BudgetStatusEnum.APPROVED.getCode().equals(budgetVO.getBudgetStatus())) {
            throw TwException.error("", "\u9884\u7b97\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u518d\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsBudgetDetailVO> list = this.pmsBudgetDetailDAO.queryByKeys(keys);
        for (PmsBudgetDetailVO vo : list) {
            if (!(vo.getUsedMoney().doubleValue() > 0.0)) continue;
            throw TwException.error("", " \u5df2\u7ecf\u4f7f\u7528\u8fc7\u7684\u9884\u7b97\u660e\u7ec6\u4e0d\u80fd\u518d\u88ab\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.pmsBudgetDetailDAO.deleteSoft(keys);
        this.updateBudgetMoney(budgetId);
    }

    public PmsBudgetVO queryByWbs(Long projectId, Long wbsId) {
        PmsProjectWbsVO pmsProjectWbsVO;
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("", " projectId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetVO budgetVO = new PmsBudgetVO();
        String budgetStatus = null;
        List<PmsBudgetVO> list = this.pmsBudgetDAO.queryListByProjectId(projectId);
        if (!ObjectUtils.isEmpty(list)) {
            budgetStatus = list.get(0).getBudgetStatus();
        }
        if (!ObjectUtils.isEmpty((Object)wbsId) && !ObjectUtils.isEmpty((Object)(pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(wbsId)))) {
            if (ProjectWbsTypeEnum.ACT.getCode().equals(pmsProjectWbsVO.getWbsType())) {
                budgetVO = this.pmsBudgetDAO.queryByWBS(wbsId);
                if (!ObjectUtils.isEmpty((Object)budgetVO)) {
                    List<PmsBudgetDetailVO> detailVOS = this.pmsBudgetDetailDAO.queryByBudgetId(budgetVO.getId());
                    this.transferData(detailVOS);
                    budgetVO.setBudgetDetailList(detailVOS);
                } else {
                    budgetVO = new PmsBudgetVO();
                }
            } else if (ProjectWbsTypeEnum.WBS.getCode().equals(pmsProjectWbsVO.getWbsType())) {
                list = new ArrayList<PmsBudgetVO>();
                this.getBudgetData(projectId, list, Arrays.asList(pmsProjectWbsVO.getWbsCode()));
                budgetVO.setTotalMoney(list.stream().map(PmsBudgetVO::getTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                budgetVO.setUsedMoney(list.stream().map(PmsBudgetVO::getUsedMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                BigDecimal proportion = BigDecimal.ZERO;
                if (budgetVO.getTotalMoney().doubleValue() > 0.0) {
                    proportion = budgetVO.getUsedMoney().divide(budgetVO.getTotalMoney(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                }
                budgetVO.setProportion(proportion);
            }
        }
        budgetVO.setBudgetStatus(budgetStatus);
        return budgetVO;
    }

    private void getBudgetData(Long projectId, List<PmsBudgetVO> list, List<String> parentWbsCodes) {
        List<PmsProjectWbsVO> wbsList = this.pmsProjectWbsDAO.queryByParentWbsCodes(projectId, parentWbsCodes);
        if (!ObjectUtils.isEmpty(wbsList)) {
            List<Long> wbsIdList = wbsList.stream().map(v -> v.getId()).collect(Collectors.toList());
            List<PmsBudgetVO> budgetVOS = this.pmsBudgetDAO.queryByWbsList(wbsIdList);
            if (!ObjectUtils.isEmpty(budgetVOS)) {
                list.addAll(budgetVOS);
            }
            parentWbsCodes = wbsList.stream().map(v -> v.getWbsCode()).collect(Collectors.toList());
            this.getBudgetData(projectId, list, parentWbsCodes);
        }
    }

    public String queryProjectBudgetStatus(Long projectId, Long wbsId) {
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("", " projectId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(wbsId);
        if (!ObjectUtils.isEmpty((Object)pmsProjectWbsVO)) {
            if (ProjectWbsTypeEnum.ACT.getCode().equals(pmsProjectWbsVO.getWbsType())) {
                PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByWBS(wbsId);
                if (!ObjectUtils.isEmpty((Object)budgetVO)) {
                    return budgetVO.getBudgetStatus();
                }
            } else if (ProjectWbsTypeEnum.WBS.getCode().equals(pmsProjectWbsVO.getWbsType())) {
                ArrayList<PmsBudgetVO> budgetList = new ArrayList<PmsBudgetVO>();
                this.getBudgetData(projectId, budgetList, Arrays.asList(pmsProjectWbsVO.getWbsCode()));
                if (!ObjectUtils.isEmpty(budgetList)) {
                    return ((PmsBudgetVO)budgetList.get(0)).getBudgetStatus();
                }
            }
        }
        return null;
    }

    public List<PmsBudgetVO> queryByWbsList(List<Long> wbsIds) {
        return this.pmsBudgetDAO.queryByWbsList(wbsIds);
    }

    public PmsBudgetVO queryByProject(Long projectId) {
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetVO budgetVO = new PmsBudgetVO();
        budgetVO.setBudgetControlFlag(projectVO.getBudgetControlFlag());
        budgetVO.setBudgetControlStrategyFlag(projectVO.getBudgetControlStrategyFlag());
        PmsBudgetDetailSubjectVO sv = new PmsBudgetDetailSubjectVO();
        sv.setSubjectLevel(Integer.valueOf(1));
        sv.setSubjectCode("\u9879\u76ee\u603b\u8ba1");
        List subjectList = this.subjectService.queryByProjectId(projectId);
        List<PmsBudgetVO> list = this.pmsBudgetDAO.queryListByProjectId(projectId);
        if (!ObjectUtils.isEmpty(list)) {
            List<Long> budgetIds = list.stream().map(v -> v.getId()).collect(Collectors.toList());
            List<PmsBudgetDetailVO> detailVOS = this.pmsBudgetDetailDAO.queryByBudgetIds(budgetIds);
            for (PmsBudgetDetailSubjectVO subjectVO : subjectList) {
                if (1 == subjectVO.getSubjectLevel()) {
                    subjectVO.setTotalMoney(detailVOS.stream().filter(vo -> subjectVO.getSubjectId().equals(vo.getSubjectParentId())).map(PmsBudgetDetailVO::getTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                    continue;
                }
                subjectVO.setTotalMoney(detailVOS.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getSubjectId()) && subjectVO.getSubjectId().equals(vo.getSubjectId())).map(PmsBudgetDetailVO::getTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            budgetVO.setBudgetStatus(list.get(0).getBudgetStatus());
            sv.setTotalMoney(subjectList.stream().filter(vo -> 1 == vo.getSubjectLevel() && !ObjectUtils.isEmpty((Object)vo.getTotalMoney())).map(PmsBudgetDetailSubjectVO::getTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        LinkedList<PmsBudgetDetailSubjectVO> subjectDetails = new LinkedList<PmsBudgetDetailSubjectVO>();
        subjectDetails.add(sv);
        subjectDetails.addAll(this.listByTree(subjectList));
        budgetVO.setTemplateSubjectList(subjectDetails);
        return budgetVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApprovalProcess(Long projectId) {
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsBudgetVO> list = this.pmsBudgetDAO.queryListByProjectId(projectId);
        List<Long> keys = list.stream().map(v -> v.getId()).collect(Collectors.toList());
        this.pmsBudgetDAO.updateWorkFlow(keys, LocalDateTime.now(), "11", BudgetStatusEnum.APPROVED.getCode(), LocalDateTime.now(), ProcInstStatus.APPROVED);
    }

    public void deleteSoftByWbsIds(List<Long> keys) {
        this.pmsBudgetDAO.deleteSoft(keys);
        this.pmsBudgetDetailDAO.deleteByBudgetIds(keys);
    }

    void checkData(PmsBudgetPayload budgetPayload) {
        long num;
        if (ObjectUtils.isEmpty((Object)budgetPayload.getProjectId())) {
            throw TwException.error("", "\u5173\u8054\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)budgetPayload.getWbsId())) {
            throw TwException.error("", "wbsID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)budgetPayload.getTemplateId())) {
            throw TwException.error("", "\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List detailPayloads = budgetPayload.getBudgetDetailList();
        if (ObjectUtils.isEmpty((Object)detailPayloads)) {
            throw TwException.error("", "\u9884\u7b97\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetDetailPayload detailPayload = (PmsBudgetDetailPayload)detailPayloads.get(0);
        if (ObjectUtils.isEmpty((Object)detailPayload.getSourceType())) {
            throw TwException.error("", "\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)detailPayload.getProjectRoleId())) {
            throw TwException.error("", "\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)detailPayload.getUnitPrice())) {
            throw TwException.error("", "\u89d2\u8272\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)detailPayload.getDays())) {
            throw TwException.error("", "\u5de5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)detailPayload.getSubjectParentId())) {
            throw TwException.error("", "\u4e00\u7ea7\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)detailPayload.getSubjectId()) && (num = this.subjectService.getCountByProjectAndParent(budgetPayload.getTemplateId(), detailPayload.getSubjectParentId())) > 0L) {
            throw TwException.error("", "\u5982\u679c\u4e00\u7ea7\u79d1\u76ee\u6709\u5b50\u96c6\u79d1\u76ee\uff0c\u5fc5\u987b\u9009\u4e8c\u7ea7\u79d1\u76ee\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void transferData(List<PmsBudgetDetailVO> detailVOS) {
        ArrayList<Long> subjectIds = new ArrayList<Long>();
        for (PmsBudgetDetailVO detailVO : detailVOS) {
            subjectIds.add(detailVO.getSubjectParentId());
            if (ObjectUtils.isEmpty((Object)detailVO.getSubjectId())) continue;
            subjectIds.add(detailVO.getSubjectId());
        }
        PmsBudgetSubjectQuery query = new PmsBudgetSubjectQuery();
        query.setSubjectIds(subjectIds);
        List<PmsBudgetSubjectVO> subjectList = this.budgetSubjectDAO.queryListDynamic(query);
        Map<Long, String> nameMap = subjectList.stream().collect(Collectors.toMap(BaseViewModel::getId, PmsBudgetSubjectVO::getSubjectName));
        for (PmsBudgetDetailVO detailVO : detailVOS) {
            detailVO.setSubjectParentName(nameMap.get(detailVO.getSubjectParentId()));
            if (!ObjectUtils.isEmpty((Object)detailVO.getSubjectId())) {
                detailVO.setSubjectName(nameMap.get(detailVO.getSubjectId()));
            }
            detailVO.setSourceTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:RESOURCE:TYPE", detailVO.getSourceType()));
        }
    }

    private List<PmsBudgetDetailSubjectVO> listByTree(List<PmsBudgetDetailSubjectVO> list) {
        LinkedList<PmsBudgetDetailSubjectVO> resultList = new LinkedList<PmsBudgetDetailSubjectVO>();
        List<PmsBudgetDetailSubjectVO> parentList = list.stream().filter(vo -> ObjectUtils.isEmpty((Object)vo.getSubjectParentId())).collect(Collectors.toList());
        List parentIds = parentList.stream().map(PmsBudgetDetailSubjectVO::getSubjectId).collect(Collectors.toList());
        List noparentlist = list.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getSubjectParentId()) && !parentIds.contains(vo.getSubjectParentId())).collect(Collectors.toList());
        parentList.addAll(noparentlist);
        this.sortBySubjectCode(parentList);
        Map groupedAndSorted = list.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getSubjectParentId())).collect(Collectors.groupingBy(PmsBudgetDetailSubjectVO::getSubjectParentId, Collectors.toList()));
        for (PmsBudgetDetailSubjectVO vo2 : parentList) {
            resultList.add(vo2);
            List<PmsBudgetDetailSubjectVO> subset = groupedAndSorted.get(vo2.getSubjectId());
            if (ObjectUtils.isEmpty(subset)) continue;
            groupedAndSorted.remove(vo2.getSubjectId());
            this.sortBySubjectCode(subset);
            resultList.addAll(subset);
        }
        return resultList;
    }

    void sortBySubjectCode(List<PmsBudgetDetailSubjectVO> list) {
        list.sort(new Comparator<PmsBudgetDetailSubjectVO>(){

            @Override
            public int compare(PmsBudgetDetailSubjectVO obj1, PmsBudgetDetailSubjectVO obj2) {
                String str1 = obj1.getSubjectCode();
                String str2 = obj2.getSubjectCode();
                int int1 = Integer.parseInt(str1);
                int int2 = Integer.parseInt(str2);
                boolean isStr1StartingWithZero = str1.startsWith("0");
                boolean isStr2StartingWithZero = str2.startsWith("0");
                if (isStr1StartingWithZero && !isStr2StartingWithZero) {
                    return -1;
                }
                if (!isStr1StartingWithZero && isStr2StartingWithZero) {
                    return 1;
                }
                return Integer.compare(int1, int2);
            }
        });
    }

    public PmsBudgetDetailServiceImpl(PmsBudgetDetailRepo pmsBudgetDetailRepo, PmsBudgetDetailDAO pmsBudgetDetailDAO, PmsBudgetDetailSubjectService subjectService, PmsBudgetDAO pmsBudgetDAO, PmsBudgetRepo pmsBudgetRepo, PmsProjectDAO projectDAO, PmsBudgetSubjectDAO budgetSubjectDAO, CacheUtil cacheUtil, PmsProjectWbsDAO pmsProjectWbsDAO) {
        this.pmsBudgetDetailRepo = pmsBudgetDetailRepo;
        this.pmsBudgetDetailDAO = pmsBudgetDetailDAO;
        this.subjectService = subjectService;
        this.pmsBudgetDAO = pmsBudgetDAO;
        this.pmsBudgetRepo = pmsBudgetRepo;
        this.projectDAO = projectDAO;
        this.budgetSubjectDAO = budgetSubjectDAO;
        this.cacheUtil = cacheUtil;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
    }
}

