/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetSubjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetSubjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetSubjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetTemplateSubjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsBudgetSubjectConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetSubjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsBudgetTemplateSubjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetSubjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetTemplateSubjectDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsBudgetSubjectRepo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetSubjectServiceImpl
extends BaseServiceImpl
implements PmsBudgetSubjectService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetSubjectServiceImpl.class);
    private final PmsBudgetSubjectRepo pmsBudgetSubjectRepo;
    private final PmsBudgetSubjectDAO pmsBudgetSubjectDAO;
    private final PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO;

    public PagingVO<PmsBudgetSubjectVO> queryPaging(PmsBudgetSubjectQuery query) {
        return this.pmsBudgetSubjectDAO.queryPaging(query);
    }

    public PagingVO<PmsBudgetSubjectVO> pagingByTree(PmsBudgetSubjectQuery query) {
        List<PmsBudgetSubjectVO> list = this.listByTree(query);
        List result = list.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.builder().records(result).total((long)list.size()).build();
    }

    public List<PmsBudgetSubjectVO> listByTree(PmsBudgetSubjectQuery query) {
        LinkedList<PmsBudgetSubjectVO> resultList = new LinkedList<PmsBudgetSubjectVO>();
        List<PmsBudgetSubjectVO> list = this.pmsBudgetSubjectDAO.queryListDynamic(query);
        List subjectIds = query.getSubjectIds();
        if (!ObjectUtils.isEmpty((Object)subjectIds)) {
            list = list.stream().filter(vo -> subjectIds.contains(vo.getId())).toList();
        }
        List<PmsBudgetSubjectVO> parentList = list.stream().filter(vo -> ObjectUtils.isEmpty((Object)vo.getParentId())).collect(Collectors.toList());
        List parentIds = parentList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty((Object)query.getSubjectCode()) || !ObjectUtils.isEmpty((Object)query.getSubjectName())) {
            List noparentlist = list.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getParentId()) && !parentIds.contains(vo.getParentId())).collect(Collectors.toList());
            parentList.addAll(noparentlist);
        }
        this.sortBySubjectCode(parentList);
        Map groupedAndSorted = list.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getParentId())).collect(Collectors.groupingBy(PmsBudgetSubjectVO::getParentId, Collectors.toList()));
        for (PmsBudgetSubjectVO vo2 : parentList) {
            resultList.add(vo2);
            List<PmsBudgetSubjectVO> subset = groupedAndSorted.get(vo2.getId());
            if (ObjectUtils.isEmpty(subset)) continue;
            groupedAndSorted.remove(vo2.getId());
            this.sortBySubjectCode(subset);
            resultList.addAll(subset);
        }
        return resultList;
    }

    public List<PmsBudgetSubjectVO> queryListDynamic(PmsBudgetSubjectQuery query) {
        return this.pmsBudgetSubjectDAO.queryListDynamic(query);
    }

    public PmsBudgetSubjectVO queryByKey(Long key) {
        PmsBudgetSubjectDO entity = this.pmsBudgetSubjectRepo.findById(key).orElseGet(PmsBudgetSubjectDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetSubjectVO vo = PmsBudgetSubjectConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetSubjectVO insert(PmsBudgetSubjectPayload payload) {
        this.checkData(payload);
        PmsBudgetSubjectDO entityDo = PmsBudgetSubjectConvert.INSTANCE.toDo(payload);
        PmsBudgetSubjectVO vo = PmsBudgetSubjectConvert.INSTANCE.toVo((PmsBudgetSubjectDO)this.pmsBudgetSubjectRepo.save(entityDo));
        if (!ObjectUtils.isEmpty((Object)entityDo.getParentId())) {
            List<PmsBudgetTemplateSubjectVO> list = this.pmsBudgetTemplateSubjectDAO.queryByBySubjectId(entityDo.getParentId());
            List templateIds = list.stream().map(PmsBudgetTemplateSubjectVO::getTemplateId).collect(Collectors.toList());
            ArrayList<PmsBudgetTemplateSubjectDO> dDetails = new ArrayList<PmsBudgetTemplateSubjectDO>();
            for (Long templateId : templateIds) {
                PmsBudgetTemplateSubjectDO templateSubject = new PmsBudgetTemplateSubjectDO();
                templateSubject.setSubjectId(vo.getId());
                templateSubject.setTemplateId(templateId);
                dDetails.add(templateSubject);
            }
            this.pmsBudgetTemplateSubjectDAO.saveAll(dDetails);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsBudgetSubjectDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSubjectStatus(Long[] keys, Integer subjectStatus) {
        if (ObjectUtils.isEmpty((Object[])keys)) {
            throw TwException.error("", "\u79d1\u76ee\u4e3b\u952e\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)subjectStatus)) {
            throw TwException.error("", "\u79d1\u76ee\u72b6\u6001\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.pmsBudgetSubjectDAO.updateSubjectStatus(keys, subjectStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkData(PmsBudgetSubjectPayload payload) {
        payload.setSubjectStatus(Integer.valueOf(0));
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            PmsBudgetSubjectVO byCodeVo;
            vo = this.pmsBudgetSubjectDAO.queryByKey(payload.getId());
            if (ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error("", "\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (!vo.getSubjectCode().equals(payload.getSubjectCode()) && !ObjectUtils.isEmpty((Object)(byCodeVo = this.pmsBudgetSubjectDAO.queryByCode(payload.getSubjectCode())))) {
                throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            if (!vo.getSubjectName().equals(payload.getSubjectName()) && !ObjectUtils.isEmpty((Object)(byCodeVo = this.pmsBudgetSubjectDAO.queryByName(payload.getSubjectName())))) {
                throw TwException.error("", "\u79d1\u76ee\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            vo = this.pmsBudgetSubjectDAO.queryByCode(payload.getSubjectCode());
            if (!ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            vo = this.pmsBudgetSubjectDAO.queryByName(payload.getSubjectName());
            if (!ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error("", "\u79d1\u76ee\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        if (payload.getParentId() != null) {
            PmsBudgetSubjectVO pmsBudgetSubjectVO = this.pmsBudgetSubjectDAO.queryByKey(payload.getParentId());
            if (pmsBudgetSubjectVO == null) throw TwException.error("", "\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (1 != pmsBudgetSubjectVO.getSubjectLevel()) throw TwException.error("", "\u4e0a\u7ea7\u79d1\u76ee\u5fc5\u987b\u662f\u4e00\u7ea7\u79d1\u76ee\uff0c\u8bf7\u6838\u9a8c\uff01");
            payload.setSubjectLevel(Integer.valueOf(2));
            payload.setParentName(pmsBudgetSubjectVO.getSubjectName());
            return;
        } else {
            payload.setSubjectLevel(Integer.valueOf(1));
        }
    }

    void sortBySubjectCode(List<PmsBudgetSubjectVO> list) {
        list.sort(new Comparator<PmsBudgetSubjectVO>(){

            @Override
            public int compare(PmsBudgetSubjectVO obj1, PmsBudgetSubjectVO obj2) {
                String str1 = obj1.getSubjectCode();
                String str2 = obj2.getSubjectCode();
                int int1 = Integer.parseInt(str1);
                int int2 = Integer.parseInt(str2);
                boolean isStr1StartingWithZero = str1.startsWith("0");
                boolean isStr2StartingWithZero = str2.startsWith("0");
                if (isStr1StartingWithZero && !isStr2StartingWithZero) {
                    return -1;
                }
                if (!isStr1StartingWithZero && isStr2StartingWithZero) {
                    return 1;
                }
                return Integer.compare(int1, int2);
            }
        });
    }

    public PmsBudgetSubjectServiceImpl(PmsBudgetSubjectRepo pmsBudgetSubjectRepo, PmsBudgetSubjectDAO pmsBudgetSubjectDAO, PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO) {
        this.pmsBudgetSubjectRepo = pmsBudgetSubjectRepo;
        this.pmsBudgetSubjectDAO = pmsBudgetSubjectDAO;
        this.pmsBudgetTemplateSubjectDAO = pmsBudgetTemplateSubjectDAO;
    }
}

