/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSetService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetRelationVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSetConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSetDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSetRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectSetServiceImpl
extends BaseServiceImpl
implements PmsProjectSetService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectSetServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PmsProjectSetRepo pmsProjectSetRepo;
    private final PmsProjectSetDAO pmsProjectSetDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final TransactionUtilService transactionUtilService;

    public List<PmsProjectSetVO> queryListDynamic(PmsProjectSetQuery query) {
        if (this.checkPermissionFlag().booleanValue()) {
            List<PmsProjectSetVO> list = this.pmsProjectSetDAO.queryListDynamic(query);
            this.sortBySetCode(list);
            return list;
        }
        return null;
    }

    public List<PmsProjectSetVO> queryListToProject(PmsProjectQuery query) {
        List<PmsProjectSetVO> list = this.pmsProjectSetDAO.queryListToProject(query);
        List<PmsProjectSetVO> byManagerUserId = this.pmsProjectSetDAO.queryListToProject(query);
        Map<Long, Long> map = byManagerUserId.stream().collect(Collectors.toMap(BaseViewModel::getId, PmsProjectSetVO::getProjectCount));
        list.forEach(vo -> {
            if (map.containsKey(vo.getId())) {
                vo.setProjectCount((Long)map.get(vo.getId()));
            }
        });
        this.sortBySetCode(list);
        return list;
    }

    public List<PmsProjectSetVO> querySelectList(PmsProjectSetQuery query) {
        return this.pmsProjectSetDAO.querySelectList(query);
    }

    public PagingVO<PmsProjectSetRelationVO> queryRelationProjectPaging(PmsProjectSetQuery query) {
        PagingVO<PmsProjectSetRelationVO> pmsProjectSetRelationVOPagingVO = this.pmsProjectSetDAO.queryRelationProjectPaging(query);
        List records = pmsProjectSetRelationVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty((Object)records)) {
            records.forEach(this::transferData);
        }
        return pmsProjectSetRelationVOPagingVO;
    }

    public List<PmsProjectSetRelationVO> queryRelationProjectList(PmsProjectSetQuery query) {
        List<PmsProjectSetRelationVO> records = this.pmsProjectSetDAO.queryRelationProjectList(query);
        if (!ObjectUtils.isEmpty(records)) {
            records.forEach(this::transferData);
        }
        return records;
    }

    void transferData(PmsProjectSetRelationVO vo) {
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection("TSK:PROJ_STATUS", vo.getProjectStatus()));
        vo.setManagerUserName(this.cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setProjectTypeName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:OTHER", vo.getProjectType()));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSetVO insertOrUpdate(PmsProjectSetDataPayload payload) {
        List projectSetPayloads;
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.ADMIN_PMS.getCode()));
        List<PmsProjectSetVO> pmsProjectSetVOS = this.querySelectList(new PmsProjectSetQuery());
        List delProjectSetIds = payload.getDelProjectSetIds();
        if (!ObjectUtils.isEmpty((Object)delProjectSetIds)) {
            List collect = pmsProjectSetVOS.stream().filter(pmsProjectSetVO -> ObjectUtils.isEmpty((Object)pmsProjectSetVO.getParentId()) && delProjectSetIds.contains(pmsProjectSetVO.getId())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "\u6839\u8282\u70b9\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.deleteSoft(delProjectSetIds);
        }
        if (!ObjectUtils.isEmpty((Object)(projectSetPayloads = payload.getProjectSetPayloads()))) {
            List<PmsProjectSetPayload> updateSetPayloads;
            List collect1 = projectSetPayloads.stream().filter(projectSetPayload -> ObjectUtils.isEmpty((Object)projectSetPayload.getParentId())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect1)) {
                Optional<PmsProjectSetVO> first;
                if (collect1.size() > 1) {
                    throw TwException.error("", "\u9879\u76ee\u96c6\u53ea\u80fd\u5b58\u50a8\u4e00\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!ObjectUtils.isEmpty(pmsProjectSetVOS) && (first = pmsProjectSetVOS.stream().filter(pmsProjectSetVO -> ObjectUtils.isEmpty((Object)pmsProjectSetVO.getParentId())).findFirst()).isPresent()) {
                    Long voId = first.get().getId();
                    Long payloadId = ((PmsProjectSetPayload)collect1.get(0)).getId();
                    if (payloadId == null || !payloadId.equals(voId)) {
                        throw TwException.error("", "\u9879\u76ee\u96c6\u53ea\u80fd\u5b58\u50a8\u4e00\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
            }
            if (!ObjectUtils.isEmpty(updateSetPayloads = projectSetPayloads.stream().filter(setPayload -> setPayload.getId() != null).collect(Collectors.toList()))) {
                ArrayList<Long> delProjectIds = new ArrayList<Long>();
                ArrayList addRelationSetPayloads = new ArrayList();
                updateSetPayloads.forEach(updateSetPayload -> {
                    if (!ObjectUtils.isEmpty((Object)updateSetPayload.getDelProjectIds())) {
                        delProjectIds.addAll(updateSetPayload.getDelProjectIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)updateSetPayload.getAddProjectIds())) {
                        addRelationSetPayloads.add(updateSetPayload);
                    }
                });
                if (!ObjectUtils.isEmpty(delProjectIds)) {
                    this.pmsProjectDAO.clearProjectSetId(delProjectIds, true);
                }
            }
            List<PmsProjectSetDO> entityDos = projectSetPayloads.stream().map(e -> {
                PmsProjectSetDO entityDo = PmsProjectSetConvert.INSTANCE.toDo((PmsProjectSetPayload)e);
                e.setProjectSetDO((BaseModel)entityDo);
                return entityDo;
            }).collect(Collectors.toList());
            List<PmsProjectSetDO> pmsProjectSetDOS = this.pmsProjectSetDAO.saveAll(entityDos);
            List<PmsProjectSetPayload> saveSetRelationPayloads = projectSetPayloads.stream().filter(setPayload -> !ObjectUtils.isEmpty((Object)setPayload.getAddProjectIds())).collect(Collectors.toList());
            HashMap<Long, List> updateProjectIdsMap = new HashMap<Long, List>();
            saveSetRelationPayloads.forEach(saveSetRelationPayload -> {
                saveSetRelationPayload.setId(saveSetRelationPayload.getProjectSetDO().getId());
                updateProjectIdsMap.put(saveSetRelationPayload.getProjectSetDO().getId(), saveSetRelationPayload.getAddProjectIds());
            });
            if (updateProjectIdsMap.size() > 0) {
                updateProjectIdsMap.forEach((projectSetId, keys) -> this.transactionUtilService.executeWithRunnable(() -> this.pmsProjectDAO.updateProjectSetId((List<Long>)keys, (Long)projectSetId)));
            }
            if (pmsProjectSetDOS.size() > 0) {
                return PmsProjectSetConvert.INSTANCE.toVo(pmsProjectSetDOS.get(0));
            }
        }
        return null;
    }

    public PmsProjectSetVO queryByKey(Long key) {
        PmsProjectSetDO entity = this.pmsProjectSetRepo.findById(key).orElseGet(PmsProjectSetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectSetVO vo = PmsProjectSetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSetVO update(PmsProjectSetPayload payload) {
        PmsProjectSetDO entity = this.pmsProjectSetRepo.findById(payload.getId()).orElseGet(PmsProjectSetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectSetDO entityDo = PmsProjectSetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectSetConvert.INSTANCE.toVo((PmsProjectSetDO)this.pmsProjectSetRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectSetPayload payload) {
        PmsProjectSetDO entity = this.pmsProjectSetRepo.findById(payload.getId()).orElseGet(PmsProjectSetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectSetDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectSetDAO.deleteSoft(keys);
            this.pmsProjectDAO.clearProjectSetId(keys, false);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void udateSetCode(Long id, String setCode) {
        PmsProjectSetDO entity = this.pmsProjectSetRepo.findById(id).orElseGet(PmsProjectSetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        entity.setSetCode(setCode);
        this.pmsProjectSetRepo.save(entity);
    }

    void operPermissionFlag(PmsProjectQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PROJECT_ADMIN.getCode(), RoleEnum.ADMIN_PMS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    Boolean checkPermissionFlag() {
        return true;
    }

    void sortBySetCode(List<PmsProjectSetVO> list) {
        list.sort(new Comparator<PmsProjectSetVO>(){

            @Override
            public int compare(PmsProjectSetVO obj1, PmsProjectSetVO obj2) {
                String str1 = obj1.getSetCode();
                String str2 = obj2.getSetCode();
                double double1 = Double.parseDouble(str1);
                double double2 = Double.parseDouble(str2);
                boolean isStr1StartingWithZero = str1.startsWith("0");
                boolean isStr2StartingWithZero = str2.startsWith("0");
                if (isStr1StartingWithZero && !isStr2StartingWithZero) {
                    return -1;
                }
                if (!isStr1StartingWithZero && isStr2StartingWithZero) {
                    return 1;
                }
                return Double.compare(double1, double2);
            }
        });
    }

    public PmsProjectSetServiceImpl(CacheUtil cacheUtil, PmsProjectSetRepo pmsProjectSetRepo, PmsProjectSetDAO pmsProjectSetDAO, PrdOrgEmployeeService employeeService, PmsProjectDAO pmsProjectDAO, TransactionUtilService transactionUtilService) {
        this.cacheUtil = cacheUtil;
        this.pmsProjectSetRepo = pmsProjectSetRepo;
        this.pmsProjectSetDAO = pmsProjectSetDAO;
        this.employeeService = employeeService;
        this.pmsProjectDAO = pmsProjectDAO;
        this.transactionUtilService = transactionUtilService;
    }
}

