/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsRelyService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsRelyConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsRelyDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsRelyDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsRelyRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectWbsRelyServiceImpl
extends BaseServiceImpl
implements PmsProjectWbsRelyService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsRelyServiceImpl.class);
    private final PmsProjectWbsRelyRepo pmsProjectWbsRelyRepo;
    private final PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO;
    private final PmsProjectWbsService pmsProjectWbsService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(PmsProjectWbsRelyDataPayload payload) {
        if (payload.getWbsId() == null || !StringUtils.hasText((String)payload.getRelyType()) || ObjectUtils.isEmpty((Object)payload.getAddWbsRelyIds())) throw TwException.error("500", "\u6709\u6548\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (payload.getAddWbsRelyIds().indexOf(payload.getWbsId()) >= 0) throw TwException.error("", "\u4f9d\u8d56\u5173\u7cfb\u4e0d\u53ef\u5305\u542b\u5f53\u524d\u8282\u70b9\uff0c\u8bf7\u6838\u9a8c\uff01");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(payload.getWbsId());
        ids.addAll(payload.getAddWbsRelyIds());
        List pmsProjectWbsVOS = this.pmsProjectWbsService.queryListByIds(ids);
        if (pmsProjectWbsVOS.size() != ids.size()) {
            throw TwException.error("", "\u4f9d\u8d56\u5173\u7cfb\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Map wbsVOMap = pmsProjectWbsVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        PmsProjectWbsVO pmsProjectWbsVO = (PmsProjectWbsVO)wbsVOMap.get(payload.getWbsId());
        Long projectId = pmsProjectWbsVO.getProjectId();
        String wbsType = pmsProjectWbsVO.getWbsType();
        String relyType = payload.getRelyType();
        this.checkWbsType(pmsProjectWbsVO);
        this.checkRepeat(relyType, payload.getWbsId(), payload.getAddWbsRelyIds());
        ArrayList<PmsProjectWbsRelyDO> wbsRelyDOS = new ArrayList<PmsProjectWbsRelyDO>();
        payload.getAddWbsRelyIds().forEach(key -> {
            PmsProjectWbsRelyDO wbsRelyDO = new PmsProjectWbsRelyDO();
            wbsRelyDO.setProjectId(projectId);
            wbsRelyDO.setVersionId(payload.getVersionId());
            wbsRelyDO.setVersionNo(payload.getVersionNo());
            wbsRelyDO.setWbsCode(payload.getWbsCode());
            wbsRelyDO.setRelyType(relyType);
            PmsProjectWbsVO relyVO = (PmsProjectWbsVO)wbsVOMap.get(key);
            String wbsType1 = relyVO.getWbsType();
            this.checkWbsType(relyVO);
            if (relyType.equals("SF")) {
                wbsRelyDO.setRelyType("FS");
                wbsRelyDO.setWbsId(relyVO.getId());
                wbsRelyDO.setWbsName(relyVO.getWbsName());
                wbsRelyDO.setWbsRelyId(pmsProjectWbsVO.getId());
                wbsRelyDO.setWbsRelyName(pmsProjectWbsVO.getWbsName());
                wbsRelyDO.setRelationType(pmsProjectWbsVO.getWbsType());
            } else {
                wbsRelyDO.setWbsId(pmsProjectWbsVO.getId());
                wbsRelyDO.setWbsName(pmsProjectWbsVO.getWbsName());
                wbsRelyDO.setWbsRelyId(relyVO.getId());
                wbsRelyDO.setWbsRelyName(relyVO.getWbsName());
                wbsRelyDO.setRelationType(relyVO.getWbsType());
            }
            wbsRelyDOS.add(wbsRelyDO);
        });
        this.pmsProjectWbsRelyDAO.saveAll(wbsRelyDOS);
        this.pmsProjectWbsService.updateSchedulingStatus(projectId);
    }

    void checkWbsTypeRely(String wbsType, String relyWbsType, String relyType) {
        if (wbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
            if (relyWbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
                if (!(relyType.equals("SS") || relyType.equals("FS") || relyType.equals("FF"))) {
                    throw TwException.error("", "\u6d3b\u52a8-\u6d3b\u52a8\u4e0d\u652f\u6301\u8be5\u4f9d\u8d56\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else if (!relyType.equals("FS") && !relyType.equals("FF")) {
                throw TwException.error("", "\u6d3b\u52a8-\u91cc\u7a0b\u7891\u4e0d\u652f\u6301\u8be5\u4f9d\u8d56\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else if (relyWbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
            if (!relyType.equals("SF") && !relyType.equals("FF")) {
                throw TwException.error("", "\u91cc\u7a0b\u7891-\u6d3b\u52a8\u4e0d\u652f\u6301\u8be5\u4f9d\u8d56\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else if (!relyType.equals("FF")) {
            throw TwException.error("", "\u91cc\u7a0b\u7891-\u91cc\u7a0b\u7891\u4e0d\u652f\u6301\u8be5\u4f9d\u8d56\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void checkRepeat(String relyType, Long wbsId, List<Long> relyIds) {
        PmsProjectWbsRelyVO pmsProjectWbsRelyVO;
        if (relyType.equals("SF") ? (pmsProjectWbsRelyVO = this.pmsProjectWbsRelyDAO.queryWbsIdsAndWbsRelyId(relyIds, wbsId)) != null : (pmsProjectWbsRelyVO = this.pmsProjectWbsRelyDAO.queryWbsIdAndWbsRelyIds(wbsId, relyIds)) != null) {
            throw TwException.error("", "\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\u4f9d\u8d56\u5173\u7cfb\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void checkWbsType(PmsProjectWbsVO pmsProjectWbsVO) {
        if (!pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) && !pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u201c\u6d3b\u52a8\u201d\u548c\u201c\u91cc\u7a0b\u7891\u201d\u5efa\u7acb\u7f51\u7edc\u5173\u7cfb\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (pmsProjectWbsVO.getPreDurationDay() == null || pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) && pmsProjectWbsVO.getPreDurationDay().intValue() == 0) {
            throw TwException.error("", pmsProjectWbsVO.getWbsName() + "--\u9884\u8ba1\u5de5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public PagingVO<PmsProjectWbsRelyVO> queryPaging(PmsProjectWbsRelyQuery query) {
        return this.pmsProjectWbsRelyDAO.queryPaging(query);
    }

    public List<PmsProjectWbsRelyVO> queryListDynamic(PmsProjectWbsRelyQuery query) {
        return this.pmsProjectWbsRelyDAO.queryListDynamic(query);
    }

    public List<PmsProjectWbsRelyVO> listLeftJoinWbs(PmsProjectWbsRelyQuery query) {
        return this.pmsProjectWbsRelyDAO.listLeftJoinWbs(query);
    }

    public PmsProjectWbsRelyVO queryByKey(Long key) {
        PmsProjectWbsRelyDO entity = this.pmsProjectWbsRelyRepo.findById(key).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectWbsRelyVO vo = PmsProjectWbsRelyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsRelyVO update(PmsProjectWbsRelyPayload payload) {
        PmsProjectWbsRelyDO entity = this.pmsProjectWbsRelyRepo.findById(payload.getId()).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectWbsRelyDO entityDo = PmsProjectWbsRelyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectWbsRelyConvert.INSTANCE.toVo((PmsProjectWbsRelyDO)this.pmsProjectWbsRelyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectWbsRelyPayload payload) {
        PmsProjectWbsRelyDO entity = this.pmsProjectWbsRelyRepo.findById(payload.getId()).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectWbsRelyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectWbsRelyDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean delByWbsId(Long wbsId, Integer versionNo) {
        this.pmsProjectWbsRelyDAO.delByWbsId(wbsId, versionNo);
        return null;
    }

    public PmsProjectWbsRelyServiceImpl(PmsProjectWbsRelyRepo pmsProjectWbsRelyRepo, PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO, PmsProjectWbsService pmsProjectWbsService) {
        this.pmsProjectWbsRelyRepo = pmsProjectWbsRelyRepo;
        this.pmsProjectWbsRelyDAO = pmsProjectWbsRelyDAO;
        this.pmsProjectWbsService = pmsProjectWbsService;
    }
}

