/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsTemplateNodePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsTemplateNodeQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsTemplateNodeService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsTemplateNodeVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsWbsTemplateNodeConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsWbsTemplateNodeDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsWbsTemplateNodeDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsWbsTemplateNodeRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsWbsTemplateNodeServiceImpl
extends BaseServiceImpl
implements PmsWbsTemplateNodeService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsTemplateNodeServiceImpl.class);
    private final PmsWbsTemplateNodeRepo pmsWbsTemplateNodeRepo;
    private final PmsWbsTemplateNodeDAO pmsWbsTemplateNodeDAO;

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<PmsWbsTemplateNodePayload> nodePayloads, Long templateId) {
        this.pmsWbsTemplateNodeDAO.deleteSoftByTemplateId(templateId);
        this.setNodeCode(nodePayloads, templateId);
    }

    public List<PmsWbsTemplateNodeVO> queryByTemplateId(Long templateId) {
        return this.pmsWbsTemplateNodeDAO.queryByTemplateIds(List.of(templateId));
    }

    public PagingVO<PmsWbsTemplateNodeVO> paging(PmsWbsTemplateNodeQuery query) {
        Page page = this.pmsWbsTemplateNodeRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(PmsWbsTemplateNodeConvert.INSTANCE::toVo));
    }

    public PagingVO<PmsWbsTemplateNodeVO> queryPaging(PmsWbsTemplateNodeQuery query) {
        return this.pmsWbsTemplateNodeDAO.queryPaging(query);
    }

    public List<PmsWbsTemplateNodeVO> queryList(PmsWbsTemplateNodeQuery query) {
        return PmsWbsTemplateNodeConvert.INSTANCE.toVoList(this.pmsWbsTemplateNodeRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsWbsTemplateNodeVO> queryListDynamic(PmsWbsTemplateNodeQuery query) {
        return this.pmsWbsTemplateNodeDAO.queryListDynamic(query);
    }

    public PmsWbsTemplateNodeVO queryByKey(Long key) {
        PmsWbsTemplateNodeDO entity = this.pmsWbsTemplateNodeRepo.findById(key).orElseGet(PmsWbsTemplateNodeDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsWbsTemplateNodeVO vo = PmsWbsTemplateNodeConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTemplateNodeVO insert(PmsWbsTemplateNodePayload payload) {
        PmsWbsTemplateNodeDO entityDo = PmsWbsTemplateNodeConvert.INSTANCE.toDo(payload);
        return PmsWbsTemplateNodeConvert.INSTANCE.toVo((PmsWbsTemplateNodeDO)this.pmsWbsTemplateNodeRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTemplateNodeVO update(PmsWbsTemplateNodePayload payload) {
        PmsWbsTemplateNodeDO entity = this.pmsWbsTemplateNodeRepo.findById(payload.getId()).orElseGet(PmsWbsTemplateNodeDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsWbsTemplateNodeDO entityDo = PmsWbsTemplateNodeConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsWbsTemplateNodeConvert.INSTANCE.toVo((PmsWbsTemplateNodeDO)this.pmsWbsTemplateNodeRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.pmsWbsTemplateNodeRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsWbsTemplateNodeDO entity = (PmsWbsTemplateNodeDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.pmsWbsTemplateNodeRepo.save(entity);
                }
            });
        }
    }

    private void setNodeCode(List<PmsWbsTemplateNodePayload> nodes, Long templateId) {
        ArrayList<PmsWbsTemplateNodeDO> dNodes = new ArrayList<PmsWbsTemplateNodeDO>();
        nodes.forEach(node -> {
            node.setTemplateId(templateId);
            node.setNodeCode("TEMP-[" + templateId + "]-" + node.getWbsType() + "-" + node.getWbsCode());
            dNodes.add(PmsWbsTemplateNodeConvert.INSTANCE.toDo((PmsWbsTemplateNodePayload)node));
        });
        List<PmsWbsTemplateNodeVO> templateNodeVOS = this.pmsWbsTemplateNodeDAO.queryByTemplateIds(Arrays.asList(templateId));
        this.checkTemplateNode(nodes, templateNodeVOS);
        this.pmsWbsTemplateNodeDAO.saveAll(dNodes);
    }

    void checkTemplateNode(List<PmsWbsTemplateNodePayload> templateNodePayload, List<PmsWbsTemplateNodeVO> templateNodeVOS) {
        List collect = templateNodePayload.stream().map(PmsWbsTemplateNodePayload::getWbsName).distinct().collect(Collectors.toList());
        if (templateNodePayload.size() != collect.size()) {
            throw TwException.error("", "\u8282\u70b9\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List collect0 = templateNodePayload.stream().map(PmsWbsTemplateNodePayload::getWbsCode).distinct().collect(Collectors.toList());
        if (templateNodePayload.size() != collect0.size()) {
            throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        templateNodePayload.forEach(entityDo -> {
            PmsWbsTemplateNodeVO first;
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsCode())) {
                throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsType())) {
                throw TwException.error("", "wbs\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getParentWbsCode())) {
                if (!entityDo.getWbsType().equals("WBS") && !entityDo.getWbsType().equals("NET")) {
                    throw TwException.error("", "\u4e00\u7ea7\u8282\u70b9\u53ea\u53ef\u65b0\u5efa\u201cWBS\u5143\u7d20\u201d\u548c\u201c\u7f51\u7edc\u201d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                first = templateNodePayload.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                if (first.isPresent()) {
                    PmsWbsTemplateNodePayload parentWbsPayload = first.get();
                    if (entityDo.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("WBS")) {
                        throw TwException.error("", "WBS\u5143\u7d20\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("NET") && !parentWbsPayload.getWbsType().equals("WBS")) {
                        throw TwException.error("", "\u7f51\u7edc\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("ACT") && !parentWbsPayload.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("NET")) {
                        throw TwException.error("", "\u6d3b\u52a8\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("MS") && !parentWbsPayload.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("NET")) {
                        throw TwException.error("", "\u91cc\u7a0b\u7891\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                } else {
                    throw TwException.error("", entityDo.getParentWbsCode() + "\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            if (!ObjectUtils.isEmpty((Object)templateNodeVOS)) {
                first = null;
                PmsWbsTemplateNodeVO first0 = null;
                for (PmsWbsTemplateNodeVO wbsVO : templateNodeVOS) {
                    Optional<PmsWbsTemplateNodePayload> firstPayload = templateNodePayload.stream().filter(wbsPayload -> wbsPayload.getId().equals(wbsVO.getId())).findFirst();
                    if (firstPayload.isPresent()) {
                        wbsVO.setWbsCode(firstPayload.get().getWbsCode());
                        wbsVO.setWbsName(firstPayload.get().getWbsName());
                    }
                    if (wbsVO.getWbsCode().equals(entityDo.getWbsCode())) {
                        first = wbsVO;
                    }
                    if (!wbsVO.getWbsName().equals(entityDo.getWbsName())) continue;
                    first0 = wbsVO;
                }
                if (!(first == null || entityDo.getId() != null && first.getId().equals(entityDo.getId()))) {
                    throw TwException.error("", "\u3010" + entityDo.getWbsName() + "\u3011wbs\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!(first0 == null || entityDo.getId() != null && first0.getId().equals(entityDo.getId()))) {
                    throw TwException.error("", "\u3010" + entityDo.getWbsName() + "\u3011\u8282\u70b9\u63cf\u8ff0\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
        });
    }

    public PmsWbsTemplateNodeServiceImpl(PmsWbsTemplateNodeRepo pmsWbsTemplateNodeRepo, PmsWbsTemplateNodeDAO pmsWbsTemplateNodeDAO) {
        this.pmsWbsTemplateNodeRepo = pmsWbsTemplateNodeRepo;
        this.pmsWbsTemplateNodeDAO = pmsWbsTemplateNodeDAO;
    }
}

