/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductClassVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdProductClassDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdProductClassRepo repo;
    private final QPrdProductClassDO qdo = QPrdProductClassDO.prdProductClassDO;
    private final QPrdProductClassDO seniorQdo = new QPrdProductClassDO("seniorQdo");

    private JPAQuery<PrdProductClassVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdProductClassVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.classCode, this.qdo.className, this.qdo.classType, this.qdo.seniorId, this.seniorQdo.className.as("seniorName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.seniorQdo)).on((Predicate)this.qdo.seniorId.longValue().eq((Expression)this.seniorQdo.id.longValue()));
    }

    private JPAQuery<PrdProductClassVO> getJpaQueryWhere(PrdProductClassQuery query) {
        JPAQuery<PrdProductClassVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PrdProductClassQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PrdProductClassQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getClassCode())) {
            list.add(this.qdo.classCode.like(SqlUtil.toSqlLikeString(query.getClassCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getClassName())) {
            list.add(this.qdo.className.like(SqlUtil.toSqlLikeString(query.getClassName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getClassType())) {
            list.add(this.qdo.classType.eq((Object)query.getClassType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSeniorId())) {
            list.add(this.qdo.seniorId.eq((Object)query.getSeniorId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PrdProductClassVO queryByKey(Long id) {
        JPAQuery<PrdProductClassVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdProductClassVO)jpaQuery.fetchFirst();
    }

    public List<PrdProductClassVO> queryListDynamic(PrdProductClassQuery query) {
        JPAQuery<PrdProductClassVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdProductClassVO> queryPaging(PrdProductClassQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdProductClassVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PrdProductClassDO save(PrdProductClassDO ado) {
        return (PrdProductClassDO)this.repo.save(ado);
    }

    public List<PrdProductClassDO> saveAll(List<PrdProductClassDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PrdProductClassPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getClassCode() != null) {
            update.set((Path)this.qdo.classCode, (Object)payload.getClassCode());
        }
        if (payload.getClassName() != null) {
            update.set((Path)this.qdo.className, (Object)payload.getClassName());
        }
        if (payload.getClassType() != null) {
            update.set((Path)this.qdo.classType, (Object)payload.getClassType());
        }
        if (payload.getSeniorId() != null) {
            update.set(this.qdo.seniorId, (Object)payload.getSeniorId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("classCode")) {
                update.setNull((Path)this.qdo.classCode);
            }
            if (nullFields.contains("className")) {
                update.setNull((Path)this.qdo.className);
            }
            if (nullFields.contains("classType")) {
                update.setNull((Path)this.qdo.classType);
            }
            if (nullFields.contains("seniorId")) {
                update.setNull(this.qdo.seniorId);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PrdProductClassDAO(JPAQueryFactory jpaQueryFactory, PrdProductClassRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

