/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.provacation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.convert.ProVacationSettingConvert;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.ProVacationSettingDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationSettingPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.elitesland.tw.tw5.server.prd.provacation.repo.ProVacationSettingRepo;
import com.elitesland.tw.tw5.server.prd.provacation.repo.dao.ProVacationSettingDao;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationSettingService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProVacationSettingServiceImpl
implements ProVacationSettingService {
    private static final Logger log = LoggerFactory.getLogger(ProVacationSettingServiceImpl.class);
    private final ProVacationSettingDao proVacationSettingDao;
    private final ProVacationSettingRepo proVacationSettingRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProVacationSettingVO save(ProVacationSettingPayload payload) {
        this.checkData(payload);
        if (null == payload.getWorkHours()) {
            payload.setWorkHours(new BigDecimal("8"));
        }
        ProVacationSettingDO entity = ProVacationSettingConvert.INSTANCE.p2d(payload);
        Long count = this.proVacationSettingDao.countByProjectId(payload.getProjectId(), payload.getYear());
        if (count == 0L) {
            ProVacationSettingDO res = (ProVacationSettingDO)((Object)this.proVacationSettingRepo.save((Object)entity));
            return ProVacationSettingConvert.INSTANCE.d2v(res);
        }
        return null;
    }

    @Override
    public ProVacationSettingVO get(Long id) {
        if (null == id) {
            return null;
        }
        ProVacationSettingVO res = this.proVacationSettingDao.get(id);
        return res;
    }

    @Override
    public PagingVO<ProVacationSettingVO> page(ProVacationSettingQuery proVacationQuery) {
        PagingVO<ProVacationSettingVO> res = this.proVacationSettingDao.page(proVacationQuery);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.proVacationSettingDao.del(ids);
        return res;
    }

    @Override
    public List<ProVacationSettingVO> getList(ProVacationSettingQuery proVacationQuery) {
        Assert.notNull((Object)proVacationQuery.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProVacationSettingVO> res = this.proVacationSettingDao.getList(proVacationQuery);
        return res;
    }

    private void checkData(ProVacationSettingPayload proVacationPayload) {
        Assert.notNull((Object)proVacationPayload.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)proVacationPayload.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ProVacationSettingPayload proVacationPayload) {
        Assert.notNull((Object)proVacationPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.proVacationSettingDao.update(proVacationPayload);
        return res;
    }

    public ProVacationSettingServiceImpl(ProVacationSettingDao proVacationSettingDao, ProVacationSettingRepo proVacationSettingRepo) {
        this.proVacationSettingDao = proVacationSettingDao;
        this.proVacationSettingRepo = proVacationSettingRepo;
    }
}

