/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldObjRoleFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemRoleController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRoleController.class);
    private final PrdSystemRoleService service;
    private final CacheUtil cacheUtil;

    @PostMapping(value={"/role/insert"})
    public TwOutputUtil insert(@RequestBody PrdSystemRolePayload entity) {
        PrdSystemRoleVO vo = this.service.insert(entity);
        this.cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/role/updateStatus"})
    public TwOutputUtil updateStatus(Long id, Boolean enabled) {
        this.service.updateStatus(id, enabled);
        this.cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/role/update"})
    public TwOutputUtil update(@RequestBody PrdSystemRolePayload entity) {
        this.service.update(entity);
        this.cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/role/deleteSoft"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        this.cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/role/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemRoleVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/role/list"})
    public TwOutputUtil queryList() {
        List paging = this.service.queryList();
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u4e1a\u52a1/\u7ba1\u7406\u89d2\u8272\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/role/differentList"})
    public TwOutputUtil differentList(PrdSystemRoleQuery query) {
        List paging = this.service.differentList(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/role/paging"})
    public TwOutputUtil usableList(PrdSystemRoleQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/role/pagingUserList"})
    public TwOutputUtil pagingUserList(PrdSystemRoleFunctionQuery query) {
        return TwOutputUtil.ok(this.service.pagingUserList(query));
    }

    @DeleteMapping(value={"/role/deleteUserList"})
    public TwOutputUtil deleteUserList(Long roleId, Long userId) {
        this.service.deleteUserList(roleId, userId);
        this.cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/role/pagingFunctionList"})
    public TwOutputUtil pagingFunctionList(PrdSystemRoleFunctionQuery query) {
        return TwOutputUtil.ok(this.service.pagingFunctionList(query));
    }

    @GetMapping(value={"/role/pagingField"})
    public TwOutputUtil pagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        return TwOutputUtil.ok(this.service.pagingField(query));
    }

    @PutMapping(value={"/role/updateField"})
    public TwOutputUtil updateField(@RequestBody List<PrdSystemPermissionFieldObjRoleFunctionPayload> payloads) {
        this.service.updateField(payloads);
        return TwOutputUtil.ok();
    }

    public PrdSystemRoleController(PrdSystemRoleService service, CacheUtil cacheUtil) {
        this.service = service;
        this.cacheUtil = cacheUtil;
    }
}

