/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRoutePayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDao;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDtlDao;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsTaskRouteServiceImpl
implements PmsTaskRouteService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskRouteServiceImpl.class);
    private final PmsTaskRouteDao dao;
    private final PmsTaskRouteDtlDao pmsTaskRouteDtlDao;
    private final CacheUtil cacheUtil;

    @Override
    public TwOutputUtil<PagingVO<PmsTaskRouteVO>> queryPage(PmsTaskRouteQuery query) {
        PagingVO<PmsTaskRouteVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteVO>> queryList(PmsTaskRouteQuery query) {
        if (null != query.getTaskId()) {
            PmsTaskRouteDtlQuery pmsTaskRouteDtlQuery = new PmsTaskRouteDtlQuery();
            pmsTaskRouteDtlQuery.setTaskId(query.getTaskId());
            List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS = this.pmsTaskRouteDtlDao.queryList(pmsTaskRouteDtlQuery);
            List ids = pmsTaskRouteDtlVOS.stream().map(PmsTaskRouteDtlVO::getMasId).collect(Collectors.toList());
            if (ids.isEmpty()) {
                ids.add(0L);
            }
            query.setIds(ids);
        }
        List<PmsTaskRouteVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsTaskRouteQuery query) {
        return TwOutputUtil.ok(this.dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsTaskRouteVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> insert(PmsTaskRoutePayload payload) {
        this.checkData(payload);
        PmsTaskRouteVO save = this.dao.save(payload);
        PmsTaskRouteDtlPayload pmsTaskRouteDtlPayload = new PmsTaskRouteDtlPayload();
        pmsTaskRouteDtlPayload.setMasId(save.getId());
        pmsTaskRouteDtlPayload.setParentId(Long.valueOf(0L));
        pmsTaskRouteDtlPayload.setProjectId(save.getProjectId());
        this.pmsTaskRouteDtlDao.save(pmsTaskRouteDtlPayload);
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> update(PmsTaskRoutePayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsTaskRouteVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> updateDynamic(PmsTaskRoutePayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dao.deleteSoft(ids);
        this.pmsTaskRouteDtlDao.deleteByMasId(ids);
        return TwOutputUtil.ok();
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteVO>> childList(PmsTaskRouteQuery query) {
        Assert.notNull((Object)query.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return null;
    }

    private TwOutputUtil<Long> startWorkFlow(PmsTaskRoutePayload payload) {
        HashMap varMaps = new HashMap();
        String procInstId = "";
        Long update = this.dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    private void checkData(PmsTaskRoutePayload payload) {
        Assert.notNull((Object)payload.getProjectId(), (String)"projectId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)payload.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void translate(List<PmsTaskRouteVO> vos) {
        vos.forEach(vo -> vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId())));
    }

    public PmsTaskRouteServiceImpl(PmsTaskRouteDao dao, PmsTaskRouteDtlDao pmsTaskRouteDtlDao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.pmsTaskRouteDtlDao = pmsTaskRouteDtlDao;
        this.cacheUtil = cacheUtil;
    }
}

