/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleAssignmentService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsWbsTaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsWbsTaskQuery;
import com.elitesland.tw.tw5.api.prd.task.service.PmsWbsTaskService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.task.common.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.PmsWbsTaskConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsWbsTaskDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.PmsWbsTaskDO;
import com.elitesland.tw.tw5.server.prd.task.repo.PmsWbsTaskRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsWbsTaskServiceImpl
extends BaseServiceImpl
implements PmsWbsTaskService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsTaskServiceImpl.class);
    private final PmsWbsTaskRepo pmsWbsTaskRepo;
    private final PmsWbsTaskDAO pmsWbsTaskDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PmsProjectWbsService pmsProjectWbsService;
    private final PmsProjectRoleAssignmentService pmsProjectRoleAssignmentService;

    public PagingVO<PmsWbsTaskVO> queryPaging(PmsWbsTaskQuery query) {
        PagingVO<PmsWbsTaskVO> pageVo = this.pmsWbsTaskDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)pageVo.getRecords())) {
            pageVo.getRecords().forEach(this::transferData);
        }
        return pageVo;
    }

    public List<PmsWbsTaskVO> queryListDynamic(PmsWbsTaskQuery query) {
        List<PmsWbsTaskVO> list = this.pmsWbsTaskDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(this::transferData);
        }
        return list;
    }

    public PmsWbsTaskVO queryByKey(Long key) {
        PmsWbsTaskVO vo = this.pmsWbsTaskDAO.queryByKey(key);
        if (!ObjectUtils.isEmpty((Object)vo)) {
            this.transferData(vo);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTaskVO insert(PmsWbsTaskPayload payload) {
        this.checkData(payload);
        payload.setManualSettingWeight(Integer.valueOf(0));
        List<PmsWbsTaskVO> list = this.pmsWbsTaskDAO.queryByWbsId(payload.getWbsId());
        if (ObjectUtils.isEmpty(list)) {
            payload.setWeight(BigDecimal.valueOf(100L));
        } else {
            BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight()).map(PmsWbsTaskVO::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
            long count = list.stream().filter(v -> 0 == v.getManualSettingWeight()).count();
            BigDecimal averageNew = BigDecimal.valueOf(100L).subtract(weights).divide(BigDecimal.valueOf(count + 1L), 2, RoundingMode.HALF_UP);
            payload.setWeight(averageNew);
            list.stream().filter(v -> 0 == v.getManualSettingWeight()).forEach(v -> v.setWeight(averageNew));
            this.pmsWbsTaskDAO.saveAll(PmsWbsTaskConvert.INSTANCE.toEntity(list));
        }
        String code = this.generateSeqNum("PMS_TASK", new String[0]);
        payload.setTaskCode(code);
        payload.setProgress(BigDecimal.ZERO);
        payload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
        PmsWbsTaskDO entityDo = PmsWbsTaskConvert.INSTANCE.toDo(payload);
        return PmsWbsTaskConvert.INSTANCE.toVo((PmsWbsTaskDO)this.pmsWbsTaskRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTaskVO update(PmsWbsTaskPayload payload) {
        this.checkData(payload);
        PmsWbsTaskDO entity = this.pmsWbsTaskRepo.findById(payload.getId()).orElseGet(PmsWbsTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (TaskStatusEnum.PENDING.getCode().equals(entity.getTaskStatus())) {
            throw TwException.error("", "\u6682\u6302\u72b6\u6001\u7684\u4efb\u52a1\uff0c\u53ea\u80fd\u67e5\u770b\u8be6\u60c5\uff0c\u4e0d\u80fd\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (TaskStatusEnum.FINISH.getCode().equals(entity.getTaskStatus())) {
            throw TwException.error("", "\u5df2\u5b8c\u6210\u72b6\u6001\u7684\u4efb\u52a1\uff0c\u53ea\u80fd\u67e5\u770b\u8be6\u60c5\uff0c\u4e0d\u80fd\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Boolean changeProgressFlag = payload.getProgress().compareTo(entity.getProgress()) != 0;
        PmsWbsTaskDO entityDo = PmsWbsTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PmsWbsTaskVO vo = PmsWbsTaskConvert.INSTANCE.toVo((PmsWbsTaskDO)this.pmsWbsTaskRepo.save(entity));
        this.updateWBS(payload.getWbsId(), changeProgressFlag);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u4efb\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<Object> list = this.pmsWbsTaskDAO.queryByKeys(keys);
        for (PmsWbsTaskVO pmsWbsTaskVO : list) {
            if (TaskStatusEnum.CREATE.getCode().equals(pmsWbsTaskVO.getTaskStatus())) continue;
            throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u4efb\u52a1\u624d\u80fd\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.pmsWbsTaskDAO.deleteSoft(keys);
        list = this.pmsWbsTaskDAO.queryByWbsId(list.get(0).getWbsId());
        BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight() && keys.contains(v.getId())).map(PmsWbsTaskVO::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        list = list.stream().filter(v -> 0 == v.getManualSettingWeight()).collect(Collectors.toList());
        long l = list.size();
        if (l > 0L) {
            BigDecimal averageNew = BigDecimal.valueOf(100L).subtract(weights).divide(BigDecimal.valueOf(l), 2, RoundingMode.HALF_UP);
            list.forEach(v -> v.setWeight(averageNew));
            this.pmsWbsTaskDAO.saveAll(PmsWbsTaskConvert.INSTANCE.toEntity(list));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByWbsIds(List<Long> wbsIds) {
        this.pmsWbsTaskDAO.deleteSoftByWbsIds(wbsIds);
    }

    public List<PmsWbsTaskVO> findByWbsIds(List<Long> wbsIds) {
        return this.pmsWbsTaskDAO.findByWbsIds(wbsIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void appointedTask(List<Long> keys, Long wbsId) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u4efb\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)wbsId)) {
            throw TwException.error("", "\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsWbsTaskVO> list = this.pmsWbsTaskDAO.queryByKeys(keys);
        for (PmsWbsTaskVO vo : list) {
            if (TaskStatusEnum.CREATE.getCode().equals(vo.getTaskStatus())) continue;
            throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u4efb\u52a1\u624d\u80fd\u6307\u6d3e\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.pmsWbsTaskDAO.updateTaskStatus(keys, TaskStatusEnum.APPROVED.getCode(), GlobalUtil.getLoginUserId());
        Map groupedMap = list.stream().collect(Collectors.groupingBy(PmsWbsTaskVO::getReceiverUserId, Collectors.toList()));
        Long projectId = list.get(0).getProjectId();
        for (Map.Entry entry : groupedMap.entrySet()) {
            List projectRoleIds = entry.getValue().stream().map(v -> v.getProjectRoleId()).collect(Collectors.toList());
            this.pmsProjectRoleAssignmentService.insert(projectId, entry.getKey(), projectRoleIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskStatus(List<Long> keys, String taskStatus) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u4efb\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (TaskStatusEnum.FINISH.getCode().equals(taskStatus)) {
            this.pmsWbsTaskDAO.updateTaskStatus(keys, taskStatus, BigDecimal.valueOf(100L));
            List<PmsWbsTaskVO> list = this.pmsWbsTaskDAO.queryByKeys(keys);
            List<Long> wbsIds = list.stream().distinct().map(v -> v.getWbsId()).collect(Collectors.toList());
            wbsIds.forEach(wbsId -> this.updateWBS((Long)wbsId, true));
        } else {
            this.pmsWbsTaskDAO.updateTaskStatus(keys, taskStatus);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskWeight(Long wbsId, Long key, BigDecimal weight) {
        List<Object> list = this.pmsWbsTaskDAO.queryByWbsId(wbsId);
        BigDecimal weights = list.stream().filter(v -> !key.equals(v.getId()) && 1 == v.getManualSettingWeight()).map(PmsWbsTaskVO::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ((weights = weights.add(weight)).doubleValue() > 100.0) {
            throw TwException.error("", "\u8be5\u8282\u70b9\u4e0b\u7684\u624b\u52a8\u8bbe\u7f6e\u4efb\u52a1\u6743\u91cd\u603b\u548c\u8d85\u8fc7100\u4e86\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        long count = (list = list.stream().filter(v -> !key.equals(v.getId()) && 0 == v.getManualSettingWeight()).collect(Collectors.toList())).size();
        if (count > 0L) {
            BigDecimal averageNew = BigDecimal.valueOf(100L).subtract(weights).divide(BigDecimal.valueOf(count), 2, RoundingMode.HALF_UP);
            list.forEach(v -> v.setWeight(averageNew));
            this.pmsWbsTaskDAO.saveAll(PmsWbsTaskConvert.INSTANCE.toEntity(list));
        }
        PmsWbsTaskVO vo = this.pmsWbsTaskDAO.queryByKey(key);
        this.pmsWbsTaskDAO.updateTaskWeight(key, weight);
        Boolean changeProgressFlag = !PmsWbsTaskServiceImpl.areBigDecimalsEqual(vo.getWeight(), weight);
        this.updateWBS(wbsId, changeProgressFlag);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWBS(Long wbsId, Boolean changeProgressFlag) {
        List<PmsWbsTaskVO> taskList = this.pmsWbsTaskDAO.queryByWbsId(wbsId);
        if (changeProgressFlag.booleanValue()) {
            BigDecimal taskProgress = BigDecimal.ZERO;
            long size = taskList.stream().filter(v -> v.getProgress().doubleValue() == 100.0).count();
            if ((long)taskList.size() == size) {
                taskProgress = BigDecimal.valueOf(100L);
            } else {
                for (PmsWbsTaskVO task : taskList) {
                    taskProgress = taskProgress.add(task.getProgress().multiply(task.getWeight()));
                }
                taskProgress = taskProgress.divide(BigDecimal.valueOf(100L));
            }
            if (taskProgress.doubleValue() > 0.0 && taskProgress.doubleValue() < 100.0) {
                this.pmsProjectWbsService.updateWbsProgress(wbsId, taskProgress, ProjectWbsStatusEnum.NOGIONG.getCode());
            } else if (taskProgress.doubleValue() == 100.0) {
                this.pmsProjectWbsService.updateWbsProgress(wbsId, taskProgress, ProjectWbsStatusEnum.FINISHED.getCode());
            } else if (taskProgress.doubleValue() == 0.0) {
                this.pmsProjectWbsService.updateWbsProgress(wbsId, taskProgress, ProjectWbsStatusEnum.NOSTART.getCode());
            }
        }
    }

    void transferData(PmsWbsTaskVO taskVO) {
        taskVO.setSourceTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:RESOURCE:TYPE", taskVO.getSourceType()));
        taskVO.setTaskStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", taskVO.getTaskStatus()));
        taskVO.setReceiverUserName(this.cacheUtil.getUserName(taskVO.getReceiverUserId()));
        taskVO.setTaskFilesDatas(this.fileUtil.getFileDatas(taskVO.getDeliveryDocuments()));
        taskVO.setManagerUserName(this.cacheUtil.getUserName(taskVO.getManagerUserId()));
    }

    void checkData(PmsWbsTaskPayload payload) {
        BigDecimal weight;
        if (ObjectUtils.isEmpty((Object)payload.getSourceType())) {
            throw TwException.error("", "\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getProjectRoleId())) {
            throw TwException.error("", "\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getTaskName())) {
            throw TwException.error("", "\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getReceiverUserId())) {
            throw TwException.error("", "\u8d44\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            throw TwException.error("", "\u4efb\u52a1\u8d77\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            throw TwException.error("", "\u4efb\u52a1\u8d77\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDays())) {
            throw TwException.error("", "\u4eba\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal progress = payload.getProgress();
        if (!ObjectUtils.isEmpty((Object)progress)) {
            if (new BigDecimal(progress.intValue()).compareTo(progress) != 0) {
                throw TwException.error("", "\u8fdb\u5ea6\u53ea\u80fd\u662f\u6574\u6570\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (progress.intValue() < 0 || progress.intValue() > 100) {
                throw TwException.error("", "\u8fdb\u5ea6\u53ea\u80fd\u662f0-100\u7684\u6574\u6570\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        if (!ObjectUtils.isEmpty((Object)(weight = payload.getWeight()))) {
            if (new BigDecimal(weight.intValue()).compareTo(weight) != 0) {
                throw TwException.error("", "\u6743\u91cd\u53ea\u80fd\u662f\u6574\u6570\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (weight.intValue() < 0 || weight.intValue() > 100) {
                throw TwException.error("", "\u6743\u91cd\u53ea\u80fd\u662f0-100\u7684\u6574\u6570\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
    }

    public static boolean areBigDecimalsEqual(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null && bd2 == null) {
            return true;
        }
        if (bd1 == null && bd2 != null || bd1 != null && bd2 == null) {
            return false;
        }
        return bd1.compareTo(bd2) == 0;
    }

    public PmsWbsTaskServiceImpl(PmsWbsTaskRepo pmsWbsTaskRepo, PmsWbsTaskDAO pmsWbsTaskDAO, CacheUtil cacheUtil, FileUtil fileUtil, PmsProjectWbsService pmsProjectWbsService, PmsProjectRoleAssignmentService pmsProjectRoleAssignmentService) {
        this.pmsWbsTaskRepo = pmsWbsTaskRepo;
        this.pmsWbsTaskDAO = pmsWbsTaskDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.pmsProjectWbsService = pmsProjectWbsService;
        this.pmsProjectRoleAssignmentService = pmsProjectRoleAssignmentService;
    }
}

