/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskProConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProBoardViewGroupInfoVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProExcelVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u4e3b\u6863"})
@RestController
@RequestMapping(value={"/api/pms/taskPro"})
public class TaskProController {
    private static final Logger log = LoggerFactory.getLogger(TaskProController.class);
    private final TaskProService taskProService;
    private final UdcUtil udcUtil;

    @PostMapping
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u65b0\u589e")
    public TwOutputUtil<TaskProVO> insert(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(this.taskProService.insert(payload));
    }

    @PostMapping(value={"createSub"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u65b0\u589e\u5b50\u4efb\u52a1")
    public TwOutputUtil<TaskProVO> createSub(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(this.taskProService.createSub(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u66f4\u65b0")
    public TwOutputUtil<TaskProVO> update(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(this.taskProService.update(payload));
    }

    @PostMapping(value={"top"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u7f6e\u9876")
    public TwOutputUtil<TaskProVO> top(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(this.taskProService.top(payload));
    }

    @PutMapping(value={"update"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u66f4\u65b0,\u652f\u6301\u7f6e\u7a7a \u7f6e\u7a7a\u7684\u5b57\u6bb5\u9700\u9700\u8981\u501f\u52a9 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(this.taskProService.updateByKeyDynamic(payload));
    }

    @PostMapping(value={"updateBatch"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u6279\u91cf\u66f4\u65b0")
    public TwOutputUtil<Boolean> updateBatch(@RequestBody List<TaskProPayload> payloadList) {
        return TwOutputUtil.ok(this.taskProService.updateBatch(payloadList));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<TaskProVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.taskProService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u5206\u9875")
    public TwOutputUtil<PagingVO<TaskProVO>> paging(TaskProQuery query) {
        return TwOutputUtil.ok(this.taskProService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<TaskProVO>> queryList(TaskProQuery query) {
        return TwOutputUtil.ok(this.taskProService.queryListDynamic(query));
    }

    @GetMapping(value={"/tree"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-tree\u6811\u5f62\u7ed3\u6784")
    public TwOutputUtil<List<TaskProVO>> tree(TaskProQuery query) {
        return TwOutputUtil.ok(this.taskProService.tree(query));
    }

    @GetMapping(value={"/excelExport"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-excel\u5bfc\u51fa")
    public void excelExport(TaskProQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u4efb\u52a1\u5217\u8868";
        ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
        taskOrderItemList.add(OrderItem.asc((String)"topFlag"));
        taskOrderItemList.add(OrderItem.asc((String)"topModifyTime"));
        taskOrderItemList.add(OrderItem.asc((String)"sort"));
        taskOrderItemList.add(OrderItem.asc((String)"createTime"));
        query.setOrders(taskOrderItemList);
        List<TaskProVO> vos = this.taskProService.queryListDynamicForExcelExport(query);
        vos.forEach(vo -> this.taskProService.translate((TaskProVO)vo));
        List resultList = TaskProConvert.INSTANCE.voListVoExcelExport(vos);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TaskProExcelVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, TaskProExcelVO.class, null);
        sheet.doWrite(resultList);
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.taskProService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"updatePartiesId"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u6279\u91cf\u4fee\u6539\u8d1f\u8d23\u4eba")
    public TwOutputUtil<Boolean> updatePartiesId(@RequestBody List<TaskProQuery> taskProQueryList) {
        Boolean res = this.taskProService.updatePartiesId(taskProQueryList);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"unbindRef"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u5b50\u4efb\u52a1\u7236\u4efb\u52a1\u89e3\u7ed1")
    public TwOutputUtil<Boolean> unbindRef(Long subTaskId, Long parentTaskId) {
        Boolean res = this.taskProService.unbindRef(subTaskId, parentTaskId);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/boardViewGroup"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u770b\u677f\u89c6\u56fe\u5206\u7ec4")
    public TwOutputUtil<List<TaskProBoardViewGroupInfoVO>> boardViewGroup(TaskProQuery query) {
        return TwOutputUtil.ok(this.taskProService.boardViewGroup(query));
    }

    @GetMapping(value={"/boardView"})
    @ApiOperation(value="\u4efb\u52a1\u4e3b\u6863-\u770b\u677f\u89c6\u56fe")
    public TwOutputUtil<List<TaskProBoardVO>> boardView(TaskProQuery query) {
        return TwOutputUtil.ok(this.taskProService.boardView(query));
    }

    @GetMapping(value={"/summaryWbs"})
    @ApiOperation(value="\u6d3b\u52a8\u8fdb\u5ea6\u6c47\u603b")
    public TwOutputUtil<BigDecimal> summaryWbs(Long wbsId, String type) {
        BigDecimal bigDecimal = this.taskProService.summaryWbs(wbsId, type);
        return TwOutputUtil.ok(bigDecimal);
    }

    public TaskProController(TaskProService taskProService, UdcUtil udcUtil) {
        this.taskProService = taskProService;
        this.udcUtil = udcUtil;
    }
}

