/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.repo.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.QTaskMemberRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskMemberRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskMemberRefRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TaskMemberRefDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TaskMemberRefRepo repo;
    private final QTaskMemberRefDO qdo = QTaskMemberRefDO.taskMemberRefDO;

    private JPAQuery<TaskMemberRefVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskMemberRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.taskId, this.qdo.type, this.qdo.objType, this.qdo.objId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TaskMemberRefVO> getJpaQueryWhere(TaskMemberRefQuery query) {
        JPAQuery<TaskMemberRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TaskMemberRefQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(TaskMemberRefQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskId())) {
            list.add(this.qdo.taskId.eq((Object)query.getTaskId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getType())) {
            list.add(this.qdo.type.eq((Object)query.getType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjType())) {
            list.add(this.qdo.objType.eq((Object)query.getObjType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjId())) {
            list.add(this.qdo.objId.eq((Object)query.getObjId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TaskMemberRefVO queryByKey(Long id) {
        JPAQuery<TaskMemberRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskMemberRefVO)jpaQuery.fetchFirst();
    }

    public List<TaskMemberRefVO> queryListDynamic(TaskMemberRefQuery query) {
        JPAQuery<TaskMemberRefVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TaskMemberRefVO> queryPaging(TaskMemberRefQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TaskMemberRefVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TaskMemberRefDO save(TaskMemberRefDO ado) {
        return (TaskMemberRefDO)this.repo.save(ado);
    }

    public List<TaskMemberRefDO> saveAll(List<TaskMemberRefDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TaskMemberRefPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTaskId() != null) {
            update.set(this.qdo.taskId, (Object)payload.getTaskId());
        }
        if (payload.getType() != null) {
            update.set((Path)this.qdo.type, (Object)payload.getType());
        }
        if (payload.getObjType() != null) {
            update.set((Path)this.qdo.objType, (Object)payload.getObjType());
        }
        if (payload.getObjId() != null) {
            update.set(this.qdo.objId, (Object)payload.getObjId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("taskId")) {
                update.setNull(this.qdo.taskId);
            }
            if (nullFields.contains("type")) {
                update.setNull((Path)this.qdo.type);
            }
            if (nullFields.contains("objType")) {
                update.setNull((Path)this.qdo.objType);
            }
            if (nullFields.contains("objId")) {
                update.setNull(this.qdo.objId);
            }
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long deleteSoftByTaskId(Long taskId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.taskId.eq((Object)taskId)});
        return update.execute();
    }

    public TaskMemberRefDAO(JPAQueryFactory jpaQueryFactory, TaskMemberRefRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

