/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskSceneConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskSceneDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskScenePayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskSceneRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskSceneDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TaskSceneServiceImpl
extends BaseServiceImpl
implements TaskSceneService {
    private static final Logger log = LoggerFactory.getLogger(TaskSceneServiceImpl.class);
    private final TaskSceneRepo taskSceneRepo;
    private final TaskSceneDAO taskSceneDAO;
    @Autowired
    @Lazy
    private TaskInfoService taskInfoService;
    @Autowired
    @Lazy
    private TaskCategoryService taskCategoryService;

    @Override
    public PagingVO<TaskSceneVO> queryPaging(TaskSceneQuery query) {
        PagingVO<TaskSceneVO> pagingVO = this.taskSceneDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            List<Long> categoryIdList = pagingVO.getRecords().stream().filter(p -> p.getCategoryId() != null).map(s -> s.getCategoryId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(categoryIdList)) {
                TaskCategoryQuery categoryQuery = new TaskCategoryQuery();
                categoryQuery.setIdList(categoryIdList);
                List<TaskCategoryVO> taskCategoryVOS = this.taskCategoryService.queryListDynamic(categoryQuery);
                Map<Long, List<TaskCategoryVO>> categoryMap = taskCategoryVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
                pagingVO.getRecords().forEach(vo -> {
                    if (vo.getCategoryId() != null && categoryMap.containsKey(vo.getCategoryId())) {
                        TaskCategoryVO taskCategoryVO = (TaskCategoryVO)((List)categoryMap.get(vo.getCategoryId())).get(0);
                        vo.setCategoryName(taskCategoryVO.getName());
                    }
                });
            }
            pagingVO.getRecords().forEach(vo -> this.translate((TaskSceneVO)vo));
        }
        return pagingVO;
    }

    @Override
    public List<TaskSceneVO> queryListDynamic(TaskSceneQuery query) {
        return this.taskSceneDAO.queryListDynamic(query);
    }

    @Override
    public TaskSceneVO queryByKey(Long key) {
        TaskSceneDO entity = this.taskSceneRepo.findById(key).orElseGet(TaskSceneDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u573a\u666f\u4e0d\u5b58\u5728");
        TaskSceneVO vo = TaskSceneConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    private void translate(TaskSceneVO vo) {
        TaskSceneCategoryRefQuery taskSceneCategoryRefQuery = new TaskSceneCategoryRefQuery();
        taskSceneCategoryRefQuery.setSceneId(vo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskSceneVO insert(TaskScenePayload payload) {
        this.check(payload);
        this.uniquenessVerification(payload);
        TaskSceneDO entityDo = TaskSceneConvert.INSTANCE.toDo(payload);
        TaskSceneDO save = (TaskSceneDO)this.taskSceneRepo.save(entityDo);
        return TaskSceneConvert.INSTANCE.toVo(save);
    }

    private void check(TaskScenePayload payload) {
        Assert.hasText((String)payload.getName(), (String)"\u573a\u666f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void uniquenessVerification(TaskScenePayload payload) {
        TaskSceneQuery sceneQuery = new TaskSceneQuery();
        sceneQuery.setNameEq(payload.getName());
        sceneQuery.setIdNeq(payload.getId());
        long count = this.taskSceneDAO.count(sceneQuery);
        if (count > 0L) {
            throw TwException.error("", "\u8be5\u4efb\u52a1\u7c7b\u578b\u6570\u636e\u5df2\u5b58\u5728\uff01");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskSceneVO update(TaskScenePayload payload) {
        TaskSceneDO entity = this.taskSceneRepo.findById(payload.getId()).orElseGet(TaskSceneDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u573a\u666f\u4e0d\u5b58\u5728");
        this.check(payload);
        this.uniquenessVerification(payload);
        TaskSceneDO entityDo = TaskSceneConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TaskSceneDO save = (TaskSceneDO)this.taskSceneRepo.save(entity);
        return TaskSceneConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TaskScenePayload payload) {
        TaskSceneDO entity = this.taskSceneRepo.findById(payload.getId()).orElseGet(TaskSceneDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u573a\u666f\u4e0d\u5b58\u5728");
        long result = this.taskSceneDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.taskSceneDAO.deleteSoft(keys);
            keys.forEach(x -> {
                Long res = this.taskInfoService.countBySceneId(x);
                if (res > 0L) {
                    throw new BusinessException("\u8be5\u4efb\u52a1\u6d41\u4e0b\u5b58\u5728\u4efb\u52a1\uff0c\u4e0d\u80fd\u88ab\u5220\u9664");
                }
            });
        }
    }

    @Override
    public List<TaskCategoryVO> listByRef(TaskCategoryQuery query) {
        return this.taskSceneDAO.listByRef(query);
    }

    @Override
    public Long count(TaskSceneQuery taskSceneQuery) {
        long res = this.taskSceneDAO.count(taskSceneQuery);
        return res;
    }

    public TaskSceneServiceImpl(TaskSceneRepo taskSceneRepo, TaskSceneDAO taskSceneDAO) {
        this.taskSceneRepo = taskSceneRepo;
        this.taskSceneDAO = taskSceneDAO;
    }
}

