/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedocpro.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.pms.payload.NewUploadFilesSavePayload;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.yeedocpro.config.YeedocProProperties;
import com.elitesland.tw.tw5.server.yeedocpro.dto.CreateFolderPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.CreateFolderTwPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.FolderListByItemNameDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.FolderListByItemNameListDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.FolderListByItemNamePayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetAllItemsInfoDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetAllItemsInfoListDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetAllItemsInfoPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetCaCheKeyItemIdDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetCaCheKeyItemIdListDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.GetCaCheKeyItemIdPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.ItemInfoDataDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.ItemInfoPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.NewUploadFilesSaveDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderDataDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderForTwDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderForTwListDTO;
import com.elitesland.tw.tw5.server.yeedocpro.service.YeedocProService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class YeedocProServiceImpl
implements YeedocProService {
    private static final Logger log = LoggerFactory.getLogger(YeedocProServiceImpl.class);
    private final ApiRequestLogService apiRequestLogService;
    private final YeedocProProperties yeedocProperties;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    @Override
    public List<String> newUploadFilesSave(NewUploadFilesSavePayload payload) {
        NewUploadFilesSaveDTO resultDTO;
        Assert.notNull((Object)payload.getLibraryId(), (String)"\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)payload.getFolderId(), (String)"\u6587\u4ef6\u5939ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((Iterable)payload.getCacheKey(), (String)"\u9644\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String yeedocJwt = this.getYeedocJwt();
        String newUploadFilesSaveUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/NewUploadFilesSave";
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)payload), Map.class);
        String result = this.executePost(newUploadFilesSaveUrl, map, yeedocJwt);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            log.info("[\u6700\u7ec8\u4fdd\u5b58\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        try {
            resultDTO = (NewUploadFilesSaveDTO)JSONObject.parseObject((String)result, NewUploadFilesSaveDTO.class);
        }
        catch (Exception e) {
            log.error("[\u6700\u7ec8\u4fdd\u5b58\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        if (resultDTO.getCode() == 0) {
            if (StringUtils.hasText((String)resultDTO.getMessage()) && resultDTO.getMessage().equals("\u5b58\u5728\u540c\u540d\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff01")) {
                throw TwException.error("", resultDTO.getMessage());
            }
            return resultDTO.getData();
        }
        log.error("[\u6700\u7ec8\u4fdd\u5b58\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
        throw TwException.error("", resultDTO.getMessage());
    }

    @Override
    public List<GetCaCheKeyItemIdDTO> newUploadFilesSaveAndReturnItemId(NewUploadFilesSavePayload payload) {
        this.newUploadFilesSave(payload);
        GetCaCheKeyItemIdPayload getCaCheKeyItemIdPayload = new GetCaCheKeyItemIdPayload();
        getCaCheKeyItemIdPayload.setCacheKeys(payload.getCacheKey());
        List<GetCaCheKeyItemIdDTO> caCheKeyItemId = this.getCaCheKeyItemId(getCaCheKeyItemIdPayload);
        return caCheKeyItemId;
    }

    @Override
    public List<GetCaCheKeyItemIdDTO> getCaCheKeyItemId(GetCaCheKeyItemIdPayload paload) {
        GetCaCheKeyItemIdListDTO resultDTO;
        Assert.notNull(paload.getCacheKeys(), (String)"\u9644\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String yeedocJwt = this.getYeedocJwt();
        String getCaCheKeyItemIdUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetCaCheKeyItemId";
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)paload), Map.class);
        String result = this.executePost(getCaCheKeyItemIdUrl, map, yeedocJwt);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            log.info("[getCaCheKeyItemId-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        try {
            resultDTO = (GetCaCheKeyItemIdListDTO)JSONObject.parseObject((String)result, GetCaCheKeyItemIdListDTO.class);
        }
        catch (Exception e) {
            log.error("[getCaCheKeyItemId-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        if (resultDTO.getCode() == 0) {
            return resultDTO.getData();
        }
        log.error("[getCaCheKeyItemId-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
        throw TwException.error("", resultDTO.getMessage());
    }

    @Override
    public List<GetAllItemsInfoDTO> getAllItemsInfo(GetAllItemsInfoPayload payload) {
        GetAllItemsInfoListDTO resultDTO;
        Map map;
        String yeedocJwt = this.getYeedocJwt();
        String uri = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetAllItemsInfo";
        String result = this.executePost(uri, map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)payload), Map.class), yeedocJwt);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            log.info("[GetAllItemsInfo-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        try {
            resultDTO = (GetAllItemsInfoListDTO)JSONObject.parseObject((String)result, GetAllItemsInfoListDTO.class);
        }
        catch (Exception e) {
            log.error("[GetAllItemsInfo-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        if (resultDTO.getCode() == 0) {
            return resultDTO.getData();
        }
        log.error("[GetAllItemsInfo-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
        throw TwException.error("", resultDTO.getMessage());
    }

    @Override
    public YeedocCreateFolderForTwDTO createFolderForTw(CreateFolderTwPayload createFolderTwPayload) {
        String yeedocJwt = this.getYeedocJwt();
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreatrFolderForTw";
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)createFolderTwPayload), Map.class);
        String result = this.executePost(createFolderUrl, map, yeedocJwt);
        YeedocCreateFolderForTwDTO folderForTwReturnOne = this.createFolderForTwReturnOne(result);
        return folderForTwReturnOne;
    }

    @Override
    public YeedocCreateFolderForTwDTO createFolderForTwReturnOne(String yeedcocReturnResult) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)yeedcocReturnResult)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + yeedcocReturnResult + "}");
        }
        YeedocCreateFolderForTwListDTO yeedocCreateFolderForTwListDTO = (YeedocCreateFolderForTwListDTO)JSONObject.parseObject((String)yeedcocReturnResult, YeedocCreateFolderForTwListDTO.class);
        List<YeedocCreateFolderForTwDTO> dataList = yeedocCreateFolderForTwListDTO.getData();
        if (CollectionUtils.isEmpty(dataList)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + yeedcocReturnResult + "}");
        }
        return dataList.get(0);
    }

    @Override
    public String createFolder(CreateFolderPayload createFolderPayload) {
        String yeedocJwt = this.getYeedocJwt();
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreateFloder";
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)createFolderPayload), Map.class);
        return this.executePut(createFolderUrl, map, yeedocJwt);
    }

    @Override
    public YeedocCreateFolderDataDTO createFolderReturn(String yeedcocReturnResult) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)yeedcocReturnResult)) {
            log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)yeedcocReturnResult);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + yeedcocReturnResult);
        }
        YeedocCreateFolderDTO createFolderDTO = null;
        try {
            createFolderDTO = (YeedocCreateFolderDTO)JSONObject.parseObject((String)yeedcocReturnResult, YeedocCreateFolderDTO.class);
        }
        catch (Exception e) {
            log.error("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)yeedcocReturnResult);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + yeedcocReturnResult);
        }
        if (createFolderDTO.getCode() == 0) {
            YeedocCreateFolderDataDTO data = createFolderDTO.getData();
            if (null == data) {
                log.error("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)yeedcocReturnResult);
                throw TwException.error("", createFolderDTO.getMessage());
            }
            return data;
        }
        log.error("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)yeedcocReturnResult);
        throw TwException.error("", createFolderDTO.getMessage());
    }

    @Override
    public String itemInfo(ItemInfoPayload itemInfoPayload) {
        String yeedocJwt = this.getYeedocJwt();
        String uri = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/PMSItemInfo";
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemInfoPayload), Map.class);
        return this.executePost(uri, map, yeedocJwt);
    }

    @Override
    public Map<String, List<ItemInfoDataFileDTO>> itemInfoReturn(ItemInfoPayload itemInfoPayload) {
        Map map;
        String yeedocJwt = this.getYeedocJwt();
        String uri = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/PMSItemInfo";
        String result = this.executePost(uri, map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemInfoPayload), Map.class), yeedocJwt);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            log.error("[\u6839\u636e\u6587\u4ef6\u5939id\u6279\u91cf\u67e5\u8be2\u5176\u4e0b\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        ItemInfoDataDTO infoDataDTO = null;
        try {
            infoDataDTO = (ItemInfoDataDTO)JSONObject.parseObject((String)result, ItemInfoDataDTO.class);
        }
        catch (Exception e) {
            log.error("[\u6839\u636e\u6587\u4ef6\u5939id\u6279\u91cf\u67e5\u8be2\u5176\u4e0b\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        if (infoDataDTO.getCode() == 0) {
            return infoDataDTO.getData();
        }
        log.error("[\u6839\u636e\u6587\u4ef6\u5939id\u6279\u91cf\u67e5\u8be2\u5176\u4e0b\u6587\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
        throw TwException.error("", infoDataDTO.getMessage());
    }

    @Override
    public List<FolderListByItemNameDTO> folderListByItemName(FolderListByItemNamePayload payload) {
        Map map;
        String yeedocJwt = this.getYeedocJwt();
        String uri = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Template/FolderListByItemName";
        String result = this.executePost(uri, map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)payload), Map.class), yeedocJwt);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
            log.error("[\u6839\u636e\u6587\u4ef6\u540d\u79f0 \u67e5\u8be2 \u6240\u5c5e\u6587\u4ef6\u5939 id-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        FolderListByItemNameListDTO infoDataDTO = null;
        try {
            infoDataDTO = (FolderListByItemNameListDTO)JSONObject.parseObject((String)result, FolderListByItemNameListDTO.class);
        }
        catch (Exception e) {
            log.error("[\u6839\u636e\u6587\u4ef6\u540d\u79f0 \u67e5\u8be2 \u6240\u5c5e\u6587\u4ef6\u5939 id-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + result);
        }
        if (infoDataDTO.getCode() == 0) {
            return infoDataDTO.getData();
        }
        log.error("[\u6839\u636e\u6587\u4ef6\u540d\u79f0 \u67e5\u8be2 \u6240\u5c5e\u6587\u4ef6\u5939 id-\u6613\u9053\u58f3]-resultStr:{}", (Object)result);
        throw TwException.error("", infoDataDTO.getMessage());
    }

    @Override
    public String reNameFolder(Map<String, Object> map) {
        String yeedocJwt = this.getYeedocJwt();
        String reNameFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ReName";
        return this.executePost(reNameFolderUrl, map, yeedocJwt);
    }

    @Override
    public String preViewItemPro(String itemId) {
        String yeedocJwt = this.getYeedocJwt();
        String preViewItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetItemDetailForTwCrm";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", itemId);
        return this.executePost(preViewItemUrl, map, yeedocJwt);
    }

    @Override
    public String deleteItem(String itemId) {
        String yeedocJwt = this.getYeedocJwt();
        return this.deleteItem(itemId, yeedocJwt);
    }

    @Override
    public String deleteItem(String itemId, String authToken) {
        String deleteItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ItemRecycled";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", Collections.singletonList(itemId));
        return this.executePost(deleteItemUrl, map, authToken);
    }

    @Override
    public String getYeedocJwt(SysUserDTO loginUser) {
        String sercretKey = this.yeedocProperties.getSercretKey();
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("LoginName", loginUser.getEmail());
        userInfoMap.put("UserName", loginUser.getUsername());
        userInfoMap.put("UserMail", loginUser.getEmail());
        payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
        payloadMap.put("exp", (String)DateUtil.offsetDay((Date)new Date(), (int)30));
        String token = JwtUtil.getToken(null, payloadMap, sercretKey);
        return token;
    }

    @Override
    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        return this.getYeedocJwt(loginUser);
    }

    private String getToken() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgEmployeeDAO.queryByUserId(userId);
        Assert.notNull((Object)prdOrgEmployeeDO, (String)"\u5458\u5de5\u4fe1\u606f\u672a\u7ef4\u62a4", (Object[])new Object[0]);
        return prdOrgEmployeeDO.getPcLoginTicket();
    }

    private String base64Encrypt(String value) {
        String s = null;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        if (b != null) {
            s = Base64.getEncoder().encodeToString(b);
        }
        return s;
    }

    private String executePost(String url, Map<String, Object> map) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    @Deprecated
    private String executePost(String url, Object object) {
        String result;
        String param = JSONObject.toJSONString((Object)object);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    private String executePost(String url, Map<String, Object> map, String authToken) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        Map headers = new HashMap();
        try {
            HttpRequest header = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).header("Source", this.yeedocProperties.getSource())).header("AuthToken", authToken);
            headers = header.headers();
            result = header.body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)JSONUtil.toJsonStr(headers));
        log.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }

    private String executePut(String url, Map<String, Object> map, String authToken) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        Map headers = new HashMap();
        try {
            HttpRequest header = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.put((String)url).header("Content-Type", "application/json;charset=utf-8")).header("Source", this.yeedocProperties.getSource())).header("AuthToken", authToken);
            headers = header.headers();
            result = header.body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)JSONUtil.toJsonStr(headers));
        log.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }

    public YeedocProServiceImpl(ApiRequestLogService apiRequestLogService, YeedocProProperties yeedocProperties, PrdOrgEmployeeDAO prdOrgEmployeeDAO) {
        this.apiRequestLogService = apiRequestLogService;
        this.yeedocProperties = yeedocProperties;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
    }
}

