package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigAllowRolePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigAllowRoleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigAllowRoleService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigAllowRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 通用文档-文档类型访问权限
 *
 * @author duwh
 * @date 2023-12-10
 */
@Api(tags = "通用文档-文档类型访问权限")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessDocTypeConfigAllowRole")
@Slf4j
public class BusinessDocTypeConfigAllowRoleController {

private final BusinessDocTypeConfigAllowRoleService businessDocTypeConfigAllowRoleService;

    /**
     * 通用文档-文档类型访问权限-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("通用文档-文档类型访问权限-新增")
    public TwOutputUtil<BusinessDocTypeConfigAllowRoleVO> insert(@RequestBody BusinessDocTypeConfigAllowRolePayload payload){
         return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.insert(payload));
    }

    /**
     * 通用文档-文档类型访问权限-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("通用文档-文档类型访问权限-更新")
    public TwOutputUtil<BusinessDocTypeConfigAllowRoleVO> update(@RequestBody BusinessDocTypeConfigAllowRolePayload payload){
        return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.update(payload));
    }

    /**
     * 通用文档-文档类型访问权限-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("通用文档-文档类型访问权限-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeConfigAllowRolePayload payload){
        return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.updateByKeyDynamic(payload));
    }

    /**
     * 通用文档-文档类型访问权限-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("通用文档-文档类型访问权限-主键查询")
    public TwOutputUtil<BusinessDocTypeConfigAllowRoleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.queryByKey(key));
    }

    /**
     * 通用文档-文档类型访问权限-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("通用文档-文档类型访问权限-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeConfigAllowRoleVO>> paging(BusinessDocTypeConfigAllowRoleQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.queryPaging(query));
    }

    /**
     * 通用文档-文档类型访问权限-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("通用文档-文档类型访问权限-查询列表")
    public TwOutputUtil<List<BusinessDocTypeConfigAllowRoleVO>> queryList(BusinessDocTypeConfigAllowRoleQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigAllowRoleService.queryListDynamic(query));
    }

    /**
     * 通用文档-文档类型访问权限-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("通用文档-文档类型访问权限-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessDocTypeConfigAllowRoleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

