package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeRefService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeRefVO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeRefConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeRefDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeRefDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置与业务关系表
 *
 * @author duwh
 * @date 2023-12-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeRefServiceImpl extends BaseServiceImpl implements BusinessDocTypeRefService {

    private final BusinessDocTypeRefRepo businessDocTypeRefRepo;
    private final BusinessDocTypeRefDAO businessDocTypeRefDAO;

    @Override
    public PagingVO<BusinessDocTypeRefVO> queryPaging(BusinessDocTypeRefQuery query) {
        return businessDocTypeRefDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypeRefVO> queryListDynamic(BusinessDocTypeRefQuery query) {
        return businessDocTypeRefDAO.queryListDynamic(query);
    }

    @Override
    public BusinessDocTypeRefVO queryByKey(Long key) {
        BusinessDocTypeRefDO entity = businessDocTypeRefRepo.findById(key).orElseGet(BusinessDocTypeRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeRefVO vo = BusinessDocTypeRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeRefVO insert(BusinessDocTypeRefPayload payload) {
        //  重复性校验
        if (businessDocTypeRefRepo.existsByDocTypeAndDocIdAndConfigRuleId(payload.getDocType(), payload.getDocId(),payload.getConfigRuleId())) {
            throw new IllegalArgumentException("文档配置业务关系已存在");
        }
        BusinessDocTypeRefDO entityDo = BusinessDocTypeRefConvert.INSTANCE.toDo(payload);
        return BusinessDocTypeRefConvert.INSTANCE.toVo(businessDocTypeRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeRefVO update(BusinessDocTypeRefPayload payload) {
        BusinessDocTypeRefDO entity = businessDocTypeRefRepo.findById(payload.getId()).orElseGet(BusinessDocTypeRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeRefDO entityDo = BusinessDocTypeRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeRefConvert.INSTANCE.toVo(businessDocTypeRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeRefPayload payload) {
        BusinessDocTypeRefDO entity = businessDocTypeRefRepo.findById(payload.getId()).orElseGet(BusinessDocTypeRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeRefDAO.deleteSoft(keys);
        }
    }

    @Override
    public BusinessDocTypeRefVO getByDocTypeAndDocIdAndRuleId(String docType, Long docId, Long configRuleId) {
        if (docType != null && docId != null) {
            return businessDocTypeRefDAO.getByDocTypeAndDocIdAndRuleId(docType, docId, configRuleId);
        }
        return null;
    }

}
