package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.common.permission.contants.PermissionContants.ADMIN;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 13:44
 **/
@Service(value = "BUSINESS_OBJECT_TYPE_FIELD_ROLE_AND_IMMEDIATE_SUPERIOR_USER")
public class BusinessObjectTypeFieldRoleAndImmediateUser implements BusinessObjectTypeStrategyService {

    @Lazy
    @Autowired
    private PrdOrgEmployeeService prdOrgEmployeeService;

    /**
     * 字段角色及直属上级用户
     *
     * @param rule
     * @param mapBuilder
     * @param ruleGroupExprList
     * @param loginUserId
     * @param defaultOrgId
     * @param childOrgIdSet
     * @param map
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, Map<String, Object> map) {

        // 查询用户直属上级
        List<PrdOrgEmployeeRefVO> frontEmployee = prdOrgEmployeeService.queryParentUsers(null, loginUserId);

        Set<Long> frontEmployeeSet = new HashSet<>();

        // 如果发现直属上级为空 直接给权限
        if (CollectionUtils.isEmpty(frontEmployee)) {
            map.put(ADMIN, true);
            return true;
        }

        // 发现需要权限管控 加入到分组中
        mapBuilder.group(rule.getRuleCode());

        // 发现还是有上级的 拿到上级userid
        frontEmployee.forEach(emp -> {
            frontEmployeeSet.add(emp.getParentId());
        });

        frontEmployeeSet.add(loginUserId);

        // 查询这些直属下级
        mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()), frontEmployeeSet).op(FieldOps.InList);

        return true;
    }

}
