package com.elitesland.tw.tw5.server.common.util;

import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Objects;

@Slf4j
@Component
@RequiredArgsConstructor
public class ChangeFieldUtil {

    /**
     * 获取变更内容
     *
     * @param newBean 更改后的Bean
     * @param oldBean 更改前的Bean
     * @param <T>
     * @return
     */
    public <T> String getFieldsUpdateLog(T newBean, T oldBean) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(FieldUpdateLog.class)) {
                try {
                    final String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                    Object newValue = field.get(newBean);
                    Object oldValue = field.get(oldBean);

                    if (null == newValue) {
                        continue;
                    }
                    if (ObjectUtils.isEmpty(newValue)) {
                        newValue = "空";
                    }
                    if (ObjectUtils.isEmpty(oldValue)) {
                        oldValue = "空";
                    }

                    if (!Objects.equals(newValue, oldValue)) {
                        if (field.getType().getName().equals("java.math.BigDecimal")) {
                            if (((BigDecimal) newValue).compareTo((BigDecimal) oldValue) == 0) {
                                continue;
                            }
                        }
                        if (StringUtils.hasText(field.getAnnotation(FieldUpdateLog.class).fieldObject())) {
                        } else {
                            if (StringUtils.hasText(field.getAnnotation(FieldUpdateLog.class).objectNameField())) {
                                //获取字段名称
                                builder.append(getAllFieldValueByFieldName(field.getAnnotation(FieldUpdateLog.class).objectNameField(), oldBean));
                            } else {
                                builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                            }
                            builder.append(" 由 ");
                            builder.append(oldValue);
                            builder.append(changeAction == null ? " 修改为 " : " " + changeAction + " ");
                            builder.append(newValue);
                            builder.append("\n");
                        }
                    }
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return builder.toString();
    }

    public <T> String getFieldsCreateLog(T newBean, String content) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(FieldCreateLog.class)) {
                try {
                    Object newValue = field.get(newBean);
                    if (null == newValue) {
                        continue;
                    }
                    if (!ObjectUtils.isEmpty(newValue)) {
                        final String selectionKey = field.getAnnotation(FieldCreateLog.class).selectionKey();
                        //不处理对象字段，交由程序去处理
                        if (StringUtils.hasText(field.getAnnotation(FieldCreateLog.class).fieldObject())) {
                        } else {
                            //获取字段名称
                            builder.append(field.getAnnotation(FieldCreateLog.class).fieldName());
                            if (!StringUtils.hasText(content)) {
                                content = "创建为";
                            }
                            builder.append(" " + content + " ");
                            builder.append(newValue);
                            builder.append("\n");
                        }
                    }

                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return builder.toString();
    }

    public Object getAllFieldValueByFieldName(String fieldName, Object object) throws IllegalAccessException {
        Field field = null;
        Class<?> clazz = object.getClass();
        //从当前的类开始找，没找到再从父类中找。
        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
            } catch (Exception e) {
                // 这里甚么都不能抛出去。
                // 如果这里的异常打印或者往外抛，则就不会进入
            }
        }
        //设置对象的访问权限，保证对private的属性的访问
        field.setAccessible(true);
        return field.get(object);
    }
}
