package com.elitesland.tw.tw5.server.demo.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.query.DemoSimpleQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.demo.convert.DemoSimpleConvert;
import com.elitesland.tw.tw5.server.demo.dao.DemoSimpleDAO;
import com.elitesland.tw.tw5.server.demo.entity.DemoSimpleDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * 标准样例service
 *
 * @author zhangyongqiang
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DemoSimpleServiceImpl implements DemoSimpleService {

    private final DemoSimpleDAO dao;
    private final TransactionUtilService transactionUtilService;
    private final TransactionTemplate transactionTemplate;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;

    @Transactional
    @Override
    public DemoSimpleVO insert(DemoSimplePayload payload) {
        DemoSimpleDO ado = DemoSimpleConvert.INSTANCE.toDo(payload);
        //编程式事务 --> 保存业务数据（将结果保存到数据库）
        //设置事务传播行为
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(transactionStatus -> {
            dao.save(ado);
            return null;
        });
        DemoSimpleVO demoSimpleVO = DemoSimpleConvert.INSTANCE.toVo(ado);
        if (payload.getSubmit() != null && payload.getSubmit()) {
            submitProc(demoSimpleVO);
        }

        return demoSimpleVO;
    }

    @Override
    public DemoSimpleVO update(DemoSimplePayload payload) {
        dao.updateByKeyDynamic(payload);
//        DemoSimpleDO ado = DemoSimpleConvert.INSTANCE.toDo(payload);
//        dao.save(ado);
        DemoSimpleVO demoSimpleVO = dao.queryByKey(payload.getId());
        if (payload.getSubmit() != null && payload.getSubmit()) {
            submitProc(demoSimpleVO);
        }
        return demoSimpleVO;
//        return DemoSimpleConvert.INSTANCE.toVo(ado);
    }

    @Override
    public DemoSimpleVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public PagingVO<DemoSimpleVO> paging(DemoSimpleQuery query) {

        PagingVO<DemoSimpleVO> demoSimpleVOPagingVO = dao.queryPaging(query);
        List<DemoSimpleVO> records = demoSimpleVOPagingVO.getRecords();
        records.forEach(demoSimpleVO -> transferCustomerDatas(records));
        demoSimpleVOPagingVO.setRecords(records);
        return demoSimpleVOPagingVO;
    }

    private void transferCustomerDatas(List<DemoSimpleVO> records) {
        for (DemoSimpleVO vo : records) {
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            if (!ObjectUtils.isEmpty(vo.getObjectStatus())) {
                //todo:这里具体业务用下拉选择项翻译，此处省略
                switch (vo.getObjectStatus()) {
                    case "APPROVING":
                        vo.setObjectStatusDesc("审批中");
                        break;
                    case "new":
                        vo.setObjectStatusDesc("新建");
                        break;
                    case "active":
                        vo.setObjectStatusDesc("激活");
                        break;
                    case "invalid":
                        vo.setObjectStatusDesc("无效");
                        break;
                }
            }
            if (!ObjectUtils.isEmpty(vo.getProcInstStatus())) {
                vo.setProcInstStatusDesc(vo.getProcInstStatus().getDesc());
            }
        }
    }

    @Override
    public List<DemoSimpleVO> queryList(DemoSimpleQuery query) {
        return dao.queryListDynamic(query);
    }

    @Transactional
    @Override
    public void deleteSoft(List<Long> keys) {
        List<DemoSimpleVO> demoSimpleVOS = dao.queryByKeys(keys);

        if (CollectionUtils.isEmpty(demoSimpleVOS)) {
            throw TwException.error("", "单据不存在，无法删除");
        }
        // 执行删除
        dao.deleteSoft(keys);
        // 停止工作流
        for (DemoSimpleVO demoSimpleVO : demoSimpleVOS) {
            //删除单据的同时删除流程（可以讨论一下我们业务上不这么做，如果有流程统一不让删除，要想删除单据，走作废回调）
            if (demoSimpleVO.getProcInstId() != null) {
                workflowUtil.deleteProcess(DeleteProcessPayload.of(demoSimpleVO.getProcInstId(), ""));
            }
        }
    }


    /**
     * 发起流程
     *
     * @param demoSimpleVO
     */
    private void submitProc(DemoSimpleVO demoSimpleVO) {
        HashMap<String, Object> variables = new HashMap<>();
        variables.put("isSpecial", true);
        //会签审批人(杨林，张勇强)
        variables.put("Activity_05zkia7", CollUtil.newArrayList("579786252467963621", "579785921050840585"));
        //会签审批人（朱跃翔，王贝贝）
        variables.put("Activity_11rzme6", CollUtil.newArrayList("579786372043377650", "579786202115344318"));
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.FLOW_DEMO.name(),
                demoSimpleVO.getObjectName() + "-创建流程",
                demoSimpleVO.getId() + "",
                variables)
        );
        //流程启动成功后，回写业务表数据
        DemoSimplePayload updatePayLoad = new DemoSimplePayload();
        updatePayLoad.setProcInstId(processInfo.getProcInstId());
        updatePayLoad.setId(demoSimpleVO.getId());
        updatePayLoad.setProcInstStatus(processInfo.getProcInstStatus());
        updatePayLoad.setSubmitTime(LocalDateTime.now());
        updatePayLoad.setObjectStatus("APPROVING");//根据业务设置对应的枚举类
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> dao.updateByKeyDynamic(updatePayLoad));
    }
}
