package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description 费用报销税额
 * @Date 2023/12/5
 */
@Entity
@Table(name = "acc_reim_tax", indexes = {
        @Index(name = "idx_reim_id", columnList = "reim_id"),
        @Index(name = "idx_reim_dtl_id", columnList = "reim_dtl_id")
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_tax", comment = "费用报销税额")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimTaxDO extends BaseModel implements Serializable {

    @Comment("报销单ID")
    @Column(name = "reim_id")
    private Long reimId;

    @Comment("报销单明细ID")
    @Column(name = "reim_dtl_id")
    private Long reimDtlId;

    @Comment("会计科目")
    @Column()
    private Long finAccSubjId;

    @Comment("税率")
    @Column()
    private BigDecimal taxRate;

    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;

    public void copy(AccReimTaxDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
