package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingTitlePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingTitleQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingTitleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.*;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceDetailService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingLimitConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingTitleConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingTitleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingLimitDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingTitleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingTitleRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报销抬头校验
 *
 * @author zoey
 * @date 2024-05-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingTitleServiceImpl extends BaseServiceImpl implements AccReimSettingTitleService {

    private final AccReimSettingTitleRepo accReimSettingTitleRepo;
    private final AccReimSettingTitleDAO accReimSettingTitleDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final InvInvoiceService invInvoiceService;
    private final InvInvoiceDetailService invInvoiceDetailService;
    private final PrdOrgCompanyService prdOrgCompanyService;
    private final BusinessPartnerService businessPartnerService;

    @Override
    public PagingVO<AccReimSettingTitleVO> queryPaging(AccReimSettingTitleQuery query){
        return accReimSettingTitleDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingTitleVO> queryListDynamic(AccReimSettingTitleQuery query){
        return accReimSettingTitleDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingTitleVO queryByKey(Long key) {
        AccReimSettingTitleDO entity = accReimSettingTitleRepo.findById(key).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingTitleVO vo = AccReimSettingTitleConvert.INSTANCE.toVo(entity);
        // 查询基础配置表
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.INVOICE_TITLE.getCode());
        List<AccReimSettingVO> accReimSettingVOS = accReimSettingService.queryListDynamic(accReimSettingQuery);
        if(!CollectionUtils.isEmpty(accReimSettingVOS)){
            vo.setAccReimSettingVO(accReimSettingVOS.get(0));
        }
        return vo;


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingTitleVO insert(AccReimSettingTitlePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 保存当前配置表
        AccReimSettingTitleDO entityDo = AccReimSettingTitleConvert.INSTANCE.toDo(payload);
        AccReimSettingTitleVO accReimSettingTitleVO = AccReimSettingTitleConvert.INSTANCE.toVo(accReimSettingTitleRepo.save(entityDo));

        // 保存基础配置表
        Long id = accReimSettingTitleVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.INVOICE_TITLE.getCode());
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingDO));
        accReimSettingTitleVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingTitleVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingTitleVO update(AccReimSettingTitlePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingTitleDO entity = accReimSettingTitleRepo.findById(payload.getId()).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingTitleDO entityDo = AccReimSettingTitleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingTitleVO accReimSettingTitleVO = AccReimSettingTitleConvert.INSTANCE.toVo(accReimSettingTitleRepo.save(entity));
        // 保存基础配置表
        AccReimSettingDO accReimSettingEntity = accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull(accReimSettingEntity.getId(), "不存在");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingTitleVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingTitleVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingTitlePayload payload) {
        AccReimSettingTitleDO entity = accReimSettingTitleRepo.findById(payload.getId()).orElseGet(AccReimSettingTitleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimSettingTitleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimSettingTitleDAO.deleteSoft(keys);
        }
    }

    @Override
    public AccReimSettingTitleVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS, Long reimUserId,Long expenseCompanyId) {
//        PrdOrgCompanyVO prdOrgCompanyVO = prdOrgCompanyService.queryByBookId(expenseCompanyId);
        BusinessPartnerVO businessPartnerVO =null;
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(expenseCompanyId);
        if(CollectionUtils.isEmpty(businessPartnerVOS)){
            throw TwException.error("","报销费用承担公司为空！");
        }else{
            businessPartnerVO = businessPartnerVOS.get(0);
        }
        AccReimSettingTitleVO accReimSettingTitleVO = queryByKey(key);
        String invoiceType = accReimSettingTitleVO.getInvType();
        List<String> invoiceTypeList = Arrays.stream(invoiceType.split(",")).collect(Collectors.toList());


        AccReimSettingVO accReimSettingVO = accReimSettingTitleVO.getAccReimSettingVO();
        // 剔除白名单人员
        String whiteList = accReimSettingVO.getWhiteList();
        if(StringUtils.hasText(whiteList)){
            List<Long> idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //报销人
            if(idList.contains(reimUserId)){
                return accReimSettingTitleVO;
            }
        }
        // 一次查出所有的发票明细,按照发票id分组
        InvInvoiceDetailQuery query = new InvInvoiceDetailQuery();
        List<Long> invoiceIds = invInvoiceVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        query.setInvIds(invoiceIds);
        List<InvInvoiceDetailVO> invInvoiceDetailVOS = invInvoiceDetailService.queryListDynamic(query);
        Map<Long, List<InvInvoiceDetailVO>> groupedInvInvoiceDetailVOSMap = invInvoiceDetailVOS.stream()
                .collect(Collectors.groupingBy(InvInvoiceDetailVO::getInvId));

        String InconsistentTitleStr ="";
        String remindText ="";
        String errorText ="";
        for (InvInvoiceVO invInvoiceVO: invInvoiceVOS) {
            String invNo = invInvoiceVO.getInvoiceNo();
            // 满足规则第一条件
            if(invoiceTypeList.contains(invInvoiceVO.getInvType())){
                // 不参与校验的商品类型
                String exceptCommodityName = accReimSettingTitleVO.getExceptCommodityName();
                List<String> exceptList = Arrays.stream(exceptCommodityName.split(",")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(groupedInvInvoiceDetailVOSMap.get(invInvoiceVO.getId()))){
                    String commodityName = invInvoiceDetailVOS.get(0).getCommodityName();
                    int start = commodityName.indexOf("*") + 1;
                    int end = commodityName.indexOf("*", start);
                    commodityName = commodityName.substring(start, end);
                    if(exceptList.contains(commodityName)){
                        continue;
                    }
                }
                // 校验逻辑
                // 校验抬头和税号
                String checkContent = accReimSettingTitleVO.getCheckContent();
                if(StringUtils.hasText(checkContent)){
                    List<String> collect = Arrays.stream(checkContent.split(",")).collect(Collectors.toList());
                    Boolean notEqualFlag = false;
                    if(collect.contains("title")){
                        String purchaserName = invInvoiceVO.getPurchaserName();
                        String companyName = businessPartnerVO.getPartnerName();
                        if(purchaserName==null || !purchaserName.equals(companyName)){
                            notEqualFlag=true;
                        }
                    }
                    if(collect.contains("taxNo")){
                        String saleTaxNo = invInvoiceVO.getSaleTaxNo();
                        String taxNo = businessPartnerVO.getIdenNo();
                        if(!saleTaxNo.equals(taxNo)){
                            notEqualFlag=true;
                        }
                    }
                    accReimSettingTitleVO.setNotEqualFlag(notEqualFlag);
                    if(notEqualFlag){
                        if(accReimSettingVO.getRemindText()!=null){
                            String remindTextCopy = accReimSettingVO.getRemindText();
                            remindTextCopy=remindTextCopy.replace("#{1}",invNo);
                            remindText=remindText.length()<1?remindText+remindTextCopy:remindText+","+remindTextCopy;
                        }
                        if(accReimSettingVO.getErrorText()!=null){
                            String errorTextCopy = accReimSettingVO.getErrorText();
                            errorTextCopy=errorTextCopy.replace("#{1}",invNo);
                            errorText=errorText.length()<1?errorText+errorTextCopy:errorText+","+errorTextCopy;
                        }
                    }
                }
            }
        }

        accReimSettingVO.setRemindText(remindText);
        accReimSettingVO.setErrorText(errorText);
        return accReimSettingTitleVO;
    }

}
