package com.elitesland.tw.tw5.server.prd.adm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmFeeApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.entity.QAdmFeeApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmFeeApplyDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 特殊费用申请明细管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Repository
@RequiredArgsConstructor
public class AdmFeeApplyDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AdmFeeApplyDetailRepo repo;
    private final QAdmFeeApplyDetailDO qdo = QAdmFeeApplyDetailDO.admFeeApplyDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AdmFeeApplyDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AdmFeeApplyDetailVO.class,
                qdo.id,
                qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请单id
                qdo.applyId,
                // 序号
                qdo.lineNo,
                // 科目id
                qdo.accId,
                // 申请金额
                qdo.applyAmt,
                // 币种
                qdo.currCode,
                // 税率
                qdo.taxRate,
                // 税额
                qdo.taxAmt,
                // 费用说明
                qdo.feeDesc
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AdmFeeApplyDetailVO> getJpaQueryWhere(AdmFeeApplyDetailQuery query) {
        JPAQuery<AdmFeeApplyDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AdmFeeApplyDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AdmFeeApplyDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请单id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyId())) {
            list.add(qdo.applyId.eq(query.getApplyId()));
        }
        /** 序号 精确 */
        if (!ObjectUtils.isEmpty(query.getLineNo())) {
            list.add(qdo.lineNo.eq(query.getLineNo()));
        }
        /** 科目id 精确 */
        if (!ObjectUtils.isEmpty(query.getAccId())) {
            list.add(qdo.accId.eq(query.getAccId()));
        }
        /** 申请金额 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyAmt())) {
            list.add(qdo.applyAmt.eq(query.getApplyAmt()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 税额 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAmt())) {
            list.add(qdo.taxAmt.eq(query.getTaxAmt()));
        }
        /** 费用说明 精确 */
        if (!ObjectUtils.isEmpty(query.getFeeDesc())) {
            list.add(qdo.feeDesc.eq(query.getFeeDesc()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AdmFeeApplyDetailVO queryByKey(Long id) {
        JPAQuery<AdmFeeApplyDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AdmFeeApplyDetailVO> queryListDynamic(AdmFeeApplyDetailQuery query) {
        JPAQuery<AdmFeeApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AdmFeeApplyDetailVO> queryPaging(AdmFeeApplyDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AdmFeeApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<AdmFeeApplyDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AdmFeeApplyDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AdmFeeApplyDetailDO save(AdmFeeApplyDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AdmFeeApplyDetailDO> saveAll(List<AdmFeeApplyDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AdmFeeApplyDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请单id
        if (payload.getApplyId() != null) {
            update.set(qdo.applyId, payload.getApplyId());
        }
        // 序号
        if (payload.getLineNo() != null) {
            update.set(qdo.lineNo, payload.getLineNo());
        }
        // 科目id
        if (payload.getAccId() != null) {
            update.set(qdo.accId, payload.getAccId());
        }
        // 申请金额
        if (payload.getApplyAmt() != null) {
            update.set(qdo.applyAmt, payload.getApplyAmt());
        }
        // 币种
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 税额
        if (payload.getTaxAmt() != null) {
            update.set(qdo.taxAmt, payload.getTaxAmt());
        }
        // 费用说明
        if (payload.getFeeDesc() != null) {
            update.set(qdo.feeDesc, payload.getFeeDesc());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请单id
            if (nullFields.contains("applyId")) {
                update.setNull(qdo.applyId);
            }
            // 序号
            if (nullFields.contains("lineNo")) {
                update.setNull(qdo.lineNo);
            }
            // 科目id
            if (nullFields.contains("accId")) {
                update.setNull(qdo.accId);
            }
            // 申请金额
            if (nullFields.contains("applyAmt")) {
                update.setNull(qdo.applyAmt);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 税额
            if (nullFields.contains("taxAmt")) {
                update.setNull(qdo.taxAmt);
            }
            // 费用说明
            if (nullFields.contains("feeDesc")) {
                update.setNull(qdo.feeDesc);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据申请id逻辑删除
     *
     * @param applyIds 申请id
     * @return 删除的行数
     */
    public long deleteSoftByApplyId(List<Long> applyIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.applyId.in(applyIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

