package com.elitesland.tw.tw5.server.prd.adm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Entity
@Table(name = "adm_fee_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "adm_fee_apply", comment = "特殊费用申请管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AdmFeeApplyDO extends BaseModel implements Serializable {
    /**
     * 申请单号
     */
    @Comment("申请单号")
    @Column()
    private String applyNo;
    /**
     * 申请单名称
     */
    @Comment("申请单名称")
    @Column()
    private String applyName;
    /**
     * 申请状态
     */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procInstId;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 财务期间id
     */
    @Comment("财务期间id")
    @Column()
    private Long finPeriodId;
    /**
     * 用途类型
     */
    @Comment("用途类型")
    @Column()
    private String usageType;
    /**
     * 事由类型
     */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /**
     * 事由id
     */
    @Comment("事由id")
    @Column()
    private Long reasonId;
    /**
     * 事由名称（冗余字段）
     */
    @Comment("事由名称（冗余字段）")
    @Column()
    private String reasonName;
    /**
     * 费用承担bu_id
     */
    @Comment("费用承担bu_id")
    @Column()
    private Long expenseBuId;
    /**
     * 费用归属bu_id
     */
    @Comment("费用归属bu_id")
    @Column()
    private Long sumBuId;
    /**
     * 申请人资源id
     */
    @Comment("申请人资源id")
    @Column()
    private Long applyResId;
    /**
     * 申请人bu_id
     */
    @Comment("申请人bu_id")
    @Column()
    private Long applyBuId;
    /**
     * 费用承担公司id
     */
    @Comment("费用承担公司id")
    @Column()
    private Long ouId;
    /**
     * 费用承担方（类型）
     */
    @Comment("费用承担方（类型）")
    @Column()
    private String expenseByType;
    /**
     * 申请金额
     */
    @Comment("申请金额")
    @Column()
    private BigDecimal applyAmt;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 预计使用日期
     */
    @Comment("预计使用日期")
    @Column()
    private LocalDate expectDate;
    /**
     * 报销模板id
     */
    @Comment("报销模板id")
    @Column()
    private Long reimTmplId;
    /**
     * 客户id
     */
    @Comment("客户id")
    @Column()
    private Long custId;
    /**
     * 项目非项目
     */
    @Comment("项目非项目")
    @Column()
    private String applyType;
    /**
     * 费用码
     */
    @Comment("费用码")
    @Column()
    private String feeCode;

    @Comment("报销单ID")
    @Column()
    private Long reimId;

    public void copy(AdmFeeApplyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
