package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Entity
@Table(name = "pms_budget", indexes = {
        @Index(name = "source_type_id_index", columnList = "source_type,source_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget", comment = "预算基本信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BudgetDO extends BaseModel implements Serializable {
    /**
     * 费用归属：合同项目、BU项目、商机项目
     */
    @Comment("费用归属：合同项目、BU项目、商机项目")
    @Column(name = "source_type")
    private String sourceType;
    /**
     * 费用归属ID
     */
    @Comment("费用归属ID")
    @Column(name = "source_id")
    private Long sourceId;

    @Comment("费用归属名称")
    @Column()
    private String sourceName;

    @Comment("费用归属编号")
    @Column()
    private String sourceCode;

    @Comment("交付BU_ID")
    @Column()
    private Long deliBuId;

    @Comment("当量预估单价")
    @Column()
    private BigDecimal eqvaPrice;

    /**
     * 预算名称
     */
    @Comment("预算名称")
    @Column()
    private String budgetName;
    /**
     * 预算状态：新建、审批中、激活（已审批）、关闭
     */
    @Comment("预算状态：新建、审批中、激活（已审批）、关闭")
    @Column()
    private String budgetStatus;
    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer versionNo;
    /**
     * 流程名字
     */
    @Comment("流程名字")
    @Column()
    private String procInstName;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /**
     * 是否可选择 0 false 不可选择 1 true 可选择
     */
    @Comment("是否可选择 0 false 不可选择 1 true 可选择")
    @Column()
    private Boolean selectFlag;
    /**
     * 预算编码
     */
    @Comment("预算编码")
    @Column()
    private String budgetCode;
    /**
     * 控制类型：刚性、 柔性 、不控制
     */
    @Comment("控制类型：刚性、 柔性 、不控制")
    @Column()
    private String controlType;
    /**
     * 开始日期
     */
    @Comment("开始日期")
    @Column()
    private LocalDate budgetStartDate;
    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate budgetEndDate;
    /**
     * 申请人
     */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 拓展字段1
     */
    @Comment("拓展字段1")
    @Column()
    private String extVarchar1;
    /**
     * 拓展字段2
     */
    @Comment("拓展字段2")
    @Column()
    private String extVarchar2;
    /**
     * 拓展字段3
     */
    @Comment("拓展字段3")
    @Column()
    private String extVarchar3;
    /**
     * 拓展字段4
     */
    @Comment("拓展字段4")
    @Column()
    private String extVarchar4;
    /**
     * 拓展字段5
     */
    @Comment("拓展字段5")
    @Column()
    private String extVarchar5;
    /**
     * 拓展字段6
     */
    @Comment("拓展字段6")
    @Column()
    private String extVarchar6;
    /**
     * 拓展字段7
     */
    @Comment("拓展字段7")
    @Column()
    private String extVarchar7;
    /**
     * 拓展字段8
     */
    @Comment("拓展字段8")
    @Column()
    private String extVarchar8;
    /**
     * 拓展字段9
     */
    @Comment("拓展字段9")
    @Column()
    private String extVarchar9;
    /**
     * 预算附件
     */
    @Comment("预算附件")
    @Column()
    private String budgetFiles;
    /**
     * 流程定义的KEY
     */
    @Comment("流程定义的KEY")
    @Column()
    private String procDefKey;
    /**
     * 预算年度
     */
    @Comment("预算年度")
    @Column()
    private String finYear;

    /**
     * 预算总金额=规划费用金额+规划当量数金额
     */
    @Comment("预算总金额")
    @Column()
    private BigDecimal totalAmt;
    /**
     * 原始预算总金额
     */
    @Comment("原始预算总金额")
    @Column()
    private BigDecimal originalTotalAmt;

    /**
     * 规划费用金额
     */
    @Comment("规划费用金额")
    @Column()
    private BigDecimal planAmt;
    /**
     * 原始规划费用金额
     */
    @Comment("原始规划费用金额")
    @Column()
    private BigDecimal originalPlanAmt;

    @Comment("规划当量数")
    @Column()
    private BigDecimal planEqva;
    @Comment("规划当量数金额")
    @Column()
    private BigDecimal planEqvaAmt;
    @Comment("原始当量规划当量数")
    @Column()
    private BigDecimal originalPlanEqva;
    @Comment("原始规划当量数金额")
    @Column()
    private BigDecimal originalPlanEqvaAmt;


    /**
     * 已拨付金额
     */
    @Comment("已拨付费用金额")
    @Column()
    private BigDecimal allocatedAmt;
    @Comment("已拨付当量数")
    @Column()
    private BigDecimal allocatedEqva;
    @Comment("已拨付当量数金额")
    @Column()
    private BigDecimal allocatedEqvaAmt;
    @Comment("已拨付总金额")
    @Column()
    private BigDecimal allocatedTotalAmt;


    @Comment("科目模板")
    @Column()
    private Long subjectTempId;

    /**
     * 已使用金额
     */
    @Comment("已使用金额")
    @Column()
    private BigDecimal usedAmt;

    @Comment("已使用当量数")
    @Column()
    private BigDecimal usedEqva;

    @Comment("占用当量数")
    @Column()
    private BigDecimal occupyEqva;
    /**
     * 占用金额
     */
    @Comment("占用金额")
    @Column()
    private BigDecimal occupyAmt;

    @Comment("使用当量占比")
    @Column()
    private BigDecimal usedEqvaProportion;

    @Comment("使用费用占比")
    @Column()
    private BigDecimal usedAmtProportion;

    @Comment("累计拨付比例")
    @Column()
    private BigDecimal allocatedAppropriation;

    @Comment("初始项目盈亏平衡最大成本")
    @Column()
    private BigDecimal totalCost;

    public void copy(BudgetDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
