package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalNormSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalNormSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalNormSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Api(tags = "泛用金额结算管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calNormSettle")
@Slf4j
public class CalNormSettleController {

    private final CalNormSettleService calNormSettleService;

    /**
     * 泛用金额结算管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("泛用金额结算管理-新增")
    public TwOutputUtil<CalNormSettleVO> insert(@RequestBody CalNormSettlePayload payload) {
        return TwOutputUtil.ok(calNormSettleService.insertOrUpdate(payload));
    }

    /**
     * 泛用金额结算管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("泛用金额结算管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalNormSettlePayload payload) {
        return TwOutputUtil.ok(calNormSettleService.updateByKeyDynamic(payload));
    }

    /**
     * 泛用金额结算管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("泛用金额结算管理-主键查询")
    public TwOutputUtil<CalNormSettleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calNormSettleService.queryByKey(key));
    }

    /**
     * 泛用金额结算管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("泛用金额结算管理-分页")
    public TwOutputUtil<PagingVO<CalNormSettleVO>> paging(CalNormSettleQuery query) {
        return TwOutputUtil.ok(calNormSettleService.queryPaging(query));
    }

    /**
     * 泛用金额结算管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("泛用金额结算管理-查询列表")
    public TwOutputUtil<List<CalNormSettleVO>> queryList(CalNormSettleQuery query) {
        return TwOutputUtil.ok(calNormSettleService.queryListDynamic(query));
    }

    /**
     * 泛用金额结算管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("泛用金额结算管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calNormSettleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 泛用金额结算管理-取消过账
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/cancelNorm/{key}")
    @ApiOperation("泛用金额结算管理-取消过账")
    public TwOutputUtil cancelNorm(@PathVariable Long key) {
        calNormSettleService.cancelNorm(key);
        return TwOutputUtil.ok();
    }

    /**
     * 模板下载
     *
     * @return result
     */
    @ApiOperation("模板下载")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response) {
        calNormSettleService.downloadPlus(response);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file) {
        calNormSettleService.batchImport(file);
        return TwOutputUtil.ok();
    }
}

