package com.elitesland.tw.tw5.server.prd.cas.controller;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSettingService;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSsoService;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * Cas单点登录
 *
 * @author zoey
 * @date 2024/01/25
 */
@Api("Cas单点登录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cas/sso")
@Slf4j
public class CasSsoController {

    private final PrdUserService prdUserService;

    private final PrdCasSsoService casSsoService;


    /**
     * 校验ticket合法性
     * <p>
     * 重复see com.elitesland.tw.tw5.server.prd.my.controller.PrdUserController#queryUserByTicket(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     *
     * @param request  请求
     * @param response 响应
     */
    @GetMapping({"/authc/pc"})
    public void yePcLogin(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        log.info("----------------------------------------");
        log.info("ticket:{}", ticket);
        prdUserService.queryUserByTicket(request, response);
    }

    /**
     * 单点登录获取token和url
     */
    @GetMapping({"/getTicketAndUrl/{appId}"})
    public TwOutputUtil getTokenAndUrl(@PathVariable String appId,HttpServletRequest request, HttpServletResponse response) {
        Map resultMap =casSsoService.getTicketAndUrl(appId,request,response);
        return TwOutputUtil.ok(resultMap);
    }


}
