package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsMembersQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsMembersVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsMembersRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmLeadsMembersDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmLeadsMembersRepo repo;
    private final QCrmLeadsMembersDO qdo = QCrmLeadsMembersDO.crmLeadsMembersDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmLeadsMembersDO save(CrmLeadsMembersDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmLeadsMembersDO> saveAll(List<CrmLeadsMembersDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmLeadsMembersVO queryByKey(Long id) {
        JPAQuery<CrmLeadsMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmLeadsMembersVO> getJpaQuerySelect() {
        JPAQuery<CrmLeadsMembersVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmLeadsMembersVO.class,
                qdo.id
//                qdo.userId
//                qdo.leadsId
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmLeadsMembersVO> getJpaQueryWhere(CrmLeadsMembersQuery query) {
        JPAQuery<CrmLeadsMembersVO> jpaQuery = getJpaQuerySelect();

//        if (!ObjectUtils.isEmpty(query.getUserId())) {
//            jpaQuery.where(qdo.userId.eq(query.getUserId()));
//        }
//        if (!ObjectUtils.isEmpty(query.getLeadsId())) {
//            jpaQuery.where(qdo.leadsId.eq(query.getLeadsId()));
//        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合(不分页查询)
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmLeadsMembersVO> queryListDynamic(CrmLeadsMembersQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmLeadsMembersVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }


    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmLeadsMembersVO> queryPaging(CrmLeadsMembersQuery query) {
        JPAQuery<CrmLeadsMembersVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmLeadsMembersVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmLeadsMembersVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(CrmLeadsMembersPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
//        if (payload.getUserId() != null) {
//            update.set(qdo.userId, payload.getUserId());
//        }
//        if (payload.getLeadsId() != null) {
//            update.set(qdo.leadsId, payload.getLeadsId());
//        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();

    }

    public List<CrmLeadsMembersDO> queryByLeadsId(Long leadsId) {
        return repo.findByLeads_Id(leadsId);
    }


    public List<CrmLeadsMembersDO> queryByUserIds(List<Long> userIds) {
        return repo.findByUserIdIn(userIds);
    }
}
