package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActPlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActPlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActPlanDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 市场计划管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmActPlanServiceImpl extends BaseServiceImpl implements CrmActPlanService {
    private final CacheUtil cacheUtil;
    private final CrmActPlanDAO dao;
    private final ExcelUtil excelUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdSystemSelectionService service;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final TransactionUtilService transactionUtilService;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowUtil workflowUtil;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;

    @Transactional
    @Override
    public CrmActPlanVO insert(CrmActPlanPayload payload) {
        payload.setPlanYear(payload.getPlanYear().trim());
        if (dao.queryByYearOrOrgId(payload.getPlanYear(), payload.getOrgId()) != null) {
            throw TwException.error("", "该组织已存在" + payload.getPlanYear() + "年度计划");
        }
        String code = generateSeqNum("ACT_PLAN_NO");
        payload.setPlanNo(code);
        payload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        CrmActPlanDO ado = CrmActPlanConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        CrmActPlanVO crmActPlanVO = CrmActPlanConvert.INSTANCE.toVo(ado);
        //保存数据到changeLog
//        changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(),crmActPlanVO,null,null);
        return crmActPlanVO;
    }

    @Transactional
    @Override
    public Long update(CrmActPlanPayload payload) {
        CrmActPlanVO planVO = dao.queryBykey(payload.getId());
        checkUpdate(planVO);
        if (WorkFlowStatusEnum.CREATE_WORK.getCode().equals(payload.getPlanStatus())) {
            //直接变更数据
            dao.updateByKeyDynamic(payload);
            //保存数据到changeLog
//            changeService.updateNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(),payload);
            if (payload.getSubmit() != null && payload.getSubmit()) {
                //走新增审批流程
                submitProc(planVO);
            }
        } else {
            //保存log版本，payload存本次更新的数据
            changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), payload, null, null);
            //发起变更流程
            if (payload.getSubmit() != null && payload.getSubmit()) {
                submitChangeProc(planVO);
            }
        }
        return 0L;
        // 待流程处理完成后再处理update
//        return dao.updateByKeyDynamic(payload);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long key) {
        CrmActPlanVO planVO = dao.queryBykey(key);
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error("", "仅新增市场计划可删除");
        }
        dao.deleteSoft(key);
        dao.deleteDetailSoft(key);
        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public PagingVO<CrmActPlanVO> paging(CrmActPlanQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> orgManageIds = daoOrg.queryByManageIdOrgIds(userId);
        // 判断当前登录人是否是系统管理员or市场管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            userId = null;
        }
        PagingVO<CrmActPlanVO> actPlanVOPagingVO = dao.queryPaging(query, userId, orgManageIds);
//        List<CrmActPlanVO> planVOS = actPlanVOPagingVO.getRecords();
//        planVOS.forEach(planVO -> {
//            updateCloseStatus(planVO);
//            planVO.setPlanStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), planVO.getPlanStatus()));
//        });
        return actPlanVOPagingVO;
    }

    @Override
    public void downloadPlans(HttpServletResponse response, CrmActPlanQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPlanBatch.xlsx");
        PagingVO<CrmActPlanVO> evo = paging(query);
        List<CrmActPlanVO> list = evo.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("市场计划");

            excelUtil.generateRangeList(batchProjectSheet, 3, 1, "组织数据", 2, "A"); // 最终客户 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 9, 1, "状态", 2, "A"); // 销售大类 数据验证

            if (!CollectionUtils.isEmpty(list) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmActPlanVO dataPayload : list) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getPlanNo());// 编号
                    excelUtil.setCellValue(row, 2, dataPayload.getPlanName());// 名称
                    excelUtil.setCellValue(row, 3, dataPayload.getOrgName());// 组织
                    excelUtil.setCellFormulas(row, 4, "VLOOKUP(D" + ExcelUtil.formulasReplace + ",组织数据!A:B,2,FALSE)");//性别编号
                    excelUtil.setCellValue(row, 5, dataPayload.getPlanYear());// 年度
                    excelUtil.setCellValue(row, 6, dataPayload.getBudgetMoney());// 预算总金额
                    excelUtil.setCellValue(row, 7, dataPayload.getLeadNum());// 预估产出线索
                    excelUtil.setCellValue(row, 8, dataPayload.getPipeline());//预估产出销售pipeline
                    excelUtil.setCellValue(row, 9, dataPayload.getPlanStatusName());//状态
                    excelUtil.setCellValue(row, 10, dataPayload.getCreateUserName());// 申请人
                    excelUtil.setCellValue(row, 11, DateTimeFormatter.ofPattern("yyyy年MM月dd日 HH时mm分ss秒").format(dataPayload.getCreateTime()));// 申请日期
                    nextRow++;
                }

            }
            // 组织数据
            List<PrdOrgOrganizationRefVO> orgList = daoOrg.queryAll(null, null, null);
            Sheet orgSheet = workbook.getSheet("组织数据");
            if (!CollectionUtils.isEmpty(orgList) && orgSheet != null) {
//                防止数据为空时断行
                int nextRow = 1;
                for (PrdOrgOrganizationRefVO org : orgList) {
                    Long addrNo = org.getOrgId();
                    String addrName = org.getOrgName();
                    if (addrNo != null && StringUtils.hasText(addrName)) {
                        Row row = orgSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, addrName);
                        excelUtil.setCellValue(row, 1, addrNo);
                        nextRow++;
                    }
                }
            }

            List<PrdSystemSelectionVO> jobList = service.selectByCondition(FunctionSelectionEnum.FlowStatus.getCode());
            Sheet jobSheet = workbook.getSheet("状态");
            if (!CollectionUtils.isEmpty(jobList) && jobSheet != null) {
                int nextRow = 1;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (StringUtils.hasText(selectionName) && StringUtils.hasText(selectionValue)) {
                        Row row = jobSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, selectionName);
                        excelUtil.setCellValue(row, 1, selectionValue);
                        nextRow++;
                    }
                }
            }

            String fileName = "市场计划数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void downloadPlanDetails(HttpServletResponse response, Long planId) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPlanDetailBatch.xlsx");
        List<CrmActPlanDetailVO> list = queryDetails(planId, null);
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("市场计划明细");

            excelUtil.generateRangeList(batchProjectSheet, 2, 2, "活动类型", 2, "A"); // 最终客户 数据验证

            if (!CollectionUtils.isEmpty(list) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmActPlanDetailVO dataPayload : list) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getDetailSeason());// 季度
                    excelUtil.setCellValue(row, 2, dataPayload.getDetailTypeName());// 活动类型
                    excelUtil.setCellValue(row, 3, dataPayload.getDetailName());// 项目
                    excelUtil.setCellValue(row, 4, dataPayload.getPersonMoney());// 人力费用
                    excelUtil.setCellValue(row, 5, dataPayload.getPersonSource());// 人力资源
                    excelUtil.setCellValue(row, 6, dataPayload.getClaimMoney());//差旅费用
                    excelUtil.setCellValue(row, 7, dataPayload.getPurchaseMoney());// 采购费用
                    excelUtil.setCellValue(row, 8, dataPayload.getSundryMoney());//杂项费用
                    excelUtil.setCellValue(row, 9, dataPayload.getTotalMoney());//费用合计
                    excelUtil.setCellValue(row, 10, dataPayload.getLeadNum());// 线索
                    excelUtil.setCellValue(row, 11, dataPayload.getPipeline());//
                    nextRow++;
                }
            }


            List<PrdSystemSelectionVO> jobList = service.selectByCondition(FunctionSelectionEnum.CrmPlanDetailType.getCode());
            Sheet jobSheet = workbook.getSheet("活动类型");
            if (!CollectionUtils.isEmpty(jobList) && jobSheet != null) {
                int nextRow = 2;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (StringUtils.hasText(selectionName) && StringUtils.hasText(selectionValue)) {
                        Row row = jobSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, selectionName);
                        excelUtil.setCellValue(row, 1, selectionValue);
                        nextRow++;
                    }
                }
            }

            String fileName = "市场计划明细数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<CrmActPlanVO> queryPlans(LocalDateTime newDate) {
//        if (LocalDateTime.now().getYear() > newDate.getYear()) {
//            throw TwException.error("", "非法的起始时间");
//        }
        return dao.queryList(newDate.getYear() + "", WorkFlowStatusEnum.APPROVED_WORK.getCode());
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public CrmActPlanVO queryByKey(Long key) {
        CrmActPlanVO planVO = dao.queryBykey(key);
//        updateCloseStatus(planVO);
        planVO.setPlanStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), planVO.getPlanStatus()));
        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(key);
        planDetailVOS.forEach(planDetailVO -> planDetailVO.setDetailTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), planDetailVO.getDetailType())));
        planVO.setPlanDetailVOS(planDetailVOS);
        return planVO;
    }

    @Transactional
    @Override
    public boolean submitCheck(Long key) {
        CrmActPlanVO planVO = dao.queryBykey(key);
        if (planVO == null) {
            throw TwException.error("", "未找到相关的市场计划");
        } else if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error("", "仅新增市场计划可操作");
        }
        submitProc(planVO);
        return true;
    }

    //时间结束，自动关闭
    @Transactional(propagation = Propagation.REQUIRED)
    public void updateCloseStatus(CrmActPlanVO planVO) {
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            if (LocalDateTime.now().getYear() > Integer.valueOf(planVO.getPlanYear())) {
                planVO.setPlanStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
                dao.updateStatus(planVO.getId(), WorkFlowStatusEnum.CLOSED_WORK.getCode(), "");
            }
        }

    }

    //修改计划状态为新建
    void updateCreateStatus(Long id) {
        CrmActPlanVO planVO = dao.queryBykey(id);
        String status = planVO.getPlanStatus();
        if (status.equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error("", "正在审批中。。。");
        }
        if (status.equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "计划已关闭");
        }
        if (!status.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            //修改
            dao.updateStatus(id, WorkFlowStatusEnum.CREATE_WORK.getCode(), "");
        }
    }

    // 判断是否可更改,市场计划是否在流程中，或者已经关闭
    String checkUpdate(Long id) {
        CrmActPlanVO planVO = dao.queryBykey(id);
        String status = planVO.getPlanStatus();
        if (status.equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error("", "正在审批中。。。");
        }
        if (status.equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "计划已关闭");
        }
        return status;
    }

    @Transactional
    @Override
    public boolean closePlan(Long key, String operateReason) {
        CrmActPlanVO planVO = dao.queryBykey(key);
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode()) || planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            String status = WorkFlowStatusEnum.CLOSED_WORK.getCode();
            if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
                status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            }
            dao.updatePlanStatus(key, status, operateReason);

        } else {
            throw TwException.error("", "不可进行该操作");
        }

        return true;
    }

    @Transactional
    @Override
    public CrmActPlanDetailVO insertDetail(CrmActPlanDetailPayload payload) {
        CrmActPlanDetailDO planDetailDO = dao.queryDetail(payload.getPlanId(), payload.getDetailSeason(), payload.getDetailType());
//        if (planDetailDO != null) {
//            throw TwException.error("", payload.getDetailSeason() + "季度已存在该类型明细");
//        }
        //获取计划状态
        String planStatus = checkUpdate(payload.getPlanId());
        //如果计划状态是新建
        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(payload.getPlanId());
        BigDecimal budgetMoney = new BigDecimal("0");
        int leadNum = 0;
        BigDecimal pipeline = new BigDecimal("0");
        for (CrmActPlanDetailVO planDetailVO : planDetailVOS) {
            budgetMoney = budgetMoney.add(planDetailVO.getTotalMoney());
//            leadNum += planDetailVO.getLeadNum();
//            pipeline = pipeline.add(planDetailVO.getPipeline());
            leadNum += planDetailVO.getLeadNum() == null ? 0 : planDetailVO.getLeadNum();
            pipeline = pipeline.add(planDetailVO.getPipeline() == null ? BigDecimal.ZERO : planDetailVO.getPipeline());
        }
        budgetMoney = budgetMoney.add(payload.getTotalMoney());
        leadNum += payload.getLeadNum() == null ? 0 : payload.getLeadNum();
        pipeline = pipeline.add(payload.getPipeline() == null ? BigDecimal.ZERO : payload.getPipeline());
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setId(payload.getPlanId());
        planPayload.setPipeline(pipeline);
        planPayload.setLeadNum(leadNum);
        planPayload.setBudgetMoney(budgetMoney);
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            //当主表还是处于新建状态时，实例化数据并且更新本版本信息
            dao.updateByKeyDynamic(planPayload);
//            changeService.updateNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(),planPayload);
        } else {
            //查询当前版本所有的新增变更列表
//            Integer currentActiveVersion = changeService.getCurrentVersion(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString());
//            Integer currentVersion = currentActiveVersion + 1;
//            List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = changeService.getChangeLogChildrenLogs(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString(), currentVersion);
            BigDecimal addTotal = budgetMoney;
//            for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
//                String versionContent = changeLogChildrenLog.getVersionContent();
//                if (versionContent != null) {
//                    Map<String, Object> contentMap = JSON.parseObject(versionContent);
//                    if (contentMap.get("totalMoney") != null) {
//                        BigDecimal totalMoney = new BigDecimal(contentMap.get("totalMoney").toString());
//                        addTotal = addTotal.add(totalMoney);
//                    }
//                }
//            }
            planPayload.setBudgetMoney(addTotal);
            changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), planPayload, null, null);
        }
        CrmActPlanDetailDO ado = CrmActPlanDetailConvert.INSTANCE.toDo(payload);
        ado.setExpenditure(new BigDecimal("0"));//已花费金额
        //当主表为新建时，直接保存
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            ado = dao.saveDetail(ado);
            return CrmActPlanDetailConvert.INSTANCE.toVo(ado);
        } else {
            CrmActPlanDetailVO crmActPlanDetailVO = CrmActPlanDetailConvert.INSTANCE.toVo(ado);
            crmActPlanDetailVO.setDetailTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), crmActPlanDetailVO.getDetailType()));
            crmActPlanDetailVO.setExpenditure(crmActPlanDetailVO.getExpenditure() == null ? BigDecimal.ZERO : crmActPlanDetailVO.getExpenditure());
            //当主表处于激活状态，子表的保存version与主表保持一致，实例化数据到数据库，同步保存v0版本的初始数据
            changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), crmActPlanDetailVO, ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString(), 0);
            return crmActPlanDetailVO;
        }
    }

    @Transactional
    @Override
    public Long updateDetail(CrmActPlanDetailPayload payload) {
//         CrmActPlanDetailDO planDetailDO = dao.queryDetail(payload.getPlanId(), payload.getDetailSeason(), payload.getDetailType());
//        if (planDetailDO != null && payload.getId().longValue() != planDetailDO.getId().longValue()) {
//            throw TwException.error("", payload.getDetailSeason() + "季度已存在该类型明细");
//        }

//        List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getId());
//        if (actActivityDOS != null && actActivityDOS.size() > 0) {
//            throw TwException.error("", "已存在市场活动项，不可编辑");
//        }
//        updateCreateStatus(payload.getPlanId());
        //获取计划状态
        String planStatus = checkUpdate(payload.getPlanId());
        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(payload.getPlanId());
        CrmActPlanDetailVO planDetailVO = planDetailVOS.stream().filter(planDetail -> planDetail.getId().longValue() == payload.getId().longValue()).findFirst().get();
        if (payload.getTotalMoney().compareTo(planDetailVO.getTotalMoney()) != 0
                || (payload.getPipeline() != null && planDetailVO.getPipeline() == null)
                || (payload.getPipeline() == null && planDetailVO.getPipeline() != null)
                || (payload.getPipeline() != null && planDetailVO.getPipeline() != null && payload.getPipeline().compareTo(planDetailVO.getPipeline()) != 0)
                || (payload.getLeadNum() != null && planDetailVO.getLeadNum() == null)
                || (payload.getLeadNum() == null && planDetailVO.getLeadNum() != null)
                || (payload.getLeadNum() != null && planDetailVO.getLeadNum() != null && !payload.getLeadNum().equals(planDetailVO.getLeadNum()))) {
            BigDecimal budgetMoney = new BigDecimal("0");
            int leadNum = 0;
            BigDecimal pipeline = new BigDecimal("0");
            for (CrmActPlanDetailVO planDetail : planDetailVOS) {
                if (planDetail.getId().longValue() != payload.getId().longValue()) {
                    budgetMoney = budgetMoney.add(planDetail.getTotalMoney());
//                    leadNum += planDetail.getLeadNum();
//                    pipeline = pipeline.add(planDetail.getPipeline());
                    leadNum += planDetail.getLeadNum() == null ? 0 : planDetail.getLeadNum();
                    pipeline = pipeline.add(planDetail.getPipeline() == null ? BigDecimal.ZERO : planDetail.getPipeline());
                }
            }
            budgetMoney = budgetMoney.add(payload.getTotalMoney());
//            leadNum += payload.getLeadNum();
//            pipeline = pipeline.add(payload.getPipeline());
            leadNum += payload.getLeadNum() == null ? 0 : payload.getLeadNum();
            pipeline = pipeline.add(payload.getPipeline() == null ? BigDecimal.ZERO : payload.getPipeline());
            CrmActPlanPayload planPayload = new CrmActPlanPayload();
            planPayload.setId(payload.getPlanId());
            planPayload.setPipeline(pipeline);
            planPayload.setLeadNum(leadNum);
            planPayload.setBudgetMoney(budgetMoney);

            if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                //当主表还是处于新建状态时，实例化数据并且更新本版本信息
                dao.updateByKeyDynamic(planPayload);
//                changeService.updateNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(),planPayload);
            } else {

                //查询当前版本所有的新增变更列表
                Integer currentActiveVersion = changeService.getCurrentActiveVersion(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString());
                Integer currentVersion = currentActiveVersion + 1;
                List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = changeService.getChangeLogChildrenLogs(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString(), currentVersion);
                BigDecimal changeTotal = budgetMoney;
                for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                    String changeContent = changeLogChildrenLog.getChangeContent();
                    if (changeContent != null) {
                        Map<String, Object> contentMap = JSON.parseObject(changeContent);
                        if (contentMap.get("totalMoney") != null) {
                            //减去当前这条数据对应的真实值，替换为新的值
                            Long planDetailId = Long.parseLong(changeLogChildrenLog.getChangeDocId());
                            CrmActPlanDetailDO crmActPlanDetailDO = dao.queryDetailById(planDetailId);
                            changeTotal = changeTotal.subtract(crmActPlanDetailDO.getTotalMoney()).add(new BigDecimal(contentMap.get("totalMoney").toString()));
                        }
                    }
                    String versionContent = changeLogChildrenLog.getVersionContent();
                    if (versionContent != null) {
                        Map<String, Object> versionMap = JSON.parseObject(versionContent);
                        if (versionMap.get("totalMoney") != null) {
                            changeTotal = changeTotal.add(new BigDecimal(versionMap.get("totalMoney").toString()));
                        }
                    }
                }
                planPayload.setBudgetMoney(changeTotal);
                //当主表处于激活状态时，更新版本信息
                changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), planPayload, null, null);
            }
        }
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            //当主表处于新建状态，子表的保存version与主表保持一致，实例化数据到数据库，同步更新v0版本的初始数据
//            changeService.updateNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(),payload);
            return dao.updateDetailByKeyDynamic(payload);
        } else {
            //当主表处于激活状态时，更新版本信息,暂不保存数据
            changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), payload, ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString());
            return -1L;
        }
    }

    @Transactional
    @Override
    public boolean deleteDetailSoft(Long planId, Long key, Long changeLogId) {
        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(planId);
        BigDecimal budgetMoney = new BigDecimal("0");
        int leadNum = 0;
        BigDecimal pipeline = new BigDecimal("0");
        for (CrmActPlanDetailVO planDetail : planDetailVOS) {
            if (key != null && planDetail.getId().longValue() != key.longValue()) {
                budgetMoney = budgetMoney.add(planDetail.getTotalMoney());
//                leadNum += planDetail.getLeadNum();
//                pipeline = pipeline.add(planDetail.getPipeline());
                leadNum += planDetail.getLeadNum() == null ? 0 : planDetail.getLeadNum();
                pipeline = pipeline.add(planDetail.getPipeline() == null ? BigDecimal.ZERO : planDetail.getPipeline());
            }
        }
//        budgetMoney = budgetMoney.subtract(payload.getTotalMoney());
//        leadNum += payload.getLeadNum();
//        pipeline = pipeline.subtract(payload.getPipeline());

        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setId(planId);
        planPayload.setPipeline(pipeline);
        planPayload.setLeadNum(leadNum);
        CrmActPlanDetailDO planDetailDO = null;
        if (key != null) {
            planDetailDO = dao.queryDetailById(key);
        }
//        budgetMoney=budgetMoney.subtract(planDetailDO.getTotalMoney());
        planPayload.setBudgetMoney(budgetMoney);

        //查询当前版本所有的变更列表
        Integer currentActiveVersion = changeService.getCurrentActiveVersion(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        Integer currentVersion = currentActiveVersion + 1;
        List<PrdSystemBusinessChangeVO> changeLogChildrenLogs = changeService.getChangeLogChildrenLogs(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString(), currentVersion);

        //走删除changeLog逻辑
        if (changeLogId != null) {
            //查询当前版本
//            PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = changeService.queryById(changeLogId);
//            String versionContent = prdSystemBusinessChangeVO.getVersionContent();
//            Map<String,Object> baseVersionContent = JSON.parseObject(versionContent);
//            moneyToSubtract = BigDecimal.valueOf(Long.parseLong(baseVersionContent.get("totalMoney").toString()));

            //计算totalMoney新增的部分
//            for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
//                String versionContent = changeLogChildrenLog.getVersionContent();
//                if (versionContent != null) {
//                    Map<String, Object> versionMap = JSON.parseObject(versionContent);
//                    if (versionMap.get("totalMoney") != null) {
//                        budgetMoney = budgetMoney.add(new BigDecimal(versionMap.get("totalMoney").toString()));
//                    }
//                }
//                String changeContent = changeLogChildrenLog.getChangeContent();
//                if (changeContent != null) {
//                    Map<String, Object> contentMap = JSON.parseObject(changeContent);
//                    if (contentMap.get("totalMoney") != null) {
//                        budgetMoney = budgetMoney.subtract(new BigDecimal(contentMap.get("totalMoney").toString()));
//                    }
//                }
//                planPayload.setBudgetMoney(budgetMoney);
//            }
            planPayload.setBudgetMoney(budgetMoney);
            //直接删除版本数据，注意与下面的删除的区别
            changeService.deleteById(changeLogId);
            //当主表处于激活状态时，更新版本信息
            changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), planPayload, null, null);
        } else {
            List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(key);
            if (actActivityDOS != null && actActivityDOS.size() > 0) {
                throw TwException.error("", "已存在市场活动项，不可删除");
            }
            CrmActPlanPayload payload = new CrmActPlanPayload();
            payload.setId(planDetailDO.getId());
            payload.setDeleteFlag(1);
            //获取计划状态
            String planStatus = checkUpdate(planDetailDO.getPlanId());
            if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                dao.updateByKeyDynamic(planPayload);
                dao.deleteDetailSoft(planId, key);
            } else {
                for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                    String versionContent = changeLogChildrenLog.getVersionContent();
                    if (versionContent != null) {
                        Map<String, Object> versionMap = JSON.parseObject(versionContent);
                        if (versionMap.get("totalMoney") != null) {
                            budgetMoney = budgetMoney.add(new BigDecimal(versionMap.get("totalMoney").toString()));
                        }
                    }
                    String changeContent = changeLogChildrenLog.getChangeContent();
                    if (changeContent != null) {
                        Map<String, Object> contentMap = JSON.parseObject(changeContent);
                        if (contentMap.get("deleteFlag").equals(1)) {
                            //获取上一个版本的数据
                            PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = changeService.mergeVersionByCurrentDocId(changeLogChildrenLog.getId());
                            String versionContent1 = prdSystemBusinessChangeVO.getVersionContent();
                            Map<String, Object> content = JSON.parseObject(versionContent1);
                            budgetMoney = budgetMoney.subtract(new BigDecimal(content.get("totalMoney").toString()));
                        }
                    }
                    planPayload.setBudgetMoney(budgetMoney);
                }
                //当主表处于激活状态时，更新版本信息
                changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), planPayload, null, null);
                //给子表信息加删除标志，并保存版本
                changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), payload, ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
            }
        }
        return true;
    }

    @Override
    public List<CrmActPlanDetailVO> queryDetails(Long planId, LocalDateTime newDate) {
        String detailSeason = "";
        if (newDate != null) {
            detailSeason = getSeason(newDate);
        }
        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(planId, detailSeason);
        planDetailVOS.forEach(planDetailVO -> {
            planDetailVO.setBalanceMoney(planDetailVO.getTotalMoney().subtract(planDetailVO.getExpenditure()));
            planDetailVO.setDetailTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), planDetailVO.getDetailType()));
        });
        return planDetailVOS;
    }

    @Override
    public Map<String, Map<String, Map<String, BigDecimal>>> queryWorkTypes() {
        List<PrdSystemWorkTypeVO> workTypeVOS = dao.queryWorkTypes();
        Map<String, Map<String, Map<String, BigDecimal>>> workTypes = new HashMap<>();
        for (PrdSystemWorkTypeVO workTypeVO : workTypeVOS) {
            String type = workTypeVO.getSysType();
            String work = workTypeVO.getSysWork();
            String level = workTypeVO.getSysLevel();
            BigDecimal unitPrice = workTypeVO.getUnitPrice();

            Map<String, Map<String, BigDecimal>> typeMap = workTypes.get(type);
            if (typeMap == null) {
                typeMap = new HashMap<>();
                workTypes.put(type, typeMap);
            }
            Map<String, BigDecimal> workType = typeMap.get(work);
            if (workType == null) {
                workType = new HashMap<>();
                typeMap.put(work, workType);
            }

            BigDecimal price = workType.get(level);
            if (price == null) {
                workType.put(level, unitPrice);
            }
        }
        return workTypes;
    }

    @Override
    public List<PrdSystemBusinessChangeVO> changeLogList(Long planId) {
        List<PrdSystemBusinessChangeVO> result = changeService.getChangeLogList(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        result.stream().forEach(e -> e.setCreateUserName(cacheUtil.getUserName(e.getCreateUserId())));
        return result;
    }


    @Override
    public Map<String, Object> changeLogDetailByPlanId(Long planId) {
        Long currentVersionId = changeService.getCurrentVersionId(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        return changeService.getChangeLogDetail(currentVersionId, null);
    }

    //    /**
//     * 查询主表的变更数据
//     * @param docId
//     * @return
//     */
//    @Override
//    public Map<String, Object> findChangeDataById(Long docId) {
//        String changeType = ChangeTypeEnum.MARKET_PLAN.getCode();
//        //查询当前的变更版本数据的id
//        PrdSystemBusinessChangeVO changeVO = changeService.findChangeDoByChangeTypeAndDocId(changeType, docId);
//        //拼装原始数据
//        CrmActPlanVO crmActPlanVO = dao.queryBykey(docId);
//        if(changeVO== null){
//            // 返回原始数据
//            return BeanUtil.beanToMap(crmActPlanVO);
//        }
//        Long changeId = changeVO.getId();
//        CrmActPlanPayload planPayload = CrmActPlanConvert.INSTANCE.toPayload(crmActPlanVO);
//        //将当前版本的数据与数据库中的数据进行对比
//        Map<String, Object> detail = changeService.compareDetail(changeId, CrmActPlanPayload.class, planPayload);
//        return detail;
//    }
//
//
//    @Override
//    public List<Map<String, Object>> findDetailsChangeDataById(Long docId,LocalDateTime newDate) {
//        //查询计划下面的详情列表
//        List<Map<String,Object>> result = new ArrayList<>();
//        List<CrmActPlanDetailVO> planDetailVOS = dao.queryDetailsByPlanId(docId);
//        String changeType = ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode();
//        //处理变更以及删除
//        for (CrmActPlanDetailVO crmActPlanDetailVO : planDetailVOS) {
//            //查询当前的变更版本数据的id
//            PrdSystemBusinessChangeVO changeDetailVO = changeService.findChangeDoByChangeTypeAndDocId(changeType, crmActPlanDetailVO.getId());
//            if(changeDetailVO==null){
//                //返回当前vo
//                result.add(BeanUtil.beanToMap(crmActPlanDetailVO));
//            }
//            CrmActPlanDetailPayload crmActPlanDetailPayload = CrmActPlanDetailConvert.INSTANCE.toPayload(crmActPlanDetailVO);
//            Map<String, Object> detail = changeService.compareDetail(changeDetailVO.getId(), CrmActPlanDetailPayload.class, crmActPlanDetailPayload);
//            result.add(detail);
//        }
//        //处理新增(null-->有值)
//        //初始值为空，的所有值
//        List<PrdSystemBusinessChangeVO> changeDosByChangeTypeAndSuperDocId = changeService.findChangeDosByChangeTypeAndSuperDocId(changeType, docId);
//        for (PrdSystemBusinessChangeVO changeVO : changeDosByChangeTypeAndSuperDocId) {
//            Map<String, Object> newDetailMap = BeanUtil.beanToMap(changeVO);
//            newDetailMap.put("changeFlag","add");
//            result.add(BeanUtil.beanToMap(changeVO));
//        }
//        return result;
//    }
//
//
    //判断是否可操作
    void checkUpdate(CrmActPlanVO planVO) {
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error("", "正在审批中。。。");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "计划已关闭");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "该活动已暂挂");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.INVALID.getCode())) {
            throw TwException.error("", "该活动已作废");
        }

    }

    String getSeason(LocalDateTime newDate) {
        int month = newDate.getMonth().getValue();
        int season = month > 9 ? 4 : month > 6 ? 3 : month > 3 ? 2 : 1;
        return "Q" + season;
    }


    /**
     * 发起新增审批流程
     *
     * @param planVO
     */
    private void submitProc(CrmActPlanVO planVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            //获取企业战略规划及发展中心（P00），二级市场部部门负责人(P1MKT)
            Long strategicCenterUserId = daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = planVO.getOrgId();
            Long planOrgManageUserId = daoOrg.queryManageIdById(orgId);
            //部门负责人审批
            variables.put("Activity_0qfet2u", CollUtil.newArrayList(planOrgManageUserId.toString()));
            //一级中心负责人
            variables.put("Activity_07qo68l", CollUtil.newArrayList(strategicCenterUserId.toString()));
            //二级市场部经理
            variables.put("Activity_1i5ts9h", CollUtil.newArrayList(marketManageUserId.toString()));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.MARKET_PLAN.name(),
                    planVO.getPlanName() + "-市场预算审批流程",
                    planVO.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setProcInstId(processInfo.getProcInstId());
        planPayload.setId(planVO.getId());
        planPayload.setProcInstStatus(processInfo.getProcInstStatus());
        planPayload.setSubmitTime(LocalDateTime.now());
        planPayload.setPlanStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(planPayload);
        });
    }


    /**
     * 发起变更审批流程
     *
     * @param planVO
     */
    private void submitChangeProc(CrmActPlanVO planVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            //获取企业战略规划及发展中心（P00），二级市场部部门负责人(P1MKT)
            Long strategicCenterUserId = daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = planVO.getOrgId();
            Long planOrgManageUserId = daoOrg.queryManageIdById(orgId);
            //部门负责人审批
            variables.put("Activity_1fpnkow", CollUtil.newArrayList(planOrgManageUserId.toString()));
            //一级中心负责人
            variables.put("Activity_191bk3m", CollUtil.newArrayList(strategicCenterUserId.toString()));
            //二级市场部经理
            variables.put("Activity_0tw90si", CollUtil.newArrayList(marketManageUserId.toString()));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.MARKET_PLAN_C.name(),
                    planVO.getPlanName() + "-市场预算变更流程",
                    planVO.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setProcInstId(processInfo.getProcInstId());
        planPayload.setId(planVO.getId());
        planPayload.setProcInstStatus(processInfo.getProcInstStatus());
        planPayload.setSubmitTime(LocalDateTime.now());
        planPayload.setPlanStatus(status);
        // 更新流程相关数据
        List<PrdSystemBusinessChangeVO> changeLogList = changeService.getChangeLogList(ChangeTypeEnum.MARKET_PLAN.getCode(), planVO.getId().toString());
        if (changeLogList != null && !changeLogList.isEmpty()) {
            PrdSystemBusinessChangeVO initVersion = new PrdSystemBusinessChangeVO();
            //TODO:后面整理一下公共方法
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogList) {
                if (prdSystemBusinessChangeVO.getVersionNo() == 0) {
                    initVersion = prdSystemBusinessChangeVO;
                }
            }
            //TODO:未更新成功
            String versionContent = initVersion.getVersionContent();
            Map<String, Object> versionContentMap = JSON.parseObject(versionContent);
            versionContentMap.put("procInsId", processInfo.getProcInstId());
            versionContentMap.put("procInstStatus", processInfo.getProcInstStatus());
            versionContent = JSON.toJSONString(versionContentMap);
            PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
            changePayload.setVersionContent(versionContent);
            changePayload.setId(initVersion.getId());
            changeDAO.updateByKeyDynamic(changePayload);
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
//            changeService.updateBusinessChange(changePayload);
            dao.updateByKeyDynamic(planPayload);
        });
    }
}
