package com.elitesland.tw.tw5.server.prd.crm.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityReviewPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityReviewQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityReviewService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityReviewVO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityReviewConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityReviewDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityReviewDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityReviewRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityReviewServiceImpl extends BaseServiceImpl implements CrmOpportunityReviewService {

    private final CrmOpportunityReviewRepo crmOpportunityReviewRepo;
    private final CrmOpportunityReviewDAO crmOpportunityReviewDAO;

    @Override
    public PagingVO<CrmOpportunityReviewVO> queryPaging(CrmOpportunityReviewQuery query) {
        return crmOpportunityReviewDAO.queryPaging(query);
    }

    @Override
    public List<CrmOpportunityReviewVO> queryListDynamic(CrmOpportunityReviewQuery query) {
        return crmOpportunityReviewDAO.queryListDynamic(query);
    }

    @Override
    public CrmOpportunityReviewVO queryByKey(Long key) {
        CrmOpportunityReviewDO entity = crmOpportunityReviewRepo.findById(key).orElseGet(CrmOpportunityReviewDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmOpportunityReviewVO vo = CrmOpportunityReviewConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOpportunityReviewVO insert(CrmOpportunityReviewPayload payload) {
        CrmOpportunityReviewDO entityDo = CrmOpportunityReviewConvert.INSTANCE.toDo(payload);
        return CrmOpportunityReviewConvert.INSTANCE.toVo(crmOpportunityReviewRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOpportunityReviewVO update(CrmOpportunityReviewPayload payload) {
        CrmOpportunityReviewDO entity = crmOpportunityReviewRepo.findById(payload.getId()).orElseGet(CrmOpportunityReviewDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmOpportunityReviewDO entityDo = CrmOpportunityReviewConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmOpportunityReviewConvert.INSTANCE.toVo(crmOpportunityReviewRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CrmOpportunityReviewPayload payload) {
        CrmOpportunityReviewDO entity = crmOpportunityReviewRepo.findById(payload.getId()).orElseGet(CrmOpportunityReviewDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = crmOpportunityReviewDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            crmOpportunityReviewDAO.deleteSoft(keys);
        }
    }

}
