package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdIndividAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdIndividAbilityVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdIndividAbilityDao;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdIndividAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdIndividAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdIndividAbilityConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdIndividAbilityServiceImpl implements PrdIndividAbilityService {


    private final PrdIndividAbilityDao prdIndividAbilityDao;

    private final PrdIndividAbilityRepo prdIndividAbilityRepo;

    private final PrdAbilityLevelService prdAbilityLevelService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdIndividAbilityVO save(PrdIndividAbilityPayload prdIndividAbilityPayload) {

        checkData(prdIndividAbilityPayload);


        // 级别明细不能重复
        if (CollUtil.isNotEmpty(prdIndividAbilityPayload.getPrdAbilityLevelPayloadList())) {
            List<Long> levelList = prdIndividAbilityPayload.getPrdAbilityLevelPayloadList().stream().map(x -> x.getLevelDtlId()).collect(Collectors.toList());
            Set<Long> levelSet = new HashSet<>(levelList);
            if (levelList.size() != levelSet.size()) {
                throw new BusinessException("级别定义明细不能重复");
            }
        }
        // 校验编码不能重复
        PrdIndividAbilityQuery prdIndividAbilityQuery = new PrdIndividAbilityQuery();
        if (StringUtils.isNotBlank(prdIndividAbilityQuery.getDocNo())) {
            prdIndividAbilityQuery.setDocNo(prdIndividAbilityPayload.getDocNo());
            Long count = prdIndividAbilityDao.count(prdIndividAbilityQuery);
            if (count > 0) {
                throw new BusinessException("编码重复，请检查");
            }
        }
        PrdIndividAbilityDO prdIndividAbilityDO = new PrdIndividAbilityDO();
        prdIndividAbilityDO = PrdIndividAbilityConvert.INSTANCE.p2d(prdIndividAbilityPayload);
        PrdIndividAbilityDO res = prdIndividAbilityRepo.save(prdIndividAbilityDO);
        // 级别定义明细
        if (CollUtil.isNotEmpty(prdIndividAbilityPayload.getPrdAbilityLevelPayloadList())) {
            for (PrdAbilityLevelPayload prdAbilityLevelPayload : prdIndividAbilityPayload.getPrdAbilityLevelPayloadList()) {
                prdAbilityLevelPayload.setAbilityId(res.getId());
                prdAbilityLevelPayload.setType(1);
                prdAbilityLevelService.save(prdAbilityLevelPayload);
            }

        }

        return PrdIndividAbilityConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdIndividAbilityVO update(PrdIndividAbilityPayload prdIndividAbilityPayload) {

        Assert.notNull(prdIndividAbilityPayload.getId(), "id is null");
        // 级别定义明细
        prdAbilityLevelService.delByAbilitId(prdIndividAbilityPayload.getId());
        PrdIndividAbilityVO res = save(prdIndividAbilityPayload);
        return res;

    }


    @Override
    public PrdIndividAbilityVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdIndividAbilityVO res = prdIndividAbilityDao.get(id);

        res.setLevelFlag(null != res.getLevelId());
        // 查询级别定义明细
        PrdAbilityLevelQuery prdAbilityLevelQuery = new PrdAbilityLevelQuery();
        prdAbilityLevelQuery.setType(1);
        prdAbilityLevelQuery.setAbilityId(id);

        List<PrdAbilityLevelVO> levelDtl = prdAbilityLevelService.getList(prdAbilityLevelQuery);
        res.setPrdAbilityLevelVOList(levelDtl);
        return res;

    }


    @Override
    public PagingVO<PrdIndividAbilityVO> page(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        PagingVO<PrdIndividAbilityVO> res = prdIndividAbilityDao.page(prdIndividAbilityQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdIndividAbilityDao.del(ids);
        return res;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateShow(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        Assert.notNull(prdIndividAbilityPayload.getId(), "id不能为空");
        Assert.notNull(prdIndividAbilityPayload.getShowFlag(), "showflag不能为空");
        Long res = prdIndividAbilityDao.updateShow(prdIndividAbilityPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateState(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        Assert.notNull(prdIndividAbilityPayload.getId(), "id不能为空");
        Assert.notNull(prdIndividAbilityPayload.getState(), "state不能为空");
        Long res = prdIndividAbilityDao.updateState(prdIndividAbilityPayload);
        return res;
    }

    @Override
    public PagingVO<PrdIndividAbilityVO> levelPage(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        prdIndividAbilityQuery.setState(1);
        PagingVO<PrdIndividAbilityVO> res = prdIndividAbilityDao.levelPage(prdIndividAbilityQuery);

        return res;
    }


    /**
     * 数据校验
     *
     * @param prdIndividAbilityPayload
     */
    private void checkData(PrdIndividAbilityPayload prdIndividAbilityPayload) {

        if (null == (prdIndividAbilityPayload.getState())) {
            throw new BusinessException("状态不能为空");
        }
        if (StringUtils.isBlank(prdIndividAbilityPayload.getName())) {
            throw new BusinessException("名称不能为空");
        }
        if (StringUtils.isBlank(prdIndividAbilityPayload.getCateType1())) {
            throw new BusinessException("分类不能为空");
        }

    }

    @Override
    public List<PrdIndividAbilityVO> levelList(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        prdIndividAbilityQuery.setState(1);
        List<PrdIndividAbilityVO> res = prdIndividAbilityDao.levelList(prdIndividAbilityQuery);

        return res;
    }
}

