package com.elitesland.tw.tw5.server.prd.humanresources.eval.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价明细表
 */
 
@Entity
@Table(name="prd_evaluate_dtl")
@org.hibernate.annotations.Table(appliesTo = "prd_evaluate_dtl", comment = "评价明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEvaluateDtlDO extends BaseModel {


    /**
     * 评价点id
     */
    @Column(name = "point_id", columnDefinition = "bigint(20) comment '评价点id'")
    private Long pointId;
    
    /**
     * 评价id
     */
    @Column(name = "eval_id", columnDefinition = "bigint(20) comment '评价id'")
    private Long evalId;
    
    /**
     * 评价单名称
     */
    @Column(name = "point_name", columnDefinition = "varchar(255) comment '评价单名称'")
    private String pointName;
    
    /**
     * 评分
     */
    @Column(name = "score", columnDefinition = "decimal(20,2) comment '评分'")
    private BigDecimal score;
    
    /**
     * 评价说明
     */
    @Column(name = "eval_desc", columnDefinition = "varchar(255) comment '评价说明'")
    private String evalDesc;
    

}

