package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核
 */
 
@Entity
@Table(name="prd_performance_exam")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam", comment = "绩效考核")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamDO extends BaseModel {


    /**
     * 考核名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '考核名称'")
    private String name;
    
    /**
     * 考核周期
     */
    @Column(name = "cycle", columnDefinition = "varchar(50) comment '考核周期'")
    private String cycle;
    
    /**
     * 开始期间
     */
    @Column(name = "start_period", columnDefinition = "date comment '开始期间'")
    private LocalDate startPeriod;
    
    /**
     * 结束期间
     */
    @Column(name = "end_period", columnDefinition = "date comment '结束期间'")
    private LocalDate endPeriod;
    
    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "varchar(50) comment '状态'")
    private String state;
    
    /**
     * 考核说明
     */
    @Column(name = "exam_desc", columnDefinition = "varchar(2000) comment '考核说明'")
    private String examDesc;
    
    /**
     * 分数下限
     */
    @Column(name = "score_min", columnDefinition = "decimal(20,2) comment '分数下限'")
    private BigDecimal scoreMin;
    
    /**
     * 分数上限
     */
    @Column(name = "score_max", columnDefinition = "decimal(20,2) comment '分数上限'")
    private BigDecimal scoreMax;
    
    /**
     * 考试结果审批人类型
     */
    @Column(name = "res_auditor_type", columnDefinition = "varchar(50) comment '考试结果审批人类型'")
    private String resAuditorType;
    
    /**
     * 考试结果审批人
     */
    @Column(name = "res_auditor", columnDefinition = "varchar(255) comment '考试结果审批人'")
    private String resAuditor;
    
    /**
     * 模板id
     */
    @Column(name = "temp_id", columnDefinition = "bigint(20) comment '模板id'")
    private Long tempId;
    

}

