package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdOrgResQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Api(tags = "资源库管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/org")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PRD_ORG_RES)
public class PersonResController {

    private final PersonResService personResService;

    private final PrdOrgEmployeeEqvaRatioService eqvaRatioServicer;

    /**
     * 查询
     *
     * @param id ID
     * @return result
     */
    @ApiOperation("id查询")
    @GetMapping("/res/{id}")
    @UdcNameClass
    public TwOutputUtil<PersonResVO> findById(@PathVariable Long id) {
        return TwOutputUtil.ok(personResService.queryById(id));
    }


    /**
     * 分页条件查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/res/paging")
    public TwOutputUtil<PagingVO<PrdOrgEmployeeVO>> queryPaging(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> paging = personResService.page(query);
        return TwOutputUtil.ok(paging);
    }


    /**
     * 分页条件查询-权限
     *
     * @param query 条件
     * @return result
     */
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PRD_ORG_RES, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation("分页条件查询-带权限查询")
    @PostMapping("/permission/res/paging")
    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdOrgEmployeeBSVO>> permissionPaging(@RequestBody PrdOrgResQuery query) {
        PagingVO<PrdOrgEmployeeBSVO> paging = personResService.permissionPaging(query);
        return TwOutputUtil.ok(paging);
    }

//    /**
//     * 修改
//     *
//     * @param personResVO
//     * @return result
//     */
//    @ApiOperation("修改")
//    @GetMapping("/res/update")
//    public TwOutputUtil update(PersonResVO personResVO) {
//        personResService.update(personResVO);
//        return TwOutputUtil.ok();
//    }

    /**
     * 获取员工内推人
     *
     * @param userId 员工userId
     * @return result
     */
    @ApiOperation("获取员工内推人")
    @GetMapping("/res/getInternalRecommUser/{userId}")
    public TwOutputUtil getJobInternalRecommId(@PathVariable Long userId) {
        return TwOutputUtil.ok(personResService.getJobInternalRecommUserId(userId));
    }

    /**
     * 获取员工范围内当量系数列表
     *
     * @param query
     * @return result
     */
    @ApiOperation("获取员工范围内当量系数列表")
    @GetMapping("/res/getEqvaRatioList")
    public TwOutputUtil<List<PrdOrgEmployeeEqvaRatioVO>> getEqvaRatioList(PrdOrgEmployeeEqvaRatioQuery query) {
        return TwOutputUtil.ok(eqvaRatioServicer.getEqvaRatioListByDate(query));
    }
//
//    /**
//     * 批量修改员工职级、当量系数
//     *
//     * @param payload
//     * @return result
//     */
//    @ApiOperation("批量修改员工职级、当量系数")
//    @PostMapping("/res/grade/batchUpsert")
//    public TwOutputUtil batchUpsert(@RequestBody PrdOrgEmployeeGradePayload payload) {
//        eqvaRatioServicer.batchUpsert(payload);
//        return TwOutputUtil.ok();
//    }

    /**
     * 保存当量系数记录
     *
     * @param payload
     * @return result
     */
    @ApiOperation("保存当量系数记录")
    @PostMapping("/res/grade/upsertEqvaRatio")
    public TwOutputUtil upsertEqvaRatio(PrdOrgEmployeeEqvaRatioPayload payload) {
        eqvaRatioServicer.upsertEqvaRatio(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 员工一键离职
     *
     * @param id
     * @return result
     */
    @ApiOperation("员工一键离职")
    @GetMapping("/res/depart")
    public TwOutputUtil depart(Long id, String date) {
        LocalDate localDateDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        personResService.depart(id, localDateDate);
        return TwOutputUtil.ok();
    }

    /**
     * userId查询
     *
     * @param userId ID
     * @return result
     */
    @ApiOperation("userId查询")
    @GetMapping("/res/queryByUserId/{userId}")
    @UdcNameClass
    public TwOutputUtil<PersonResVO> findByUserId(@PathVariable Long userId) {
        return TwOutputUtil.ok(personResService.queryByUserId(userId));
    }
}
