package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomePayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdOrgResQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.*;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonResConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonResServiceImpl implements PersonResService {
    private final PrdOrgEmployeeDAO dao;
    private final CacheUtil cacheUtil;
    private final PersonEduExperienceService personEduExperienceService;

    private final PersonWorkExperienceService personWorkExperienceService;

    private final PersonProjectExperienceService personProjectExperienceService;

    private final PersonAccountService personAccountService;


    private final PersonCertService personCertService;

    private final ResEvaluateService resEvaluateService;

    private final TaskInfoService taskInfoService;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemBusinessChangeService changeService;

    private final PrdSystemBusinessChangeDAO changeDAO;

    private final TransactionUtilService transactionUtilService;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final FileUtil fileUtil;

    private final UdcUtil udcUtil;

    private BeanSearcher beanSearcher;
    private final PrdOrgPersonDAO personDAO;

    private final PersonRewardPunishService personRewardPunishService;
    private final PrdOrgEmployeeDAO employeeDAO;

    private final UserVacationService userVacationService;

    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;

    private final ResEntryExitLogService entryExitLogService;

    private final PrdOrgEmployeeService employeeService;

    private final CalEqvaIncomeService calEqvaIncomeService;

    private final UserRpcService userRpcService;

    @Value("${tw5.user_default.role_id}")
    private Long default_role_id;

    @Value("${tw5.user_default.external_role_id}")
    private Long external_role_id;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PRD_ORG_RES);
    }

    @Autowired
    // @DubboReference
    private SysUserRpcService sysUserRpcService;

    @Override
    public PagingVO<PrdOrgEmployeeVO> page(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> evo = dao.queryPagingNew(query);
        List<PrdOrgEmployeeVO> vos = evo.getRecords();
        for (PrdOrgEmployeeVO vo : vos) {
            vo.setResourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            vo.setHrName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
            // vo.setCompanyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeCompany.getCode(), vo.getCompanyId() + ""));
            vo.setSexName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));

            vo.setIdTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeIdType.getCode(), vo.getIdType()));
            vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
            vo.setCompanyName(cacheUtil.getCompanyNameByBookId(vo.getBookId()));
        }
//        List<Long> userIds = vos.stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toList());
        return evo;
    }

    @Override
    public PersonResVO queryById(Long id) {
        PrdOrgEmployeeVO vo = dao.queryByKey(id);


        vo.setRoleDatas(dao.queryUserRoles(vo.getUserId()));
        // 组织关系
        vo.setDataRefVOS(dao.queryOrgListByKey(vo.getUserId()));
        vo.setIdValidDatas(fileUtil.getFileDatas(vo.getIdValidCodes()));
        vo.setHeadDatas(fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setResumeDatas(fileUtil.getFileDatas(vo.getResumeCodes()));
        vo.setSelfIntroVideoDatas(fileUtil.getFileDatas(vo.getSelfIntroVideoCodes()));
        vo.setResourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
        vo.setHrName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
        vo.setCompanyName(cacheUtil.getCompanyNameByBookId(vo.getBookId()));

        PersonResVO personResVO = new PersonResVO();
        vo = (PrdOrgEmployeeVO) udcUtil.translate(vo);
        if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
            vo.setExString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
        } else if (Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) {
            vo.setExString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
        }
        vo.setEqvaRatio(employeeEqvaRatioService.getEqvaRatio(vo.getUserId(), LocalDate.now()));
        personResVO.setPrdOrgEmployeeVO(vo);
        Long personId = vo.getPersonId();
        List<PersonEduExperienceVO> eduExperienceVOList = personEduExperienceService.findAllByPersonId(personId);
        personResVO.setEduExperienceVOList(eduExperienceVOList);
        //工作经历
        List<PersonWorkExperienceVO> workExperienceVOList = personWorkExperienceService.findAllByPersonId(personId);
        personResVO.setWorkExperienceVOList(workExperienceVOList);
        //项目履历
        List<PersonProjectExperienceVO> projectExperienceVOList = personProjectExperienceService.findAllByPersonId(personId);
        personResVO.setProjectExperienceVOList(projectExperienceVOList);
        //资质证书
        List<PersonCertVO> certVOList = personCertService.findAllByPersonId(personId);
        personResVO.setCertVOList(certVOList);
        //财务信息
        List<PersonAccountVO> accountVOList = personAccountService.findAllByPersonId(personId);
        personResVO.setPersonAccountVOList(accountVOList);
        //评价信息
        ResEvaluateVO resEvaluateVO = resEvaluateService.getResEvaluateScore(vo.getUserId());
        personResVO.setResEvaluateVO(resEvaluateVO);
        //奖惩信息
        List<PersonRewardPunishVO> rewardPunishVOList = personRewardPunishService.findAllByPersonId(personId);
        personResVO.setRewardPunishVOList(rewardPunishVOList);
        //任务履历
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskResId(vo.getUserId());
        List<TaskInfoVO> taskInfoVOList = taskInfoService.queryList(taskInfoQuery);
        personResVO.setTaskInfoVOList(taskInfoVOList);
        return personResVO;
    }

    @Override
    public void update(PersonResVO personResVO) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = personResVO.getPrdOrgEmployeeVO();
        PrdOrgEmployeeVO eDo = dao.queryByKey(prdOrgEmployeeVO.getId());
        PrdOrgEmployeePayload payload = PrdOrgEmployeeConvert.INSTANCE.toPayload(prdOrgEmployeeVO);
        SysUserUpdateParam param = new SysUserUpdateParam();
        Long personId = eDo.getPersonId();
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setId(eDo.getUserId());
        param.setLastName(payload.getLastName());
        param.setFirstName(payload.getEmployeeName());
        param.setMobile(payload.getMobile());
        sysUserRpcService.update(param);
        if (!eDo.getEmployeeName().equals(eDo.getEmployeeName())) {
            dao.update(payload);
        }
        if (payload.getRoleIds() != null) {
            if (payload.getRoleIds().size() == 0) {
                dao.deleteRolesByUserId(eDo.getUserId());
            } else {
                List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
                for (Long roleId : payload.getRoleIds()) {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(roleId);
                    roleDO.setUserId(eDo.getUserId());
                    userRoleDOS.add(roleDO);
                }
                dao.deleteRolesByUserId(eDo.getUserId());
                dao.saveUserRoleAll(userRoleDOS);
            }
        }
        payload.setPersonId(personId);
        dao.updatePerson(payload);
        personEduExperienceService.saveAll(personResVO.getEduExperienceVOList(), personId);
        personProjectExperienceService.saveAll(personResVO.getProjectExperienceVOList(), personId);
        personCertService.saveAll(personResVO.getCertVOList(), personId);
        personWorkExperienceService.saveAll(personResVO.getWorkExperienceVOList(), personId);
    }

    @Override
    public PersonResVO queryByUserId(Long userId) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = cacheUtil.getEmployee(userId);
        return queryById(prdOrgEmployeeVO.getId());
    }

    @Override
    @Transactional
    public Long personInfoChangeSubmit(PersonResPayload payload) {

        //发起变更流程
        submitChangeProc(payload);
        return 0L;
    }

    @Override
    @Transactional
    public void updateChange(PersonResPayload payload) {
        Long employeeId = payload.getPrdOrgEmployeePayload().getId();
        //保存log版本，payload存本次更新的数据
        PersonResVO oldVo = queryById(employeeId);
        oldVo.setId(employeeId);
        payload.setId(employeeId);
        PersonResVO resVO = PersonResConvert.INSTANCE.payloadToVo(payload);
        resVO.setPrdOrgEmployeeVO(PrdOrgEmployeeConvert.INSTANCE.toVo(payload.getPrdOrgEmployeePayload()));
        changeService.updateVersionLog(resVO, oldVo, ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
    }

    private void submitChangeProc(PersonResPayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

        HashMap<String, Object> variables = new HashMap<>();

        //档案负责人审批
        List<Long> empManageIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_0mpxlyy", CollUtil.newArrayList(empManageIds));

        // 平台薪酬绩效主管审批
        variables.put("Activity_12f105m", 0);
        Long employeeId = payload.getPrdOrgEmployeePayload().getId();
        String extString6 = payload.getPrdOrgEmployeePayload().getExtString6();
        if (Objects.equals(extString6, "EXTERNAL_RES")) {
            variables.put("externalRes", true);
            List<Long> platSalaryManager = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
            // 平台薪酬绩效主管审批
            variables.put("Activity_12f105m", CollUtil.newArrayList(platSalaryManager));
        } else {
            variables.put("externalRes", false);
        }
        //发起流程审批
        processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.PERSONAL_INFO_CHANGE.name(),
                payload.getPrdOrgEmployeePayload().getEmployeeName() + "-个人信息变更流程",
                employeeId + "",
                variables)
        );


        //流程启动成功后，回写业务表数据
//        PersonResVO resPayload = new PersonResVO();
        PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
        employeePayload.setProcInstId(processInfo.getProcInstId());
        employeePayload.setId(employeeId);
        employeePayload.setProcInstStatus(processInfo.getProcInstStatus());
        employeePayload.setSubmitTime(LocalDateTime.now());

        //保存log版本，payload存本次更新的数据
        PersonResVO oldVo = queryById(employeeId);
        oldVo.setId(employeeId);
        payload.setId(employeeId);
        PersonResVO resVO = PersonResConvert.INSTANCE.payloadToVo(payload);
        PrdOrgEmployeePayload prdOrgEmployeePayload = payload.getPrdOrgEmployeePayload();
        prdOrgEmployeePayload.setProcInstId(processInfo.getProcInstId());
        resVO.setPrdOrgEmployeeVO(PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeePayload));
        PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
        changePayload.setChangeType(ChangeTypeEnum.PERSONAL_INFO.getCode());
        changePayload.setChangeDocId(employeeId.toString());
        changePayload.setVersionContent(JSON.toJSONString(resVO));
        changePayload.setChangeContent(JSON.toJSONString(oldVo));
        changePayload.setVersionStatus(1);
        changePayload.setProcInstId(processInfo.getProcInstId());
        changeService.save(changePayload);

//        List<PrdSystemBusinessChangeVO> changeLogList = changeService.getChangeLogList(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
//        if (changeLogList != null && !changeLogList.isEmpty()) {
//            PrdSystemBusinessChangeVO initVersion = new PrdSystemBusinessChangeVO();
//            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogList) {
//                if (prdSystemBusinessChangeVO.getVersionNo() == 0) {
//                    initVersion = prdSystemBusinessChangeVO;
//                }
//            }
//            String versionContent = initVersion.getVersionContent();
//            Map<String, Object> versionContentMap = JSON.parseObject(versionContent);
//            versionContentMap.put("procInsId", processInfo.getProcInstId());
//            versionContentMap.put("procInstStatus", processInfo.getProcInstStatus());
//            versionContent = JSON.toJSONString(versionContentMap);
//            PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
//            changePayload.setVersionContent(versionContent);
//            changePayload.setId(initVersion.getId());
//            changeDAO.updateByKeyDynamic(changePayload);
//        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateProcessDate(employeePayload);
        });
    }


    @Override
    public PersonResChangeVO personalChangeInfo(Long employeeId, String procId) {

        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = changeService.getChangeLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString(), procId);
        if (!ObjectUtils.isEmpty(prdSystemBusinessChangeVO)) {
            PersonResChangeVO resChangeVO = new PersonResChangeVO();
            PersonResVO newResVo = JSON.parseObject(prdSystemBusinessChangeVO.getVersionContent(), PersonResVO.class);
            if (!ObjectUtils.isEmpty(prdSystemBusinessChangeVO.getChangeContent())) {
                PersonResVO oldResVO = JSON.parseObject(prdSystemBusinessChangeVO.getChangeContent(), PersonResVO.class);
                resChangeVO.setOldResVO(oldResVO);
            }
            resChangeVO.setNewResVO(newResVo);
            return resChangeVO;
        }
        return null;
    }

    @Override
    public Long getJobInternalRecommUserId(Long userId) {
        return dao.getJobInternalRecommUserId(userId);
    }

    @Override
    public PagingVO<PrdOrgEmployeeBSVO> permissionPaging(PrdOrgResQuery query) {

        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PrdOrgEmployeeBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<PrdOrgEmployeeBSVO> employeeVOList = beanSearcher.searchList(PrdOrgEmployeeBSVO.class, mapBuilder.build());

        for (PrdOrgEmployeeBSVO vo : employeeVOList) {
            vo.setResourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
                vo.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
            } else if (Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) {
                vo.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
            }
        }
//        List<Long> userIds = vos.stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toList());
        return PagingVO.<PrdOrgEmployeeBSVO>builder().records(employeeVOList).total((Long) totalNum).build();

    }

    @Override
    public List<Long> getJobingUserList(PrdOrgEmployeeQuery prdOrgEmployeeQuery) {
        // 查询在职数据
//        prdOrgEmployeeQuery.setResourceStatus("3");
        prdOrgEmployeeQuery.setResourceStatusIn(Arrays.asList("3", "4", "5"));
        List<Long> res = dao.getJobingUserList(prdOrgEmployeeQuery);
        return res;
    }

    /**
     * 拼装where条件
     *
     * @param query 查询条件
     * @return 检索参数构建器
     */
    private MapBuilder pageWhereBuilder(PrdOrgResQuery query) {
        MapBuilder builder = MapUtils.builder();

        if (!ObjectUtils.isEmpty(query.getResNo())) {
            builder.field(PrdOrgEmployeeBSVO::getResNo, query.getResNo()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            builder.field(PrdOrgEmployeeBSVO::getPersonName, query.getPersonName()).op(FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString6, query.getExtString6()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtString9())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString9, query.getExtString9()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            builder.field(PrdOrgEmployeeBSVO::getProcInstStatus, query.getProcInstStatus()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            builder.field(PrdOrgEmployeeBSVO::getOrgId, query.getOrgId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString5, query.getExtString5()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            builder.field(PrdOrgEmployeeBSVO::getParentId, query.getParentId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getResManagerId())) {
            builder.field(PrdOrgEmployeeBSVO::getResManagerId, query.getResManagerId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getEnrollDateStart()) && !ObjectUtils.isEmpty(query.getEnrollDateEnd())) {
            builder.field(PrdOrgEmployeeBSVO::getEnrollDate).sql(" $1 > ? and $1 < ?", query.getEnrollDateStart(), query.getEnrollDateEnd());
        }
        if (!ObjectUtils.isEmpty(query.getExtDate4Start()) && !ObjectUtils.isEmpty(query.getExtDate4End())) {
            builder.field(PrdOrgEmployeeBSVO::getExtDate4).sql(" $1 > ? and $1 < ?", query.getExtDate4Start(), query.getExtDate4End());
        }
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString1, query.getExtString1()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString2, query.getExtString2()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString3, query.getExtString3()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            builder.field(PrdOrgEmployeeBSVO::getExtString4, query.getExtString4()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            builder.field(PrdOrgEmployeeBSVO::getRemark, query.getRemark()).op(FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            builder.field(PrdOrgEmployeeBSVO::getResourceStatus, query.getResourceStatus()).op(FieldOps.Equal);
        }
        builder.field(PrdOrgEmployeeBSVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    @Transactional
    public void updateEmployee(PrdOrgEmployeePayload payload) {

        UserCreateDTO param = new UserCreateDTO();
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setId(payload.getUserId());
        param.setFullName(payload.getEmployeeName());
        param.setMobile(payload.getMobile());
        param.setUsername(payload.getUserName());
        userRpcService.upsert(param);
        PrdOrgPersonDO personSaveDO = personDAO.findByKey(payload.getPersonId());
        if (payload.getEmail() != null) {
            personSaveDO.setEmail(payload.getEmail());
        }
        if (payload.getMobile() != null) {
            personSaveDO.setMobile(payload.getMobile());
        }
        if (payload.getUserName() != null) {
            personSaveDO.setUserName(payload.getUserName());
        }
        if (payload.getEnabled() != null) {
            personSaveDO.setEnabled(payload.getEnabled());
        }
        dao.savePerson(personSaveDO);
        dao.update(payload);
        dao.deleteRolesByUserId(payload.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        dao.deleteRefSoft(Collections.singletonList(payload.getUserId()));
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(payload.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        //外部资源默认初始化外部资源角色
        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
        if (Objects.equals(payload.getExtString6(), "EXTERNAL_RES")) {
            roleDO.setRoleId(external_role_id);
        }
        roleDO.setUserId(payload.getUserId());
        dao.saveUserRole(roleDO);
        dao.saveRef(refDo);

    }

    @Override
    @Transactional
    public void depart(Long id, LocalDate date) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = employeeDAO.queryByKey(id);
        //离职中
        if (StringUtils.hasText(prdOrgEmployeeVO.getResourceStatus()) && SystemDefaultEnum.LeaveIngResourceStatus.getCode().equals(prdOrgEmployeeVO.getResourceStatus())) {
            throw TwException.error("", "当前员工已处于离职中，请前往处理离职申请列表处理离职流程");
        }
        employeeDAO.updateResStatus(id, SystemDefaultEnum.LeavedResourceStatus.getCode());
        //禁用账号
        SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
        List<Long> userIds = new ArrayList<>();
        userIds.add(prdOrgEmployeeVO.getUserId());
        sysUserBatchSwitchParam.setEnable(false);
        sysUserBatchSwitchParam.setUserIds(userIds);
        sysUserRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
        //删除假期
        userVacationService.deleteAllByUserId(prdOrgEmployeeVO.getUserId());
        //保存离职信息
        employeeDAO.updateExitDate(id, date);
        //保存离职记录
        ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
        resEntryExitLogPayload.setEntryExitDate(date.toString());
        resEntryExitLogPayload.setEmployeeId(id);
        resEntryExitLogPayload.setReasonType1("LEAVE_BY_HR");
        resEntryExitLogPayload.setReasonType2("LEAVE");
        resEntryExitLogPayload.setResType(prdOrgEmployeeVO.getExtString6());
        resEntryExitLogPayload.setBookId(prdOrgEmployeeVO.getBookId());
        resEntryExitLogPayload.setOrgId(prdOrgEmployeeVO.getOrgId());
        resEntryExitLogPayload.setBaseCity(prdOrgEmployeeVO.getExtString5());
        resEntryExitLogPayload.setCoopType(prdOrgEmployeeVO.getCooperationMode());
        resEntryExitLogPayload.setJob(prdOrgEmployeeVO.getJobs());
        entryExitLogService.save(resEntryExitLogPayload);
        //删除组织关系
        employeeService.deleteOrgRefSoftAll(prdOrgEmployeeVO.getUserId(), date);
        // 如果是外部员工的话 需要将外部当量收入配置改为失效 并且在变更记录表插入数据
        if ("EXTERNAL_RES".equals(prdOrgEmployeeVO.getExtString6())) {
            CalEqvaIncomePayload payload = new CalEqvaIncomePayload();
            payload.setLineStatus("0");
            payload.setEndDate(date);
            calEqvaIncomeService.saveExterEqvaIncome(payload);
        }
    }
}
