package com.elitesland.tw.tw5.server.prd.inv.service;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceDetailService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceDetailConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceDetailDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDetailDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceDetailRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvInvoiceDetailServiceImpl extends BaseServiceImpl implements InvInvoiceDetailService {

    private final InvInvoiceDetailRepo invInvoiceDetailRepo;
    private final InvInvoiceDetailDAO invInvoiceDetailDAO;

    @Override
    public PagingVO<InvInvoiceDetailVO> queryPaging(InvInvoiceDetailQuery query){
        return invInvoiceDetailDAO.queryPaging(query);
    }

    @Override
    public List<InvInvoiceDetailVO> queryListDynamic(InvInvoiceDetailQuery query){
        return invInvoiceDetailDAO.queryListDynamic(query);
    }

    @Override
    public InvInvoiceDetailVO queryByKey(Long key) {
        InvInvoiceDetailDO entity = invInvoiceDetailRepo.findById(key).orElseGet(InvInvoiceDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceDetailVO vo = InvInvoiceDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceDetailVO insert(InvInvoiceDetailPayload payload) {
        InvInvoiceDetailDO entityDo = InvInvoiceDetailConvert.INSTANCE.toDo(payload);
        return InvInvoiceDetailConvert.INSTANCE.toVo(invInvoiceDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceDetailVO update(InvInvoiceDetailPayload payload) {
        InvInvoiceDetailDO entity = invInvoiceDetailRepo.findById(payload.getId()).orElseGet(InvInvoiceDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceDetailDO entityDo = InvInvoiceDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceDetailConvert.INSTANCE.toVo(invInvoiceDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvInvoiceDetailPayload payload) {
        InvInvoiceDetailDO entity = invInvoiceDetailRepo.findById(payload.getId()).orElseGet(InvInvoiceDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invInvoiceDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invInvoiceDetailDAO.deleteSoft(keys);
        }
    }

}
