package com.elitesland.tw.tw5.server.prd.mpxj.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.mpxj.service.MpxjMppConstsServiceImpl;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequiredArgsConstructor
@RequestMapping("/api/mpp")
@Slf4j
public class MpxjMppController {
    private final MpxjMppConstsServiceImpl service;

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport/{projectId}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file, @PathVariable Long projectId) {
        service.importElecPlanTask(file, projectId);
        return TwOutputUtil.ok();
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/batchExport/{projectId}")
    public void batchExport(HttpServletResponse response, @PathVariable Long projectId) {
        service.exportElecPlanTask(response, projectId);
    }

}
