package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRemarkPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRemarkQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRemarkVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceRemarkDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRemarkDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRemarkRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;


@Repository
@RequiredArgsConstructor
public class TAttendanceRemarkDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TAttendanceRemarkRepo repo;
    private final QTAttendanceRemarkDO qdo = QTAttendanceRemarkDO.tAttendanceRemarkDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceRemarkVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TAttendanceRemarkVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 打卡人员
                qdo.attendanceResId,
                // 打卡ID
                qdo.tAttendanceNormalId,
                // 打卡日期
                qdo.attendanceDate,
                // 打卡异常说明
                qdo.attendanceAbnormalDesc,
                // 申请时间
                qdo.applyDatetime,
                // 审批人员
                qdo.reportToResId,
                // 审批结果
                qdo.approvalResult,
                // 审批时间
                qdo.approvalDatetime,
                // 审批拒绝原因
                qdo.rejectedCause
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceRemarkVO> getJpaQueryWhere(TAttendanceRemarkQuery query) {
        JPAQuery<TAttendanceRemarkVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TAttendanceRemarkQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TAttendanceRemarkQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 打卡人员 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceResId())) {
            list.add(qdo.attendanceResId.eq(query.getAttendanceResId()));
        }
        /** 打卡ID 精确 */
        if (!ObjectUtils.isEmpty(query.getTAttendanceNormalId())) {
            list.add(qdo.tAttendanceNormalId.eq(query.getTAttendanceNormalId()));
        }
        /** 打卡日期 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDate())) {
            list.add(qdo.attendanceDate.eq(query.getAttendanceDate()));
        }
        /** 打卡异常说明 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceAbnormalDesc())) {
            list.add(qdo.attendanceAbnormalDesc.eq(query.getAttendanceAbnormalDesc()));
        }
        /** 申请时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDatetime())) {
            list.add(qdo.applyDatetime.eq(query.getApplyDatetime()));
        }
        /** 审批人员 精确 */
        if (!ObjectUtils.isEmpty(query.getReportToResId())) {
            list.add(qdo.reportToResId.eq(query.getReportToResId()));
        }
        /** 审批结果 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalResult())) {
            list.add(qdo.approvalResult.eq(query.getApprovalResult()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalDatetime())) {
            list.add(qdo.approvalDatetime.eq(query.getApprovalDatetime()));
        }
        /** 审批拒绝原因 精确 */
        if (!ObjectUtils.isEmpty(query.getRejectedCause())) {
            list.add(qdo.rejectedCause.eq(query.getRejectedCause()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TAttendanceRemarkVO queryByKey(Long id) {
        JPAQuery<TAttendanceRemarkVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TAttendanceRemarkVO> queryListDynamic(TAttendanceRemarkQuery query) {
        JPAQuery<TAttendanceRemarkVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TAttendanceRemarkVO> queryPaging(TAttendanceRemarkQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TAttendanceRemarkVO> jpaQuery = getJpaQueryWhere(query);
        List<TAttendanceRemarkVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TAttendanceRemarkVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TAttendanceRemarkDO save(TAttendanceRemarkDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TAttendanceRemarkDO> saveAll(List<TAttendanceRemarkDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TAttendanceRemarkPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 打卡人员
        if (payload.getAttendanceResId() != null) {
            update.set(qdo.attendanceResId, payload.getAttendanceResId());
        }
        // 打卡ID
        if (payload.getTAttendanceNormalId() != null) {
            update.set(qdo.tAttendanceNormalId, payload.getTAttendanceNormalId());
        }
        // 打卡日期
        if (payload.getAttendanceDate() != null) {
            update.set(qdo.attendanceDate, payload.getAttendanceDate());
        }
        // 打卡异常说明
        if (payload.getAttendanceAbnormalDesc() != null) {
            update.set(qdo.attendanceAbnormalDesc, payload.getAttendanceAbnormalDesc());
        }
        // 申请时间
        if (payload.getApplyDatetime() != null) {
            update.set(qdo.applyDatetime, payload.getApplyDatetime());
        }
        // 审批人员
        if (payload.getReportToResId() != null) {
            update.set(qdo.reportToResId, payload.getReportToResId());
        }
        // 审批结果
        if (payload.getApprovalResult() != null) {
            update.set(qdo.approvalResult, payload.getApprovalResult());
        }
        // 审批时间
        if (payload.getApprovalDatetime() != null) {
            update.set(qdo.approvalDatetime, payload.getApprovalDatetime());
        }
        // 审批拒绝原因
        if (payload.getRejectedCause() != null) {
            update.set(qdo.rejectedCause, payload.getRejectedCause());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 打卡人员
            if (nullFields.contains("attendanceResId")) {
                update.setNull(qdo.attendanceResId);
            }
            // 打卡ID
            if (nullFields.contains("tAttendanceNormalId")) {
                update.setNull(qdo.tAttendanceNormalId);
            }
            // 打卡日期
            if (nullFields.contains("attendanceDate")) {
                update.setNull(qdo.attendanceDate);
            }
            // 打卡异常说明
            if (nullFields.contains("attendanceAbnormalDesc")) {
                update.setNull(qdo.attendanceAbnormalDesc);
            }
            // 申请时间
            if (nullFields.contains("applyDatetime")) {
                update.setNull(qdo.applyDatetime);
            }
            // 审批人员
            if (nullFields.contains("reportToResId")) {
                update.setNull(qdo.reportToResId);
            }
            // 审批结果
            if (nullFields.contains("approvalResult")) {
                update.setNull(qdo.approvalResult);
            }
            // 审批时间
            if (nullFields.contains("approvalDatetime")) {
                update.setNull(qdo.approvalDatetime);
            }
            // 审批拒绝原因
            if (nullFields.contains("rejectedCause")) {
                update.setNull(qdo.rejectedCause);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public Long queryByAttendanceNormalId(Long attendanceNormalId) {
        return jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(qdo.tAttendanceNormalId.eq(attendanceNormalId))
                .fetchOne();
    }

}

