package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetBiweeklyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetReportFormVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetBiweeklyReadFlagDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2023/3/21 - 8:49
 */
@Repository
@RequiredArgsConstructor
public class TimesheetBiweeklyDAO {
    private static final QPrdOrgEmployeeDO qdo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QTimesheetBiweeklyReadFlagDO qdoBiweeklyRead = QTimesheetBiweeklyReadFlagDO.timesheetBiweeklyReadFlagDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 拼装周报查询条件
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetBiweeklyVO> getJpaQuerySelect(Long readUserId) {
        return jpaQueryFactory.select(Projections.bean(TimesheetBiweeklyVO.class,
                        qdo.id,
                        qdoRef.orgId.as("tsbBuId"),//双周计划
                        qdo.employeeName.concat("周报").as("title"),//标题
                        qdoBiweeklyRead.readFlag.as("isRead"),//是否已读
                        qdo.userId.as("createUserId"),//姓名
                        qdo.remark
                )).from(qdo)
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
//                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))1
                .leftJoin(qdoBiweeklyRead).on(qdoBiweeklyRead.userId.longValue().eq(qdo.userId).and(qdoBiweeklyRead.readUserId.longValue().eq(readUserId)));
    }
    /**
     * 拼装周报报表查询条件
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetReportFormVO> getJpaQueryFormSelect() {
        return jpaQueryFactory.select(Projections.bean(TimesheetReportFormVO.class,
                        qdo.id,
                        qdoRef.orgId.as("tsbBuId"),//部门id
                        qdo.userId.as("tsUserId"),//姓名
                        qdo.remark,
                        qdoOrg.organizationType
                )).from(qdo)
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoRef.orgId.eq(qdoOrg.id).and(qdoOrg.deleteFlag.eq(0)));
    }


    /**
     * 查询周报列表
     * @param query
     * @return
     */
    public PagingVO<TimesheetBiweeklyVO> queryListBiweekly(TimesheetBiweeklyQuery query) {
        JPAQuery<TimesheetBiweeklyVO> jpaQuery = getJpaQuerySelect(query.getReadUserId());
        if (!CollectionUtils.isEmpty(query.getUserIdList())) {
            jpaQuery.where(qdo.userId.in(query.getUserIdList()));
        }
        // 不需要校验是哪一周的，只记录状态
//        if (!ObjectUtils.isEmpty(query.getYearWeek())) {
//            jpaQuery.where(qdoBiweeklyRead.yearWeek.isNull().or(qdoBiweeklyRead.yearWeek.eq(query.getYearWeek())));
//        }
        //提交人
        if (!ObjectUtils.isEmpty(query.getTsUserId())){
            jpaQuery.where(qdo.userId.eq(query.getTsUserId()));
        }
//        //读取人
//        if (!ObjectUtils.isEmpty(query.getReadUserId())){
//            jpaQuery.where(qdoBiweeklyRead.readUserId.isNull().or(qdoBiweeklyRead.readUserId.eq(query.getReadUserId())));
//        }
        //提交人部门
        if (!ObjectUtils.isEmpty(query.getTsbBuId())){
            jpaQuery.where(qdoRef.orgId.eq(query.getTsbBuId()));
        }
        //状态
        if (!ObjectUtils.isEmpty(query.getIsRead())){
            if (query.getIsRead()==1){
                jpaQuery.where(qdoBiweeklyRead.readFlag.eq(query.getIsRead()));
            }else{
                jpaQuery.where(qdoBiweeklyRead.readFlag.isNull().or(qdoBiweeklyRead.readFlag.eq(query.getIsRead())));
            }

        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        QueryResults<TimesheetBiweeklyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        result.getResults().stream().forEach(e->e.setIsRead(e.getIsRead()==null?0:e.getIsRead()));
        return PagingVO.<TimesheetBiweeklyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 查询周报列表
     * @param query
     * @return
     */
    public PagingVO<TimesheetReportFormVO> queryTimesheetReport(TimesheetBiweeklyQuery query) {
        JPAQuery<TimesheetReportFormVO> jpaQuery = getJpaQueryFormSelect();
        if (!CollectionUtils.isEmpty(query.getUserIdList())) {
            jpaQuery.where(qdo.userId.in(query.getUserIdList()));
        }
        //提交人
        if (!ObjectUtils.isEmpty(query.getTsUserId())){
            jpaQuery.where(qdo.userId.eq(query.getTsUserId()));
        }
        //部门及子部门
        if (!ObjectUtils.isEmpty(query.getTsbBuId())){
            jpaQuery.where(qdoRef.orgId.in(query.getOrgIdList()));
        }
        //部门类型
        if (StringUtils.hasText(query.getOrganizationType())){
            jpaQuery.where(qdoOrg.organizationType.eq(query.getOrganizationType()));
        }
        //只查询在职、离职中、BaseBU变更中的人员
        jpaQuery.where(qdo.resourceStatus.in("3","4","5"));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.id);
        QueryResults<TimesheetReportFormVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<TimesheetReportFormVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}
