package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.VacationQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.VacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;

/**
 * @author sunxw
 * @description 假期
 * @Date 2023/5/9
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class VacationServiceImpl implements VacationService {

    private final VacationDAO vacationDAO;
    private final VacationRepo vacationRepo;

    private final PersonResService personResService;
    private final PmsTimesheetService pmsTimesheetService;
    private final CacheUtil cacheUtil;


    @Override
    public Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate) {
        return vacationRepo.selectWorkHoursByDate(startDate, endDate);
    }

    @Override
    public List<VacationVO> findListByYear(int year) {
        List<VacationDO> vacationDOList = vacationRepo.selectByYear(year);
        List<VacationVO> voList = new ArrayList<>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties(vacationDO, vo);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<VacationVO> findVacationList(VacationQuery query) {
        List<VacationDO> vacationDOList = vacationRepo.selectByQuery(query);
        List<VacationVO> voList = new ArrayList<>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties(vacationDO, vo);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public void saveVacation(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setWorkHours(8F);
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties(vacation, vacationDO);
            int count = vacationRepo.updateVacationByKey(vacationDO);
            if (count == 0) {
                vacationRepo.save(vacationDO);
            }
        });
    }

    @Override
    public void saveJdeExport(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setJdeExportFlag((byte) 1);
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties(vacation, vacationDO);
            int count = vacationRepo.updateJdeExportFlagByKey(vacationDO);
            if (count == 0) {
                vacationRepo.save(vacationDO);
            }
        });
    }

    @Override
    public long findWorkDay(LocalDate startDate, LocalDate endDate) {

        long res = vacationDAO.findWorkDay(startDate, endDate);
        return res;
    }

    @Override
    public List<LocalDate> findWorkLocalDay(LocalDate startDate, LocalDate endDate) {
        return vacationDAO.findWorkLocalDay(startDate,endDate);
    }

    @Override
    @Transactional
    public void taskGenerateTimesheet(String param) {
        LocalDate today = LocalDate.now();
        if(StringUtils.hasText(param)){
            try{
                today = LocalDate.parse(param, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }catch (Exception e){
            }

        }
        LocalDate monthDayFirst = today.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate monthDayLast = today.with(TemporalAdjusters.lastDayOfMonth());
        // 获取当月的节假日工时
        List<LocalDate> vacationDay = findVacationDay(monthDayFirst, monthDayLast);

        // 获取所有在职的员工
        PrdOrgEmployeeQuery prdOrgEmployeeQuery = new PrdOrgEmployeeQuery();
        List<Long> empUserList = personResService.getJobingUserList(prdOrgEmployeeQuery);

        // 批量插入工时
        List<TimesheetPayload> timesheetPayloadList = new ArrayList<>();

        if (!CollectionUtils.isEmpty(vacationDay)) {
            // 判断法定假期内是否已填写工时
            TimesheetQuery queryWeek = new TimesheetQuery();
            queryWeek.setWorkDateIn(vacationDay);
            final List<TimesheetVO> timeSheets = pmsTimesheetService.queryList(queryWeek);
            for (Long userId : empUserList) {
                natural:
                for (LocalDate naturalDate : vacationDay) {
                    timesheet:
                    for (TimesheetVO timesheetListView : timeSheets) {
                        if (timesheetListView.getWorkDate().equals(naturalDate) && timesheetListView.getTsUserId().equals(userId)) {
                            // 填写过的，不处理
                            continue natural;
                        }
                    }
                    // 没有填写的话 自动填写并自动提交
                    TimesheetPayload entity = new TimesheetPayload();
                    // 申请人
                    entity.setTsUserId(userId);
                    entity.setWorkDate(naturalDate);
                    entity.setWorkDesc("法定假日");
                    entity.setTsStatus(TimesheetStatus.APPROVING.getCode());
                    entity.setApprResult(TimesheetStatus.APPROVING.getDesc());
                    entity.setProjId(0L);
                    entity.setTaskPackageId(null);
                    entity.setTaskId(null);
                    entity.setActId(null);
                    entity.setTsTaskIden("VACATION");
                    entity.setTsActIden("LEGALHOLIDAY");
                    entity.setWorkHour(new BigDecimal("8.0"));
                    entity.setWorkDayOffStatus("UNGEN");
                    entity.setWorkFlag("NO");
                    entity.setSettleStatus("NONE");
                    entity.setWeekStartDate(naturalDate.with(DayOfWeek.MONDAY));
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(naturalDate)));
                    Long tsBuId = cacheUtil.getDefaultOrgIdByUserId(userId);
                    entity.setTsUserBuId(tsBuId);
                    // 审批人
                    // entity.setApprResId(findApprResId(entity));
                    // 审批人 设置为 系统自动处理
                    entity.setApprUserId(1381L);
                    entity.setAutoSaveFlag(1);
                    entity.setSubmitTime(LocalDateTime.now());
                    // 添加到容器中
                    timesheetPayloadList.add(entity);
                }
            }
        }

        pmsTimesheetService.saveAllForAutoCreate(timesheetPayloadList);


    }

    @Override
    public List<LocalDate> findVacationDay(LocalDate startDate, LocalDate endDate) {

        List<LocalDate> res = vacationDAO.findVacationDay(startDate, endDate);
        return res;
    }

}
