package com.elitesland.tw.tw5.server.prd.office.util.file;

import com.elitesland.tw.tw5.server.prd.office.models.enums.DocumentType;

import java.nio.file.Path;
import java.util.List;

// specify the file utility functions
public interface FileUtility {
    /**
     * 得到文档类型
     *
     * @param fileName 文件名称
     * @return {@link DocumentType}
     */
    DocumentType getDocumentType(String fileName);

    String getFileName(String url);  // get file name from its URL
    String getFileNameWithoutExtension(String url);  // get file name without extension
    String getFileExtension(String url);  // get file extension from URL
    String getInternalExtension(DocumentType type);  // get an editor internal extension
    List<String> getFileExts();  // get all the supported file extensions
    List<String> getFillExts();  // get file extensions that can be filled
    List<String> getViewedExts();  // get file extensions that can be viewed
    List<String> getEditedExts();  // get file extensions that can be edited
    List<String> getConvertExts();  // get file extensions that can be converted
    Path generateFilepath(String directory, String fullFileName);  // generate the file path from file directory and name
    long getMaxFileSize();  // get maximum file size
}
