package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonDetailVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@Api(tags = "人才库管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/org")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PRD_ORG_PERSON)
public class PrdOrgPersonController {

    private final PrdOrgPersonService personService;

    /**
     * 分页条件查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/person/paging")
    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdOrgPersonVO>> queryPaging(PrdOrgPersonQuery query) {
        PagingVO<PrdOrgPersonVO> paging = personService.paging(query);
        return TwOutputUtil.ok(paging);
    }


    @ApiOperation("权限-分页条件查询")
    @PostMapping("/permission/person/paging")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PRD_ORG_PERSON, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PrdOrgPersonBSVO>> permissionPaging(@RequestBody PrdOrgPersonQuery query) {
        PagingVO<PrdOrgPersonBSVO> paging = personService.permissionPaging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 新增
     *
     * @param entity 条件
     * @return result
     */
    @ApiOperation("保存基本信息")
    @PostMapping("/person/insert")
    public TwOutputUtil<Long> insert(@RequestBody PrdOrgPersonPayload entity) {

        return TwOutputUtil.ok(personService.insert(entity));
    }

    /**
     * 修改
     *
     * @param entity 条件
     * @return result
     */
    @ApiOperation("修改信息")
    @PostMapping("/person/update")
    public TwOutputUtil update(@RequestBody PrdOrgPersonDetailVO entity) {
        personService.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 查询
     *
     * @param id ID
     * @return result
     */
    @ApiOperation("id查询")
    @GetMapping("/person/{id}")
    public TwOutputUtil<PrdOrgPersonDetailVO> findById(@PathVariable Long id) {
        return TwOutputUtil.ok(personService.findById(id));
    }


    /**
     * 删除
     *
     * @param id ID
     * @return result
     */
    @ApiOperation("删除")
    @DeleteMapping("/person/delete/{id}")
    public TwOutputUtil deleteById(@PathVariable Long id) {
        personService.deleteById(id);
        return TwOutputUtil.ok();
    }

    /**
     * offer入职发放
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("offer入职发放")
    @PutMapping("/person/entry")
    @GlobalTransactional
    public TwOutputUtil personEntry(@RequestBody PrdOrgEmployeePayload entity) {
        personService.personEntry(entity);
        return TwOutputUtil.ok();
    }

    /**
     * offer入职发放信息变更
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("offer入职发放信息修改")
    @PutMapping("/person/entry/update")
    @GlobalTransactional
    public TwOutputUtil personEntryUpdate(@RequestBody PrdOrgEmployeePayload entity) {
        personService.personEntryUpdate(entity);
        return TwOutputUtil.ok();
    }

    /**
     * offer入职发放信息变更
     *
     * @param procId
     * @return result
     */
    @ApiOperation("offer入职发放信息查询")
    @GetMapping("/person/entry/query/{procId}")
    public TwOutputUtil<PrdOrgEmployeePayload> personEntryQuery(@PathVariable String procId) {
        return TwOutputUtil.ok(personService.personEntryQuery(procId));
    }


    /**
     * 移入黑名单
     *
     * @param id
     * @return result
     */
    @ApiOperation("移入黑名单")
    @GetMapping("/employee/inBlack/{id}")
    public TwOutputUtil inBlackList(@PathVariable Long id) {
        personService.inBlackList(id);
        return TwOutputUtil.ok();
    }

    /**
     * 移出黑名单
     *
     * @param id
     * @return result
     */
    @ApiOperation("移出黑名单")
    @GetMapping("/employee/outBlack/{id}")
    public TwOutputUtil outBlackList(@PathVariable Long id) {
        personService.outBlackList(id);
        return TwOutputUtil.ok();
    }

    /**
     * 黑名单列表
     *
     * @param query
     * @return result
     */
    @ApiOperation("黑名单列表")
    @GetMapping("/employee/blackList")
    public TwOutputUtil queryBlackList(EmployeeBlackListQuery query) {
        return TwOutputUtil.ok(personService.queryBlackList(query));
    }

    /**
     * offer入职申请列表分页
     *
     * @param query
     * @return result
     */
    @ApiOperation("offer入职申请列表分页")
    @GetMapping("/offer/page")
    @UdcNameClass
    public TwOutputUtil<PagingVO<OfferEntryApplyVO>> offerApplyPage(OfferEntryApplyQuery query) {
        return TwOutputUtil.ok(personService.offerApplyPage(query));
    }

    /**
     * offer入职申请详情
     *
     * @param applyId
     * @return result
     */
    @ApiOperation("offer入职申请列表分页")
    @GetMapping("/offer/queryBykey/{applyId}")
    @UdcNameClass
    public TwOutputUtil<OfferEntryApplyVO> offerApplyPage(@PathVariable Long applyId) {
        return TwOutputUtil.ok(personService.queryOfferByKey(applyId));
    }
}
