package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.*;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemUserRoleRepo;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdOrgSyncDataDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgOrganizationRepo repoOrg;
    private final PrdOrgOrganizationRefRepo repoOrgRef;
    private final PrdOrgRoleRepo roleRepo;

    private final PrdOrgEmployeeRefRepo orgEmployeeRefRepo;
    private final PrdOrgEmployeeRepo orgEmployeeRepo;
    private final PrdOrgPersonRepo orgPersonRepo;
    private final PrdSystemUserRoleRepo sysUserRoleRepo;
    private final QPrdOrgOrganizationDO qdoOrg = new QPrdOrgOrganizationDO("prdOrgOrganizationDO");
    private final QPrdOrgOrganizationRefDO qdoOrgRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;

    /**
     * 调用jpa的保存
     *
     * @param dos do对象
     * @return 保存后的对象
     */
    public List<PrdOrgEmployeeRefDO> saveOrgEmployeeRefAll(List<PrdOrgEmployeeRefDO> dos) {
        return orgEmployeeRefRepo.saveAll(dos);
    }

    /**
     * 调用jpa的保存
     *
     * @param dos do对象
     * @return 保存后的对象
     */
    public List<PrdOrgOrganizationDO> saveOrganizationAll(List<PrdOrgOrganizationDO> dos) {
        return repoOrg.saveAll(dos);
    }

    /**
     * 调用jpa的保存
     *
     * @param dos do对象
     * @return 保存后的对象
     */
    public List<PrdOrgOrganizationRefDO> saveOrganizationRefAll(List<PrdOrgOrganizationRefDO> dos) {
        return repoOrgRef.saveAll(dos);
    }

    /**
     * 调用jpa的保存
     *
     * @param userRoleDOS do对象
     * @return 保存后的对象
     */
    public List<PrdSystemUserRoleDO> saveUserRoleAll(List<PrdSystemUserRoleDO> userRoleDOS) {
        return sysUserRoleRepo.saveAll(userRoleDOS);
    }

    /**
     * 调用jpa的保存
     *
     * @param employeeDOS do对象
     * @return 保存后的对象
     */
    public List<PrdOrgEmployeeDO> saveEmployeeAll(List<PrdOrgEmployeeDO> employeeDOS) {
        return orgEmployeeRepo.saveAll(employeeDOS);
    }

    /**
     * 调用jpa的保存
     *
     * @param personDOS do对象
     * @return 保存后的对象
     */
    public List<PrdOrgPersonDO> savePersonAll(List<PrdOrgPersonDO> personDOS) {
        return orgPersonRepo.saveAll(personDOS);
    }

    /**
     * 调用jpa的保存
     *
     * @param dos do对象
     * @return 保存后的对象
     */
    public List<PrdOrgRoleDO> saveOrgRoleAll(List<PrdOrgRoleDO> dos) {
        return roleRepo.saveAll(dos);
    }

    /**
     * 获取所有组织
     *
     * @return 结果
     */
    public List<PrdOrgOrganizationDO> queryOrgAll() {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdoOrg).from(qdoOrg);
        return jpaQuery.fetch();
    }

    /**
     * 获取所有组织
     *
     * @return 结果
     */
    public List<PrdOrgOrganizationRefDO> queryOrgRefs(Long dimensionId, List<Long> orgIds) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoOrgRef).from(qdoOrgRef);
        jpaQuery.where(qdoOrgRef.dimensionId.eq(dimensionId)).where(qdoOrgRef.orgId.in(orgIds));

        return jpaQuery.fetch();
    }
}
