package com.elitesland.tw.tw5.server.prd.pay.controller;

import com.elitesland.tw.tw5.api.prd.pay.service.BKGetVerificationCodeService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 银企直连-获取验证码
 *
 * @folder 银企直连-获取验证码
 * @author wangly
 * @date 2024-05-10
 */
@Api(tags = "银企直连-获取验证码")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/twbank")
@Slf4j
public class BKGetVerificationCodeController {

    private final BKGetVerificationCodeService bkGetVerificationCodeService;

    /**
     * 获取验证码
     *
     * @folder 获取验证码
     */
    @GetMapping("/getVerificationCode")
    @ApiOperation("银企直连-获取验证码")
    public TwOutputUtil getVerificationCode(){
        bkGetVerificationCodeService.getVerificationCode();
        return TwOutputUtil.ok();
    }

    /**
     * 获取验证码
     *
     * @folder 获取验证码
     */
    @GetMapping("/ConfirmVerificationCode")
    @ApiOperation("银企直连-验证验证码")
    public TwOutputUtil<String> confirmVerificationCode(String verificationCode){
        bkGetVerificationCodeService.confirmVerificationCode(verificationCode);
        return TwOutputUtil.ok();
    }
}
