package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ExternalRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ExternalRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ExternalRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ExternalRelatedPartiesVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 外部相关方
 */
@RestController
@RequestMapping("/api/externalRelatedParties")
@RequiredArgsConstructor
@Api(value = "外部相关方", tags = {"外部相关方"})
public class ExternalRelatedPartiesController {

   private final ExternalRelatedPartiesService externalRelatedPartiesService;


   @GetMapping("get")
   @ApiOperation("详情-外部相关方")
   public TwOutputUtil<ExternalRelatedPartiesVO> get(Long id) {

       ExternalRelatedPartiesVO res = externalRelatedPartiesService.get(id);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("save")
   @ApiOperation("新增-外部相关方")
   public TwOutputUtil<Long> save(@RequestBody ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {

       ExternalRelatedPartiesVO res = externalRelatedPartiesService.save(externalRelatedPartiesPayload);
       return TwOutputUtil.ok(res.getId());

   }


   @PostMapping("update")
   @ApiOperation("修改-外部相关方")
   public TwOutputUtil<Long> update(@RequestBody ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {

       Long res = externalRelatedPartiesService.update(externalRelatedPartiesPayload);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("del")
   @ApiOperation("删除-外部相关方")
   public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

       Long res = externalRelatedPartiesService.del(ids);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("page")
   @UdcNameClass
   @ApiOperation("分页查询-外部相关方")
   public TwOutputUtil<PagingVO<ExternalRelatedPartiesVO>> page(@RequestBody ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       PagingVO<ExternalRelatedPartiesVO> res = externalRelatedPartiesService.page(externalRelatedPartiesQuery);
       return TwOutputUtil.ok(res);

   }



   @GetMapping("getList")
   @ApiOperation("列表查询-外部相关方")
   public TwOutputUtil<List<ExternalRelatedPartiesVO>> getList(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       List<ExternalRelatedPartiesVO> res = externalRelatedPartiesService.getList(externalRelatedPartiesQuery);
       return TwOutputUtil.ok(res);

   }


}

