package com.elitesland.tw.tw5.server.prd.personplan.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsRelatedHistoryPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsRelatedHistoryQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsRelatedHistoryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsRelatedHistoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 相关方变化历史记录
 *
 * @author wangxl
 * @date 2024/3/18
 */
@RestController
@RequestMapping( "/common/pmsRelatedHistory")
@RequiredArgsConstructor
@Slf4j
@Api(value = "相关方变化历史记录", tags = {"相关方变化历史记录"})
public class PmsRelatedHistoryController {

    private final PmsRelatedHistoryService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsRelatedHistoryVO>> page(PmsRelatedHistoryQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsRelatedHistoryVO>> list(PmsRelatedHistoryQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsRelatedHistoryVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsRelatedHistoryVO> insert(@RequestBody PmsRelatedHistoryPayload payload) {
        // 关键日志打印
        log.debug("【PmsRelatedHistoryController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsRelatedHistoryVO> update(@RequestBody PmsRelatedHistoryPayload payload) {
        // 关键日志打印
        log.debug("【PmsRelatedHistoryController.update】入参：" + payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsRelatedHistoryVO> updateDynamic(@RequestBody PmsRelatedHistoryPayload payload) {
        // 关键日志打印
        log.debug("【PmsRelatedHistoryController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsRelatedHistoryController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}