package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.CheckoutProRelatedRemoveVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方
 */
@RestController
@RequestMapping("/api/proRelatedParties")
@RequiredArgsConstructor
@Api(value = "项目相关方", tags = {"项目相关方"})
public class ProRelatedPartiesController {

    private final ProRelatedPartiesService proRelatedPartiesService;


    @GetMapping("get")
    @ApiOperation("详情-项目相关方")
    public TwOutputUtil<ProRelatedPartiesVO> get(Long id) {

        ProRelatedPartiesVO res = proRelatedPartiesService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-项目相关方")
    public TwOutputUtil<Long> save(@RequestBody ProRelatedPartiesPayload proRelatedPartiesPayload) {

        ProRelatedPartiesVO res = proRelatedPartiesService.save(proRelatedPartiesPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-项目相关方")
    public TwOutputUtil<Long> update(@RequestBody ProRelatedPartiesPayload proRelatedPartiesPayload) {

        Long res = proRelatedPartiesService.update(proRelatedPartiesPayload, null);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("del")
    @ApiOperation("删除-项目相关方")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

        Long res = proRelatedPartiesService.del(ids);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("checkoutRemove")
    @ApiOperation("校验任务是否需要移除-项目相关方")
    public TwOutputUtil<CheckoutProRelatedRemoveVO> checkoutRemove(Long[] ids) {
        return TwOutputUtil.ok(proRelatedPartiesService.checkoutRemoveRelated(Arrays.asList(ids)));
    }


    @PostMapping("page")
    @UdcNameClass
    @ApiOperation("分页查询-项目相关方")
    public TwOutputUtil<PagingVO<ProRelatedPartiesVO>> page(@RequestBody ProRelatedPartiesQuery proRelatedPartiesQuery) {

        PagingVO<ProRelatedPartiesVO> res = proRelatedPartiesService.page(proRelatedPartiesQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("列表查询-项目相关方")
    public TwOutputUtil<List<ProRelatedPartiesVO>> getList(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<ProRelatedPartiesVO> res = proRelatedPartiesService.getList(proRelatedPartiesQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("importDate")
    @ApiOperation("列表查询-导入项目相关方")
    public TwOutputUtil<List<ProRelatedPartiesVO>> iportForm(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<ProRelatedPartiesVO> res = proRelatedPartiesService.iportForm(proRelatedPartiesQuery);
        return TwOutputUtil.ok(res);

    }


    /**
     * 相关方的项目分页列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("relatePaging")
    // @UdcNameClass
    @ApiOperation("相关方的项目分页列表")
    public TwOutputUtil<PagingVO<ProRelatedPartiesVO>> relatePaging(ProRelatedPartiesQuery query) {

        return TwOutputUtil.ok(proRelatedPartiesService.relatePaging(query));
    }

}

