package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.ProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QProRelatedPartiesDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方RepoProc
 */
@Component
public class ProRelatedPartiesDao extends BaseRepoProc<ProRelatedPartiesDO> {

    private static final QProRelatedPartiesDO qProRelatedPartiesDO = QProRelatedPartiesDO.proRelatedPartiesDO;


    protected ProRelatedPartiesDao() {

        super(qProRelatedPartiesDO);

    }


    public PagingVO<ProRelatedPartiesVO> page(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        JPAQuery<ProRelatedPartiesVO> query =
                select(ProRelatedPartiesVO.class)
                        .where(bulidPredicate(proRelatedPartiesQuery));
        proRelatedPartiesQuery.setPaging(query);
        proRelatedPartiesQuery.fillOrders(query, qProRelatedPartiesDO);
        return PagingVO.<ProRelatedPartiesVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qProRelatedPartiesDO)
                .set(qProRelatedPartiesDO.deleteFlag, 1)
                .where(qProRelatedPartiesDO.id.in(ids))
                .execute();

        return res;

    }


    public ProRelatedPartiesVO get(Long id) {

        ProRelatedPartiesVO proRelatedPartiesVO = select(ProRelatedPartiesVO.class)
                .where(qProRelatedPartiesDO.id.eq(id))
                .fetchOne();

        return proRelatedPartiesVO;

    }


    public List<ProRelatedPartiesVO> getList(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<ProRelatedPartiesVO> res =
                select(ProRelatedPartiesVO.class)
                        .where(bulidPredicate(proRelatedPartiesQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qProRelatedPartiesDO.proId,
                        qProRelatedPartiesDO.userId,
                        qProRelatedPartiesDO.externalId,
                        qProRelatedPartiesDO.name,
                        qProRelatedPartiesDO.relatedType,
                        qProRelatedPartiesDO.proRole,
                        qProRelatedPartiesDO.phone,
                        qProRelatedPartiesDO.email,
                        qProRelatedPartiesDO.ouId,
                        qProRelatedPartiesDO.ouCode,
                        qProRelatedPartiesDO.ouName,
                        qProRelatedPartiesDO.ext1,
                        qProRelatedPartiesDO.ext2,
                        qProRelatedPartiesDO.ext3,
                        qProRelatedPartiesDO.ext4,
                        qProRelatedPartiesDO.type,
                        qProRelatedPartiesDO.id,
                        qProRelatedPartiesDO.createTime,
                        qProRelatedPartiesDO.remark,
                        qProRelatedPartiesDO.eqvaRatio,
                        qProRelatedPartiesDO.buName

                )).from(qProRelatedPartiesDO);

    }


    private Predicate bulidPredicate(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != proRelatedPartiesQuery.getProId(), qProRelatedPartiesDO.proId, proRelatedPartiesQuery.getProId())
                .andEq(null != proRelatedPartiesQuery.getUserId(), qProRelatedPartiesDO.userId, proRelatedPartiesQuery.getUserId())
                .andEq(null != proRelatedPartiesQuery.getExternalId(), qProRelatedPartiesDO.externalId, proRelatedPartiesQuery.getExternalId())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getName()), qProRelatedPartiesDO.name, proRelatedPartiesQuery.getName())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getRelatedType()), qProRelatedPartiesDO.relatedType, proRelatedPartiesQuery.getRelatedType())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getProRole()), qProRelatedPartiesDO.proRole, proRelatedPartiesQuery.getProRole())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getPhone()), qProRelatedPartiesDO.phone, proRelatedPartiesQuery.getPhone())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getEmail()), qProRelatedPartiesDO.email, proRelatedPartiesQuery.getEmail())
                .andEq(null != proRelatedPartiesQuery.getOuId(), qProRelatedPartiesDO.ouId, proRelatedPartiesQuery.getOuId())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getOuCode()), qProRelatedPartiesDO.ouCode, proRelatedPartiesQuery.getOuCode())
                .andEq(StringUtils.isNotBlank(proRelatedPartiesQuery.getOuName()), qProRelatedPartiesDO.ouName, proRelatedPartiesQuery.getOuName())
                .andEq(null != proRelatedPartiesQuery.getExt1(), qProRelatedPartiesDO.ext1, proRelatedPartiesQuery.getExt1())
                .andEq(null != proRelatedPartiesQuery.getExt2(), qProRelatedPartiesDO.ext2, proRelatedPartiesQuery.getExt2())
                .andEq(null != proRelatedPartiesQuery.getExt3(), qProRelatedPartiesDO.ext3, proRelatedPartiesQuery.getExt3())
                .andEq(null != proRelatedPartiesQuery.getExt4(), qProRelatedPartiesDO.ext4, proRelatedPartiesQuery.getExt4())
                .andEq(null != proRelatedPartiesQuery.getType(), qProRelatedPartiesDO.type, proRelatedPartiesQuery.getType())
                .andEq(null != proRelatedPartiesQuery.getBuName(), qProRelatedPartiesDO.buName, proRelatedPartiesQuery.getBuName())
                .andIn(null != proRelatedPartiesQuery.getIdList(), qProRelatedPartiesDO.id, proRelatedPartiesQuery.getIdList())
                .andIn(null != proRelatedPartiesQuery.getUserIdList(), qProRelatedPartiesDO.userId, proRelatedPartiesQuery.getUserIdList())
                .andNotIn(!CollectionUtils.isEmpty(proRelatedPartiesQuery.getNotInUserId()), qProRelatedPartiesDO.userId, proRelatedPartiesQuery.getNotInUserId())
                .build();
        return predicate;
    }


    private Predicate bulidPredicates(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 项目id
        if (null != proRelatedPartiesQuery.getProId()) {
            predicates.add(qProRelatedPartiesDO.proId.eq(proRelatedPartiesQuery.getProId()));
        }
        if (null != proRelatedPartiesQuery.getIdList()) {
            predicates.add(qProRelatedPartiesDO.id.in(proRelatedPartiesQuery.getIdList()));
        }
        // 用户id
        if (null != proRelatedPartiesQuery.getUserId()) {
            predicates.add(qProRelatedPartiesDO.userId.eq(proRelatedPartiesQuery.getUserId()));
        }
        // 外部相关方id
        if (null != proRelatedPartiesQuery.getExternalId()) {
            predicates.add(qProRelatedPartiesDO.externalId.eq(proRelatedPartiesQuery.getExternalId()));
        }
        // 相关方名称
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getName())) {
            predicates.add(qProRelatedPartiesDO.name.eq(proRelatedPartiesQuery.getName()));
        }
        // 相关方类型
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getRelatedType())) {
            predicates.add(qProRelatedPartiesDO.relatedType.eq(proRelatedPartiesQuery.getRelatedType()));
        }
        // 项目角色
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getProRole())) {
            predicates.add(qProRelatedPartiesDO.proRole.eq(proRelatedPartiesQuery.getProRole()));
        }
        // 联系电话
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getPhone())) {
            predicates.add(qProRelatedPartiesDO.phone.eq(proRelatedPartiesQuery.getPhone()));
        }
        // 邮箱
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getEmail())) {
            predicates.add(qProRelatedPartiesDO.email.eq(proRelatedPartiesQuery.getEmail()));
        }
        // 公司id
        if (null != proRelatedPartiesQuery.getOuId()) {
            predicates.add(qProRelatedPartiesDO.ouId.eq(proRelatedPartiesQuery.getOuId()));
        }
        // 公司编码
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getOuCode())) {
            predicates.add(qProRelatedPartiesDO.ouCode.eq(proRelatedPartiesQuery.getOuCode()));
        }
        // 公司名称
        if (StringUtils.isNotEmpty(proRelatedPartiesQuery.getOuName())) {
            predicates.add(qProRelatedPartiesDO.ouName.eq(proRelatedPartiesQuery.getOuName()));
        }
        // 利益相关程度
        if (null != proRelatedPartiesQuery.getExt1()) {
            predicates.add(qProRelatedPartiesDO.ext1.eq(proRelatedPartiesQuery.getExt1()));
        }
        // 权利程度
        if (null != proRelatedPartiesQuery.getExt2()) {
            predicates.add(qProRelatedPartiesDO.ext2.eq(proRelatedPartiesQuery.getExt2()));
        }
        // 情感倾向
        if (null != proRelatedPartiesQuery.getExt3()) {
            predicates.add(qProRelatedPartiesDO.ext3.eq(proRelatedPartiesQuery.getExt3()));
        }
        // 参与度
        if (null != proRelatedPartiesQuery.getExt4()) {
            predicates.add(qProRelatedPartiesDO.ext4.eq(proRelatedPartiesQuery.getExt4()));
        }
        // 类型0内部相关方 1外部相关方
        if (null != proRelatedPartiesQuery.getType()) {
            predicates.add(qProRelatedPartiesDO.type.eq(proRelatedPartiesQuery.getType()));
        }
        // 所属部门
        if (null != proRelatedPartiesQuery.getBuName()) {
            predicates.add(qProRelatedPartiesDO.buName.eq(proRelatedPartiesQuery.getBuName()));
        }
        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        long res = select(ProRelatedPartiesVO.class)
                .where(bulidPredicates(proRelatedPartiesQuery))
                .fetchCount();

        return res;


    }

    public Long update(ProRelatedPartiesPayload proRelatedPartiesPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qProRelatedPartiesDO);

        // 项目id
        if (null != proRelatedPartiesPayload.getProId()) {
            update.set(qProRelatedPartiesDO.proId,proRelatedPartiesPayload.getProId());
        }
        // 用户id
        if (null != proRelatedPartiesPayload.getUserId()) {
            update.set(qProRelatedPartiesDO.userId,proRelatedPartiesPayload.getUserId());
        }
        // 外部相关方id
        if (null != proRelatedPartiesPayload.getExternalId()) {
            update.set(qProRelatedPartiesDO.externalId,proRelatedPartiesPayload.getExternalId());
        }
        // 相关方名称
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getName())) {
            update.set(qProRelatedPartiesDO.name,proRelatedPartiesPayload.getName());
        }
        // 相关方类型
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getRelatedType())) {
            update.set(qProRelatedPartiesDO.relatedType,proRelatedPartiesPayload.getRelatedType());
        }
        // 项目角色
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getProRole())) {
            update.set(qProRelatedPartiesDO.proRole,proRelatedPartiesPayload.getProRole());
        }
        // 联系电话
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getPhone())) {
            update.set(qProRelatedPartiesDO.phone,proRelatedPartiesPayload.getPhone());
        }
        // 邮箱
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getEmail())) {
            update.set(qProRelatedPartiesDO.email,proRelatedPartiesPayload.getEmail());
        }
        // 公司id
        if (null != proRelatedPartiesPayload.getOuId()) {
            update.set(qProRelatedPartiesDO.ouId,proRelatedPartiesPayload.getOuId());
        }
        // 公司编码
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getOuCode())) {
            update.set(qProRelatedPartiesDO.ouCode,proRelatedPartiesPayload.getOuCode());
        }
        // 公司名称
        if (StringUtils.isNotEmpty(proRelatedPartiesPayload.getOuName())) {
            update.set(qProRelatedPartiesDO.ouName,proRelatedPartiesPayload.getOuName());
        }
        // 利益相关程度
        if (null != proRelatedPartiesPayload.getExt1()) {
            update.set(qProRelatedPartiesDO.ext1,proRelatedPartiesPayload.getExt1());
        }
        // 权利程度
        if (null != proRelatedPartiesPayload.getExt2()) {
            update.set(qProRelatedPartiesDO.ext2,proRelatedPartiesPayload.getExt2());
        }
        // 情感倾向
        if (null != proRelatedPartiesPayload.getExt3()) {
            update.set(qProRelatedPartiesDO.ext3,proRelatedPartiesPayload.getExt3());
        }
        // 参与度
        if (null != proRelatedPartiesPayload.getExt4()) {
            update.set(qProRelatedPartiesDO.ext4,proRelatedPartiesPayload.getExt4());
        }
        // 类型0内部相关方 1外部相关方
        if (null != proRelatedPartiesPayload.getType()) {
            update.set(qProRelatedPartiesDO.type,proRelatedPartiesPayload.getType());
        }
        // 所属部门
        if (null != proRelatedPartiesPayload.getBuName()) {
            update.set(qProRelatedPartiesDO.buName,proRelatedPartiesPayload.getBuName());
        }
        if (null != proRelatedPartiesPayload.getRemark()) {
            update.set(qProRelatedPartiesDO.remark,proRelatedPartiesPayload.getRemark());
        }
        if (null != proRelatedPartiesPayload.getEqvaRatio()) {
            update.set(qProRelatedPartiesDO.eqvaRatio,proRelatedPartiesPayload.getEqvaRatio());
        }
        long res = update.where(qProRelatedPartiesDO.id.eq(proRelatedPartiesPayload.getId()))
                .execute();
        return res;

    }

}

