package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 外部相关方
 */
@Entity
@Table(name = "external_related_parties")
@org.hibernate.annotations.Table(appliesTo = "external_related_parties", comment = "外部相关方")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExternalRelatedPartiesDO extends BaseModel {


   /**
    * 相关方名称
    */
   @Column(name = "name", columnDefinition = "varchar(255) comment '相关方名称'")
   private String name;

   /**
    * 相关方类型
    */
   @Column(name = "type", columnDefinition = "varchar(50) comment '相关方类型'")
   private String type;

   /**
    * 联系方式
    */
   @Column(name = "phone", columnDefinition = "varchar(255) comment '联系方式'")
   private String phone;

   /**
    * 电子邮箱
    */
   @Column(name = "email", columnDefinition = "varchar(255) comment '电子邮箱'")
   private String email;

   /**
    * 公司编码
    */
   @Column(name = "ou_code", columnDefinition = "varchar(50) comment '公司编码'")
   private String ouCode;
    /**
     * 公司名称
     */
    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;
   /**
    * 部门id
    */
   @Column(name = "bu_id", columnDefinition = "bigint(20) comment '部门id'")
   private Long buId;

   /**
    * 部门编码
    */
   @Column(name = "bu_code", columnDefinition = "varchar(50) comment '部门编码'")
   private String buCode;

   /**
    * 部门名称
    */
   @Column(name = "bu_name", columnDefinition = "varchar(255) comment '部门名称'")
   private String buName;



}

