package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRolePayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PmsProjectRoleConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsProjectRoleRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 项目角色
 *
 * @author xxb
 * @date 2023-07-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectRoleServiceImpl extends BaseServiceImpl implements PmsProjectRoleService {

    private final PmsProjectRoleRepo pmsProjectRoleRepo;
    private final PmsProjectRoleDAO pmsProjectRoleDAO;

    private final PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO;

    @Override
    public PagingVO<PmsProjectRoleVO> queryPaging(PmsProjectRoleQuery query) {
        return pmsProjectRoleDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectRoleVO> queryListDynamic(PmsProjectRoleQuery query) {
        return pmsProjectRoleDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectRoleVO queryByKey(Long key) {
        PmsProjectRoleDO entity = pmsProjectRoleRepo.findById(key).orElseGet(PmsProjectRoleDO::new);
        Assert.notNull(entity.getId(), "项目角色不存在");
        PmsProjectRoleVO vo = PmsProjectRoleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectRoleVO insert(PmsProjectRolePayload payload) {
        //数据验证
        checkData(payload);
        PmsProjectRoleDO entityDo = PmsProjectRoleConvert.INSTANCE.toDo(payload);
        return PmsProjectRoleConvert.INSTANCE.toVo(pmsProjectRoleRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectRoleVO update(PmsProjectRolePayload payload) {
        //数据验证
        checkData(payload);
        PmsProjectRoleDO entity = pmsProjectRoleRepo.findById(payload.getId()).orElseGet(PmsProjectRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectRoleDO entityDo = PmsProjectRoleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectRoleConvert.INSTANCE.toVo(pmsProjectRoleRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectRolePayload payload) {
        //数据验证
        checkData(payload);
//        PmsProjectRoleDO entity = pmsProjectRoleRepo.findById(payload.getId()).orElseGet(PmsProjectRoleDO::new);
//        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectRoleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "角色主键不能为空，请核验！");
        }
        pmsProjectRoleDAO.deleteSoft(keys);
        // 角色删除的同时   角色分配表也删除
        pmsProjectRoleAssignmentDAO.deleteByRoleIds(keys);
    }

    /**
     * 数据验证
     *
     * @param payload
     */
    void checkData(PmsProjectRolePayload payload) {
        //验证非空
        if (ObjectUtils.isEmpty(payload.getRoleCode())) {
            throw TwException.error("", "角色编号不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getRoleName())) {
            throw TwException.error("", "角色名称不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getUnitPrice())) {
            throw TwException.error("", "平均单价不能为空，请核验！");
        }

        //验证科目重复
        if (ObjectUtils.isEmpty(payload.getId())) {
            PmsProjectRoleVO vo = pmsProjectRoleDAO.queryByRoleCode(payload.getRoleCode());
            if (!ObjectUtils.isEmpty(vo)) {
                throw TwException.error("", "角色编号不可重复，请核验！");
            }
            vo = pmsProjectRoleDAO.queryByRoleName(payload.getRoleName());
            if (!ObjectUtils.isEmpty(vo)) {
                throw TwException.error("", "角色名称不可重复，请核验！");
            }
        } else {
            PmsProjectRoleVO vo = pmsProjectRoleDAO.queryByKey(payload.getId());
            if (!payload.getRoleCode().equals(vo.getRoleCode())) {
                vo = pmsProjectRoleDAO.queryByRoleCode(payload.getRoleCode());
                if (!ObjectUtils.isEmpty(vo)) {
                    throw TwException.error("", "角色编号不可重复，请核验！");
                }
            }
            if (!payload.getRoleName().equals(vo.getRoleName())) {
                vo = pmsProjectRoleDAO.queryByRoleName(payload.getRoleName());
                if (!ObjectUtils.isEmpty(vo)) {
                    throw TwException.error("", "角色名称不可重复，请核验！");
                }
            }
        }
        //平均单价 保留两位小数
        payload.setUnitPrice(payload.getUnitPrice().setScale(2));
    }

}
