package com.elitesland.tw.tw5.server.prd.personplan.service;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ResourceCostStrategyPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ResourceCostStrategyVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ResourceCostStrategyDao;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.ResourceCostStrategyService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * 资源成本策略service impl
 * @author wangxl
 * @date 2024/4/2
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ResourceCostStrategyServiceImpl implements ResourceCostStrategyService {

    private final ResourceCostStrategyDao dao;

    @Override
    public TwOutputUtil<PagingVO<ResourceCostStrategyVO>> queryPage(ResourceCostStrategyQuery query) {
        PagingVO<ResourceCostStrategyVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<ResourceCostStrategyVO>> queryList(ResourceCostStrategyQuery query) {
        List<ResourceCostStrategyVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(ResourceCostStrategyQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<ResourceCostStrategyVO> queryByKey(Long id) {
        if (null == id) {return null;}
        ResourceCostStrategyVO vo = dao.queryByKey(id);
        Assert.notNull(vo,"查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<ResourceCostStrategyVO> insert(ResourceCostStrategyPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        ResourceCostStrategyVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<ResourceCostStrategyVO> update(ResourceCostStrategyPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        ResourceCostStrategyVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<ResourceCostStrategyVO> updateDynamic(ResourceCostStrategyPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }


    /**
     * 发起工作流
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(ResourceCostStrategyPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(ResourceCostStrategyPayload payload) {
    }

    /**
     * todo
     * @param vos vos
     */
    private void translate(List<ResourceCostStrategyVO> vos){
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}